/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.permissions;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.permissions.ConsolePermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BukkitPermissionHandler
implements PermissionHandler {
    @Override
    public void initialize() {
    }

    @Override
    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull PlotPlayer<?> plotPlayer) {
        if (plotPlayer instanceof BukkitPlayer) {
            BukkitPlayer bukkitPlayer = (BukkitPlayer)plotPlayer;
            return Optional.of(new BukkitPermissionProfile(bukkitPlayer.getPlatformPlayer()));
        }
        if (plotPlayer instanceof ConsolePlayer) {
            return Optional.of(ConsolePermissionProfile.INSTANCE);
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull OfflinePlotPlayer offlinePlotPlayer) {
        return Optional.empty();
    }

    @Override
    public @NonNull Set<PermissionHandler.PermissionHandlerCapability> getCapabilities() {
        return EnumSet.of(PermissionHandler.PermissionHandlerCapability.ONLINE_PERMISSIONS);
    }

    private static final class BukkitPermissionProfile
    implements PermissionProfile {
        private final WeakReference<Player> playerReference;

        private BukkitPermissionProfile(@NonNull Player player) {
            this.playerReference = new WeakReference<Player>(player);
        }

        @Override
        public boolean hasPermission(@Nullable String string, @NonNull String string2) {
            Player player = (Player)this.playerReference.get();
            return player != null && player.hasPermission(string2);
        }

        @Override
        public boolean hasKeyedPermission(@Nullable String string, @NonNull String string2, @NonNull String string3) {
            Player player = (Player)this.playerReference.get();
            return player != null && (player.hasPermission(string2 + "." + string3) || player.hasPermission(string2 + ".*"));
        }
    }
}

