/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.placeholder;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import com.google.common.eventbus.Subscribe;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.util.placeholders.Placeholder;
import com.plotsquared.core.util.placeholders.PlaceholderRegistry;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MVdWPlaceholders {
    private static final String PREFIX = "plotsquared_";
    private final Plugin plugin;
    private final PlaceholderRegistry registry;

    public MVdWPlaceholders(@NonNull Plugin plugin, @NonNull PlaceholderRegistry placeholderRegistry) {
        this.plugin = plugin;
        this.registry = placeholderRegistry;
        for (Placeholder placeholder : placeholderRegistry.getPlaceholders()) {
            this.addPlaceholder(placeholder);
        }
        PlotSquared.get().getEventDispatcher().registerListener(this);
    }

    @Subscribe
    public void onNewPlaceholder(@NonNull PlaceholderRegistry.PlaceholderAddedEvent placeholderAddedEvent) {
        this.addPlaceholder(placeholderAddedEvent.placeholder());
    }

    private void addPlaceholder(@NonNull Placeholder placeholder) {
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)(PREFIX + String.format("%s", placeholder.getKey())), placeholderReplaceEvent -> {
            if (!placeholderReplaceEvent.isOnline() || placeholderReplaceEvent.getPlayer() == null) {
                return "";
            }
            BukkitPlayer bukkitPlayer = BukkitUtil.adapt(placeholderReplaceEvent.getPlayer());
            String string = placeholderReplaceEvent.getPlaceholder().substring(PREFIX.length());
            return this.registry.getPlaceholderValue(string, bukkitPlayer);
        });
    }
}

