/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.player;

import com.plotsquared.bukkit.player.BukkitOfflinePlayer;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitPlayerManager
extends PlayerManager<BukkitPlayer, Player> {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final PermissionHandler permissionHandler;

    @Inject
    public BukkitPlayerManager(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PermissionHandler permissionHandler) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.permissionHandler = permissionHandler;
    }

    @Override
    public @NonNull BukkitPlayer getPlayer(@NonNull Player player) {
        if (player.getUniqueId().version() == 2) {
            return new BukkitPlayer(this.plotAreaManager, this.eventDispatcher, player, false, this.permissionHandler);
        }
        if (!player.isOnline()) {
            throw new PlayerManager.NoSuchPlayerException(player.getUniqueId());
        }
        return (BukkitPlayer)this.getPlayer(player.getUniqueId());
    }

    @Override
    public @NonNull BukkitPlayer createPlayer(@NonNull UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null || !player.isOnline()) {
            throw new PlayerManager.NoSuchPlayerException(uUID);
        }
        return new BukkitPlayer(this.plotAreaManager, this.eventDispatcher, player, false, this.permissionHandler);
    }

    @Override
    public @Nullable BukkitOfflinePlayer getOfflinePlayer(@Nullable UUID uUID) {
        if (uUID == null) {
            return null;
        }
        return new BukkitOfflinePlayer(Bukkit.getOfflinePlayer((UUID)uUID), this.permissionHandler);
    }

    @Override
    public @NonNull BukkitOfflinePlayer getOfflinePlayer(@NonNull String string) {
        return new BukkitOfflinePlayer(Bukkit.getOfflinePlayer((String)string), this.permissionHandler);
    }
}

