/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.plotsquared.bukkit.schematic.StateWrapper;
import com.plotsquared.bukkit.util.BukkitBlockUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.inject.factory.ChunkCoordinatorBuilderFactory;
import com.plotsquared.core.inject.factory.ChunkCoordinatorFactory;
import com.plotsquared.core.queue.BasicQueueCoordinator;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.LocalChunk;
import com.plotsquared.core.util.ChunkUtil;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitQueueCoordinator
extends BasicQueueCoordinator {
    private static final SideEffectSet NO_SIDE_EFFECT_SET = SideEffectSet.none().with(SideEffect.LIGHTING, SideEffect.State.OFF).with(SideEffect.NEIGHBORS, SideEffect.State.OFF);
    private static final SideEffectSet EDGE_SIDE_EFFECT_SET = SideEffectSet.none().with(SideEffect.UPDATE, SideEffect.State.ON).with(SideEffect.NEIGHBORS, SideEffect.State.ON);
    private static final SideEffectSet LIGHTING_SIDE_EFFECT_SET = SideEffectSet.none().with(SideEffect.NEIGHBORS, SideEffect.State.OFF);
    private static final SideEffectSet EDGE_LIGHTING_SIDE_EFFECT_SET = SideEffectSet.none().with(SideEffect.UPDATE, SideEffect.State.ON).with(SideEffect.NEIGHBORS, SideEffect.State.ON);
    private org.bukkit.World bukkitWorld;
    @Inject
    private ChunkCoordinatorBuilderFactory chunkCoordinatorBuilderFactory;
    @Inject
    private ChunkCoordinatorFactory chunkCoordinatorFactory;
    private ChunkCoordinator chunkCoordinator;

    @Inject
    public BukkitQueueCoordinator(@NonNull World world) {
        super(world);
    }

    @Override
    public BlockState getBlock(int n, int n2, int n3) {
        Block block = this.getBukkitWorld().getBlockAt(n, n2, n3);
        return BukkitBlockUtil.get(block);
    }

    @Override
    public void start() {
        this.chunkCoordinator.start();
    }

    @Override
    public void cancel() {
        this.chunkCoordinator.cancel();
    }

    @Override
    public boolean enqueue() {
        BlockArrayClipboard blockArrayClipboard;
        BlockVector3 blockVector3;
        BlockVector3 blockVector32;
        if (this.isRegen()) {
            blockVector32 = BlockVector3.at((int)(this.getRegenStart()[0] << 4), (int)this.getMinY(), (int)(this.getRegenStart()[1] << 4));
            blockVector3 = BlockVector3.at((int)((this.getRegenEnd()[0] << 4) + 15), (int)this.getMaxY(), (int)((this.getRegenEnd()[1] << 4) + 15));
            CuboidRegion cuboidRegion = new CuboidRegion(blockVector32, blockVector3);
            blockArrayClipboard = new BlockArrayClipboard((Region)cuboidRegion);
            blockArrayClipboard.setOrigin(blockVector32);
            this.getWorld().regenerate((Region)cuboidRegion, (Extent)blockArrayClipboard);
        } else if (this.getRegenRegion() != null) {
            blockArrayClipboard = new BlockArrayClipboard((Region)this.getRegenRegion());
            blockArrayClipboard.setOrigin(this.getRegenRegion().getMinimumPoint());
            this.getWorld().regenerate((Region)this.getRegenRegion(), (Extent)blockArrayClipboard);
        } else {
            blockArrayClipboard = null;
        }
        blockVector32 = this.getChunkConsumer();
        if (blockVector32 == null) {
            blockVector32 = arg_0 -> this.lambda$enqueue$2((Clipboard)blockArrayClipboard, arg_0);
        }
        blockVector3 = new ArrayList();
        if (this.getReadChunks().size() > 0) {
            blockVector3.addAll(this.getReadChunks());
        }
        this.chunkCoordinator = this.chunkCoordinatorBuilderFactory.create(this.chunkCoordinatorFactory).inWorld(this.getWorld()).withChunks(this.getBlockChunks().keySet()).withChunks((Collection<BlockVector2>)blockVector3).withInitialBatchSize(3).withMaxIterationTime(40L).withThrowableConsumer(Throwable::printStackTrace).withFinalAction(this.getCompleteTask()).withConsumer((Consumer<BlockVector2>)blockVector32).unloadAfter(this.isUnloadAfter()).withProgressSubscribers(this.getProgressSubscribers()).forceSync(this.isForceSync()).build();
        return super.enqueue();
    }

    private void setWorldBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock, @NonNull BlockVector2 blockVector2, boolean bl) {
        block11: {
            try {
                BlockVector3 blockVector3 = BlockVector3.at((int)n, (int)n2, (int)n3);
                boolean bl2 = false;
                switch (this.getLightingMode()) {
                    case NONE: {
                        break;
                    }
                    case PLACEMENT: {
                        bl2 = baseBlock.getBlockType().getMaterial().getLightValue() > 0;
                        break;
                    }
                    case REPLACEMENT: {
                        bl2 = baseBlock.getBlockType().getMaterial().getLightValue() > 0 || this.getWorld().getBlock(blockVector3).getBlockType().getMaterial().getLightValue() > 0;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                SideEffectSet sideEffectSet = bl2 ? this.getSideEffectSet(bl ? SideEffectState.EDGE_LIGHTING : SideEffectState.LIGHTING) : this.getSideEffectSet(bl ? SideEffectState.EDGE : SideEffectState.NONE);
                this.getWorld().setBlock(blockVector3, (BlockStateHolder)baseBlock, sideEffectSet);
            }
            catch (WorldEditException worldEditException) {
                Block block;
                Chunk chunk;
                BlockData blockData = BukkitAdapter.adapt((BlockStateHolder)baseBlock);
                Object object = this.getChunkObject();
                if (object instanceof Chunk) {
                    chunk = (Chunk)object;
                    block = chunk.getBlock(n & 0xF, n2, n3 & 0xF);
                } else {
                    block = this.getBukkitWorld().getBlockAt(n, n2, n3);
                }
                chunk = BukkitAdapter.adapt((BlockData)block.getBlockData());
                if (BukkitBlockUtil.get(block).equals((Object)chunk) && block.getBlockData().matches(blockData)) {
                    return;
                }
                if (block.getState() instanceof Container) {
                    ((Container)block.getState()).getInventory().clear();
                }
                block.setType(BukkitAdapter.adapt((BlockType)baseBlock.getBlockType()), false);
                block.setBlockData(blockData, false);
                if (!baseBlock.hasNbtData()) break block11;
                object = baseBlock.getNbtData();
                StateWrapper stateWrapper = new StateWrapper((CompoundTag)object);
                stateWrapper.restoreTag(block);
            }
        }
    }

    private org.bukkit.World getBukkitWorld() {
        if (this.bukkitWorld == null) {
            this.bukkitWorld = Bukkit.getWorld((String)this.getWorld().getName());
        }
        return this.bukkitWorld;
    }

    private boolean isEdge(int n, int n2, int n3, int n4, BlockVector2 blockVector2, LocalChunk localChunk) {
        Object object;
        int n5 = n - localChunk.getMinSection();
        if (n == localChunk.getMinSection() || n5 == localChunk.getBaseblocks().length - 1) {
            return false;
        }
        if (n2 == 0 ? (object = this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() - 1))) == null || ((LocalChunk)object).getBaseblocks()[n5] == null || ((LocalChunk)object).getBaseblocks()[n5][ChunkUtil.getJ(15, n3, n4)] != null : n2 == 15 && ((object = this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() + 1))) == null || ((LocalChunk)object).getBaseblocks()[n5] == null || ((LocalChunk)object).getBaseblocks()[n5][ChunkUtil.getJ(0, n3, n4)] != null)) {
            return true;
        }
        if (n4 == 0 ? (object = this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() - 1))) == null || ((LocalChunk)object).getBaseblocks()[n5] == null || ((LocalChunk)object).getBaseblocks()[n5][ChunkUtil.getJ(n2, n3, 15)] != null : n4 == 15 && ((object = this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() + 1))) == null || ((LocalChunk)object).getBaseblocks()[n5] == null || ((LocalChunk)object).getBaseblocks()[n5][ChunkUtil.getJ(n2, n3, 0)] != null)) {
            return true;
        }
        if (n3 == 0 ? localChunk.getBaseblocks()[n5 - 1] == null || localChunk.getBaseblocks()[n5][ChunkUtil.getJ(n2, 15, n4)] != null : n3 == 15 && (localChunk.getBaseblocks()[n5 + 1] == null || localChunk.getBaseblocks()[n5][ChunkUtil.getJ(n2, 0, n4)] != null)) {
            return true;
        }
        object = localChunk.getBaseblocks()[n5];
        if (n2 > 0 && object[ChunkUtil.getJ(n2 - 1, n3, n4)] == null) {
            return true;
        }
        if (n2 < 15 && object[ChunkUtil.getJ(n2 + 1, n3, n4)] == null) {
            return true;
        }
        if (n3 > 0 && object[ChunkUtil.getJ(n2, n3 - 1, n4)] == null) {
            return true;
        }
        if (n3 < 15 && object[ChunkUtil.getJ(n2, n3 + 1, n4)] == null) {
            return true;
        }
        if (n4 > 0 && object[ChunkUtil.getJ(n2, n3, n4 - 1)] == null) {
            return true;
        }
        return n4 < 15 && object[ChunkUtil.getJ(n2, n3, n4 + 1)] == null;
    }

    private boolean isEdgeRegen(int n, int n2, BlockVector2 blockVector2) {
        LocalChunk localChunk;
        LocalChunk localChunk2;
        if (n == 0 ? (localChunk2 = this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() - 1))) == null : n == 15 && (localChunk = this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() + 1))) == null) {
            return true;
        }
        if (n2 == 0) {
            return this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() - 1)) == null;
        }
        if (n2 == 15) {
            return this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() + 1)) == null;
        }
        return false;
    }

    private SideEffectSet getSideEffectSet(SideEffectState sideEffectState) {
        if (this.getSideEffectSet() != null) {
            return this.getSideEffectSet();
        }
        return switch (sideEffectState) {
            default -> throw new IncompatibleClassChangeError();
            case SideEffectState.NONE -> NO_SIDE_EFFECT_SET;
            case SideEffectState.EDGE -> EDGE_SIDE_EFFECT_SET;
            case SideEffectState.LIGHTING -> LIGHTING_SIDE_EFFECT_SET;
            case SideEffectState.EDGE_LIGHTING -> EDGE_LIGHTING_SIDE_EFFECT_SET;
        };
    }

    private /* synthetic */ void lambda$enqueue$2(Clipboard clipboard, BlockVector2 blockVector2) {
        int n;
        int n2;
        int n3;
        int n4;
        LocalChunk localChunk = this.getBlockChunks().get(blockVector2);
        boolean bl = clipboard != null && blockVector2.getBlockX() > this.getRegenStart()[0] && blockVector2.getBlockZ() > this.getRegenStart()[1] && blockVector2.getBlockX() < this.getRegenEnd()[0] && blockVector2.getBlockZ() < this.getRegenEnd()[1];
        int n5 = blockVector2.getX() << 4;
        int n6 = blockVector2.getZ() << 4;
        if (bl) {
            for (n4 = this.getMinLayer(); n4 <= this.getMaxLayer(); ++n4) {
                for (int i = 0; i < 16; ++i) {
                    for (n3 = 0; n3 < 16; ++n3) {
                        for (int j = 0; j < 16; ++j) {
                            BaseBlock baseBlock = clipboard.getFullBlock(BlockVector3.at((int)(n3 += n5), (int)(i += n4 << 4), (int)(j += n6)));
                            if (baseBlock == null) continue;
                            n2 = Settings.QUEUE.UPDATE_EDGES && this.isEdgeRegen(n3 & 0xF, j & 0xF, blockVector2) ? 1 : 0;
                            this.setWorldBlock(n3, i, j, baseBlock, blockVector2, n2 != 0);
                        }
                    }
                }
            }
        }
        if (localChunk == null) {
            return;
        }
        for (n4 = 0; n4 < localChunk.getBaseblocks().length; ++n4) {
            BaseBlock[] baseBlockArray = localChunk.getBaseblocks()[n4];
            if (baseBlockArray == null) continue;
            for (n3 = 0; n3 < baseBlockArray.length; ++n3) {
                BaseBlock baseBlock;
                if (baseBlockArray[n3] == null || (baseBlock = baseBlockArray[n3]) == null) continue;
                int n7 = ChunkUtil.getX(n3);
                n2 = ChunkUtil.getZ(n3);
                n = n5 + n7;
                int n8 = ChunkUtil.getY(n4 + localChunk.getMinSection(), n3);
                int n9 = n6 + n2;
                boolean bl2 = Settings.QUEUE.UPDATE_EDGES && this.isEdge(n8 >> 4, n7, n8 & 0xF, n2, blockVector2, localChunk);
                this.setWorldBlock(n, n8, n9, baseBlock, blockVector2, bl2);
            }
        }
        for (n4 = 0; n4 < localChunk.getBiomes().length; ++n4) {
            BiomeType[] biomeTypeArray = localChunk.getBiomes()[n4];
            if (biomeTypeArray == null) continue;
            for (n3 = 0; n3 < biomeTypeArray.length; ++n3) {
                BiomeType biomeType;
                if (biomeTypeArray[n3] == null || (biomeType = biomeTypeArray[n3]) == null) continue;
                int n10 = n5 + ChunkUtil.getX(n3);
                n2 = ChunkUtil.getY(n4, n3);
                n = n6 + ChunkUtil.getZ(n3);
                this.getWorld().setBiome(BlockVector3.at((int)n10, (int)n2, (int)n), biomeType);
            }
        }
        if (localChunk.getTiles().size() > 0) {
            localChunk.getTiles().forEach((blockVector3, compoundTag) -> {
                try {
                    BaseBlock baseBlock = this.getWorld().getBlock(blockVector3).toBaseBlock(compoundTag);
                    this.getWorld().setBlock(blockVector3, (BlockStateHolder)baseBlock, this.getSideEffectSet(SideEffectState.NONE));
                }
                catch (WorldEditException worldEditException) {
                    StateWrapper stateWrapper = new StateWrapper((CompoundTag)compoundTag);
                    stateWrapper.restoreTag(this.getWorld().getName(), blockVector3.getX(), blockVector3.getY(), blockVector3.getZ());
                }
            });
        }
        if (localChunk.getEntities().size() > 0) {
            localChunk.getEntities().forEach((location, baseEntity) -> this.getWorld().createEntity(location, baseEntity));
        }
    }

    private static enum SideEffectState {
        NONE,
        EDGE,
        LIGHTING,
        EDGE_LIGHTING;

    }
}

