/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.serverlib.util;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public final class PackageChecker {
    private static final Logger LOGGER = Logger.getLogger(PackageChecker.class.getName());
    private static final String CLASS_EXTENSION = ".class";
    private static final Set<String> KNOWN_ENTRIES;

    private PackageChecker() {
    }

    private static void handleResource(ImmutableSet.Builder<String> builder, String string) {
        if (string.endsWith(CLASS_EXTENSION)) {
            int n = string.lastIndexOf("/");
            if (n == -1) {
                return;
            }
            builder.add((Object)string.substring(0, n));
        } else if (string.endsWith("/")) {
            builder.add((Object)string.substring(0, string.length() - 1));
        }
    }

    public static boolean packageExists(String string) {
        String string2 = string.replace(".", "/");
        for (String string3 : KNOWN_ENTRIES) {
            if (!string3.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try {
            Enumeration<URL> enumeration = ClassLoader.getSystemClassLoader().getResources("META-INF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                URLConnection uRLConnection = uRL.openConnection();
                if (!(uRLConnection instanceof JarURLConnection)) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                JarFile jarFile = jarURLConnection.getJarFile();
                try {
                    Enumeration<JarEntry> enumeration2 = jarFile.entries();
                    while (enumeration2.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration2.nextElement();
                        String string = zipEntry.toString();
                        if (string.startsWith("/")) {
                            PackageChecker.handleResource((ImmutableSet.Builder<String>)builder, string.substring(1));
                            continue;
                        }
                        PackageChecker.handleResource((ImmutableSet.Builder<String>)builder, string);
                    }
                }
                finally {
                    if (jarFile == null) continue;
                    jarFile.close();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Couldn't scan for known JarEntries.", iOException);
        }
        KNOWN_ENTRIES = builder.build();
    }
}

