/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.ContentMap;
import com.plotsquared.core.generator.AugmentedUtils;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.PlotLoc;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.entity.EntityCategories;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitRegionManager
extends RegionManager {
    private final GlobalBlockQueue blockQueue;

    @Inject
    public BukkitRegionManager(@NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue globalBlockQueue, @NonNull ProgressSubscriberFactory progressSubscriberFactory) {
        super(worldUtil, globalBlockQueue, progressSubscriberFactory);
        this.blockQueue = globalBlockQueue;
    }

    @Override
    public boolean handleClear(@NonNull Plot plot, @Nullable Runnable runnable, @NonNull PlotManager plotManager, @Nullable PlotPlayer<?> plotPlayer) {
        return false;
    }

    @Override
    public int[] countEntities(@NonNull Plot plot) {
        int n;
        int[] nArray = (int[])plot.getMeta("EntityCount");
        if (nArray != null && System.currentTimeMillis() - (Long)plot.getMeta("EntityCountTime") < 1000L) {
            return nArray;
        }
        PlotArea plotArea = plot.getArea();
        org.bukkit.World world = BukkitUtil.getWorld(plotArea.getWorldName());
        Location location = plot.getBottomAbs();
        Location location2 = plot.getTopAbs();
        int n2 = location.getX() >> 4;
        int n3 = location.getZ() >> 4;
        int n4 = location2.getX() >> 4;
        int n5 = location2.getZ() >> 4;
        int n6 = n4 - n2 << 4;
        HashSet<Chunk> hashSet = new HashSet<Chunk>();
        for (n = n2; n <= n4; ++n) {
            for (int i = n3; i <= n5; ++i) {
                if (!world.isChunkLoaded(n, i)) continue;
                hashSet.add(world.getChunkAt(n, i));
            }
        }
        n = 0;
        List list = null;
        if (n6 > 200 && hashSet.size() > 200 && (list = world.getEntities()).size() < 16 + n6 / 8) {
            n = 1;
        }
        int[] nArray2 = new int[6];
        if (n != 0) {
            for (Entity entity : list) {
                org.bukkit.Location location3 = entity.getLocation();
                PaperLib.getChunkAtAsync(location3).thenAccept(chunk -> {
                    if (hashSet.contains(chunk)) {
                        int n5 = chunk.getX();
                        int n6 = chunk.getZ();
                        if (n5 > n2 && n5 < n4 && n6 > n3 && n6 < n5) {
                            this.count(nArray2, entity);
                        } else {
                            Plot plot2 = plotArea.getPlot(BukkitUtil.adapt(location3));
                            if (plot.equals(plot2)) {
                                this.count(nArray2, entity);
                            }
                        }
                    }
                });
            }
        } else {
            for (Chunk chunk2 : hashSet) {
                Entity[] entityArray;
                int n7 = chunk2.getX();
                int n8 = chunk2.getZ();
                for (Entity entity : entityArray = chunk2.getEntities()) {
                    if (n7 == n2 || n7 == n4 || n8 == n3 || n8 == n5) {
                        Plot plot2 = plotArea.getPlot(BukkitUtil.adapt(entity.getLocation()));
                        if (!plot.equals(plot2)) continue;
                        this.count(nArray2, entity);
                        continue;
                    }
                    this.count(nArray2, entity);
                }
            }
        }
        return nArray2;
    }

    @Override
    public boolean regenerateRegion(@NonNull Location location, @NonNull Location location2, boolean bl, @Nullable Runnable runnable) {
        BukkitWorld bukkitWorld = (BukkitWorld)this.worldUtil.getWeWorld(location.getWorldName());
        int n = location.getX();
        int n2 = location.getZ();
        int n3 = location2.getX();
        int n4 = location2.getZ();
        int n5 = n >> 4;
        int n6 = n2 >> 4;
        int n7 = n3 >> 4;
        int n8 = n4 >> 4;
        QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue((World)bukkitWorld);
        QueueCoordinator queueCoordinator2 = this.blockQueue.getNewQueue((World)bukkitWorld);
        queueCoordinator.addReadChunks(new CuboidRegion(location.getBlockVector3(), location2.getBlockVector3()).getChunks());
        queueCoordinator.setChunkConsumer(blockVector2 -> {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = blockVector2.getX();
            int n14 = blockVector2.getZ();
            int n15 = n13 << 4;
            int n16 = n14 << 4;
            int n17 = n15 + 15;
            int n18 = n16 + 15;
            if (n15 >= n && n17 <= n3 && n16 >= n2 && n18 <= n4) {
                AugmentedUtils.bypass(bl, () -> queueCoordinator2.regenChunk(blockVector2.getX(), blockVector2.getZ()));
                return;
            }
            boolean bl2 = false;
            if (n13 == n5) {
                n12 = n - 1;
                bl2 = true;
            } else {
                n12 = n15;
            }
            boolean bl3 = false;
            if (n13 == n7) {
                n11 = n3 + 1;
                bl3 = true;
            } else {
                n11 = n17;
            }
            boolean bl4 = false;
            if (n14 == n6) {
                n10 = n2 - 1;
                bl4 = true;
            } else {
                n10 = n16;
            }
            boolean bl5 = false;
            if (n14 == n8) {
                n9 = n4 + 1;
                bl5 = true;
            } else {
                n9 = n18;
            }
            final ContentMap contentMap = new ContentMap();
            if (bl2) {
                contentMap.saveRegion(bukkitWorld, n15, n12, n10, n9);
            }
            if (bl3) {
                contentMap.saveRegion(bukkitWorld, n11, n17, n10, n9);
            }
            if (bl4) {
                contentMap.saveRegion(bukkitWorld, n12, n11, n16, n10);
            }
            if (bl5) {
                contentMap.saveRegion(bukkitWorld, n12, n11, n9, n18);
            }
            if (bl2 && bl4) {
                contentMap.saveRegion(bukkitWorld, n15, n12, n16, n10);
            }
            if (bl3 && bl4) {
                contentMap.saveRegion(bukkitWorld, n11, n17, n16, n10);
            }
            if (bl2 && bl5) {
                contentMap.saveRegion(bukkitWorld, n15, n12, n9, n18);
            }
            if (bl3 && bl5) {
                contentMap.saveRegion(bukkitWorld, n11, n17, n9, n18);
            }
            CuboidRegion cuboidRegion = new CuboidRegion(location.getBlockVector3(), location2.getBlockVector3());
            contentMap.saveEntitiesOut(Bukkit.getWorld((String)bukkitWorld.getName()).getChunkAt(n13, n14), cuboidRegion);
            AugmentedUtils.bypass(bl, () -> ChunkManager.setChunkInPlotArea(null, new RunnableVal<ZeroedDelegateScopedQueueCoordinator>(){

                @Override
                public void run(ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator) {
                    Location location = zeroedDelegateScopedQueueCoordinator.getMin();
                    int n = location.getX();
                    int n2 = location.getZ();
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            PlotLoc plotLoc = new PlotLoc(n + i, n2 + j);
                            BaseBlock[] baseBlockArray = contentMap.allBlocks.get(plotLoc);
                            if (baseBlockArray == null) continue;
                            int n3 = zeroedDelegateScopedQueueCoordinator.getMin().getY();
                            for (int k = 0; k < baseBlockArray.length; ++k) {
                                int n4 = k + n3;
                                BaseBlock baseBlock = baseBlockArray[k];
                                if (baseBlock != null) {
                                    zeroedDelegateScopedQueueCoordinator.setBlock(i, n4, j, baseBlock);
                                    continue;
                                }
                                zeroedDelegateScopedQueueCoordinator.setBlock(i, n4, j, BlockTypes.AIR.getDefaultState());
                            }
                        }
                    }
                }
            }, bukkitWorld.getName(), blockVector2));
            contentMap.restoreEntities(Bukkit.getWorld((String)bukkitWorld.getName()));
        });
        queueCoordinator2.setCompleteTask(runnable);
        queueCoordinator.setCompleteTask(queueCoordinator2::enqueue);
        queueCoordinator.enqueue();
        return true;
    }

    @Override
    public void clearAllEntities(@NonNull Location location, @NonNull Location location2) {
        String string = location.getWorldName();
        org.bukkit.World world = BukkitUtil.getWorld(string);
        ArrayList arrayList = world != null ? new ArrayList(world.getEntities()) : new ArrayList();
        int n = location.getX();
        int n2 = location.getZ();
        int n3 = location2.getX();
        int n4 = location2.getZ();
        for (Entity entity : arrayList) {
            org.bukkit.Location location3;
            if (!(!(entity instanceof Player) && (location3 = entity.getLocation()).getX() >= (double)n && location3.getX() <= (double)n3 && location3.getZ() >= (double)n2 && location3.getZ() <= (double)n4 && !entity.hasMetadata("ps-tmp-teleport"))) continue;
            entity.remove();
        }
    }

    private void count(int[] nArray, @NonNull Entity entity) {
        com.sk89q.worldedit.world.entity.EntityType entityType = BukkitAdapter.adapt((EntityType)entity.getType());
        if (EntityCategories.PLAYER.contains((Keyed)entityType)) {
            return;
        }
        if (EntityCategories.PROJECTILE.contains((Keyed)entityType) || EntityCategories.OTHER.contains((Keyed)entityType) || EntityCategories.HANGING.contains((Keyed)entityType)) {
            nArray[5] = nArray[5] + 1;
        } else if (EntityCategories.ANIMAL.contains((Keyed)entityType) || EntityCategories.VILLAGER.contains((Keyed)entityType) || EntityCategories.TAMEABLE.contains((Keyed)entityType)) {
            nArray[3] = nArray[3] + 1;
            nArray[1] = nArray[1] + 1;
        } else if (EntityCategories.VEHICLE.contains((Keyed)entityType)) {
            nArray[4] = nArray[4] + 1;
        } else if (EntityCategories.HOSTILE.contains((Keyed)entityType)) {
            nArray[3] = nArray[3] + 1;
            nArray[2] = nArray[2] + 1;
        }
        nArray[0] = nArray[0] + 1;
    }
}

