/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.paperlib.PaperLib;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.player.BukkitPlayerManager;
import com.plotsquared.bukkit.util.BukkitWorld;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.adventure.platform.bukkit.BukkitAudiences;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.BlockUtil;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Singleton;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boss;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitUtil
extends WorldUtil {
    public static final BukkitAudiences BUKKIT_AUDIENCES = BukkitAudiences.create((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class));
    public static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.legacySection();
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BukkitUtil.class.getSimpleName()));
    private final Collection<BlockType> tileEntityTypes = new HashSet<BlockType>();

    public static @NonNull BukkitPlayer adapt(@NonNull Player player) {
        PlayerManager<PlotPlayer<?>, ?> playerManager = PlotSquared.platform().playerManager();
        return ((BukkitPlayerManager)playerManager).getPlayer(player);
    }

    public static @NonNull Location adapt(@NonNull org.bukkit.Location location) {
        return Location.at(BukkitWorld.of(location.getWorld()), MathMan.roundInt(location.getX()), MathMan.roundInt(location.getY()), MathMan.roundInt(location.getZ()));
    }

    public static @NonNull Location adaptComplete(@NonNull org.bukkit.Location location) {
        return Location.at(BukkitWorld.of(location.getWorld()), MathMan.roundInt(location.getX()), MathMan.roundInt(location.getY()), MathMan.roundInt(location.getZ()), location.getYaw(), location.getPitch());
    }

    public static @NonNull org.bukkit.Location adapt(@NonNull Location location) {
        return new org.bukkit.Location((World)location.getWorld().getPlatformWorld(), (double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static @Nullable World getWorld(@NonNull String string) {
        return Bukkit.getWorld((String)string);
    }

    private static void ensureLoaded(@NonNull String string, int n, int n2, @NonNull Consumer<Chunk> consumer) {
        PaperLib.getChunkAtAsync(Objects.requireNonNull(BukkitUtil.getWorld(string)), n >> 4, n2 >> 4, true).thenAccept(chunk -> BukkitUtil.ensureMainThread(consumer, chunk));
    }

    private static void ensureLoaded(@NonNull Location location, @NonNull Consumer<Chunk> consumer) {
        PaperLib.getChunkAtAsync(BukkitUtil.adapt(location), true).thenAccept(chunk -> BukkitUtil.ensureMainThread(consumer, chunk));
    }

    private static <T> void ensureMainThread(@NonNull Consumer<T> consumer, @NonNull T t) {
        if (Bukkit.isPrimaryThread()) {
            consumer.accept(t);
        } else {
            Bukkit.getScheduler().runTask((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class), () -> consumer.accept(t));
        }
    }

    @Override
    public boolean isBlockSame(@NonNull BlockState blockState, @NonNull BlockState blockState2) {
        Material material;
        if (blockState.equals((Object)blockState2)) {
            return true;
        }
        Material material2 = BukkitAdapter.adapt((BlockType)blockState.getBlockType());
        return material2 == (material = BukkitAdapter.adapt((BlockType)blockState2.getBlockType()));
    }

    @Override
    public boolean isWorld(@NonNull String string) {
        return BukkitUtil.getWorld(string) != null;
    }

    @Override
    public void getBiome(@NonNull String string, int n, int n2, @NonNull Consumer<BiomeType> consumer) {
        BukkitUtil.ensureLoaded(string, n, n2, chunk -> consumer.accept(BukkitAdapter.adapt((Biome)BukkitUtil.getWorld(string).getBiome(n, n2))));
    }

    @Override
    public @NonNull BiomeType getBiomeSynchronous(@NonNull String string, int n, int n2) {
        return BukkitAdapter.adapt((Biome)Objects.requireNonNull(BukkitUtil.getWorld(string)).getBiome(n, n2));
    }

    @Override
    public void getHighestBlock(@NonNull String string, int n, int n2, @NonNull IntConsumer intConsumer) {
        BukkitUtil.ensureLoaded(string, n, n2, chunk -> {
            World world = Objects.requireNonNull(BukkitUtil.getWorld(string));
            int n3 = 1;
            int n4 = BukkitWorld.getMaxWorldHeight(world);
            int n5 = BukkitWorld.getMinWorldHeight(world);
            for (int i = n4 - 1; i >= n5; --i) {
                Block block = world.getBlockAt(n, i, n2);
                Material material = block.getType();
                if (material.isSolid()) {
                    if (n3 > 1) {
                        intConsumer.accept(i);
                        return;
                    }
                    n3 = 0;
                    continue;
                }
                if (block.isLiquid()) {
                    intConsumer.accept(i);
                    return;
                }
                ++n3;
            }
            intConsumer.accept(world.getMaxHeight() - 1);
        });
    }

    @Override
    public @NonNegative int getHighestBlockSynchronous(@NonNull String string, int n, int n2) {
        World world = Objects.requireNonNull(BukkitUtil.getWorld(string));
        int n3 = 1;
        int n4 = BukkitWorld.getMaxWorldHeight(world);
        int n5 = BukkitWorld.getMinWorldHeight(world);
        for (int i = n4 - 1; i >= n5; --i) {
            Block block = world.getBlockAt(n, i, n2);
            Material material = block.getType();
            if (material.isSolid()) {
                if (n3 > 1) {
                    return i;
                }
                n3 = 0;
                continue;
            }
            if (block.isLiquid()) {
                return i;
            }
            ++n3;
        }
        return world.getMaxHeight() - 1;
    }

    @Override
    public @NonNull String[] getSignSynchronous(@NonNull Location location) {
        Block block = Objects.requireNonNull(BukkitUtil.getWorld(location.getWorldName())).getBlockAt(location.getX(), location.getY(), location.getZ());
        try {
            return TaskManager.getPlatformImplementation().sync(() -> {
                org.bukkit.block.BlockState blockState = block.getState();
                if (blockState instanceof Sign) {
                    Sign sign = (Sign)blockState;
                    return sign.getLines();
                }
                return new String[0];
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new String[0];
        }
    }

    @Override
    public @NonNull Location getSpawn(@NonNull String string) {
        org.bukkit.Location location = BukkitUtil.getWorld(string).getSpawnLocation();
        return Location.at(string, location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setSpawn(@NonNull Location location) {
        World world = BukkitUtil.getWorld(location.getWorldName());
        if (world != null) {
            world.setSpawnLocation(location.getX(), location.getY(), location.getZ());
        }
    }

    @Override
    public void saveWorld(@NonNull String string) {
        World world = BukkitUtil.getWorld(string);
        if (world != null) {
            world.save();
        }
    }

    @Override
    public void setSign(@NonNull Location location, @NonNull Caption[] captionArray, TagResolver ... tagResolverArray) {
        BukkitUtil.ensureLoaded(location.getWorldName(), location.getX(), location.getZ(), chunk -> {
            Sign sign;
            org.bukkit.block.BlockState blockState;
            PlotArea plotArea = location.getPlotArea();
            World world = BukkitUtil.getWorld(location.getWorldName());
            Block block = world.getBlockAt(location.getX(), location.getY(), location.getZ());
            Material material = block.getType();
            if (material != Material.LEGACY_SIGN && material != Material.LEGACY_WALL_SIGN) {
                blockState = BlockFace.NORTH;
                if (!world.getBlockAt(location.getX(), location.getY(), location.getZ() + 1).getType().isSolid()) {
                    if (world.getBlockAt(location.getX() - 1, location.getY(), location.getZ()).getType().isSolid()) {
                        blockState = BlockFace.EAST;
                    } else if (world.getBlockAt(location.getX() + 1, location.getY(), location.getZ()).getType().isSolid()) {
                        blockState = BlockFace.WEST;
                    } else if (world.getBlockAt(location.getX(), location.getY(), location.getZ() - 1).getType().isSolid()) {
                        blockState = BlockFace.SOUTH;
                    }
                }
                if (PlotSquared.platform().serverVersion()[1] == 13) {
                    block.setType(Material.valueOf((String)plotArea.legacySignMaterial()), false);
                } else {
                    block.setType(Material.valueOf((String)plotArea.signMaterial()), false);
                }
                if (!(block.getBlockData() instanceof WallSign)) {
                    throw new RuntimeException("Something went wrong generating a sign");
                }
                sign = (Directional)block.getBlockData();
                sign.setFacing((BlockFace)blockState);
                block.setBlockData((BlockData)sign, false);
            }
            if ((blockState = block.getState()) instanceof Sign) {
                sign = (Sign)blockState;
                for (int i = 0; i < captionArray.length; ++i) {
                    sign.setLine(i, LEGACY_COMPONENT_SERIALIZER.serialize(MINI_MESSAGE.deserialize(captionArray[i].getComponent(LocaleHolder.console()), tagResolverArray)));
                }
                sign.update(true, false);
            }
        });
    }

    @Override
    public @NonNull StringComparison.ComparisonResult getClosestBlock(@NonNull String string) {
        BlockState blockState = BlockUtil.get(string);
        return new StringComparison().new StringComparison.ComparisonResult(1.0, blockState);
    }

    @Override
    public @NonNull com.sk89q.worldedit.world.World getWeWorld(@NonNull String string) {
        return new com.sk89q.worldedit.bukkit.BukkitWorld(Bukkit.getWorld((String)string));
    }

    @Override
    public void refreshChunk(int n, int n2, String string) {
        Bukkit.getWorld((String)string).refreshChunk(n, n2);
    }

    @Override
    public void getBlock(@NonNull Location location, @NonNull Consumer<BlockState> consumer) {
        BukkitUtil.ensureLoaded(location, chunk -> {
            World world = BukkitUtil.getWorld(location.getWorldName());
            Block block = Objects.requireNonNull(world).getBlockAt(location.getX(), location.getY(), location.getZ());
            consumer.accept(Objects.requireNonNull(BukkitAdapter.asBlockType((Material)block.getType())).getDefaultState());
        });
    }

    @Override
    public @NonNull BlockState getBlockSynchronous(@NonNull Location location) {
        World world = BukkitUtil.getWorld(location.getWorldName());
        Block block = Objects.requireNonNull(world).getBlockAt(location.getX(), location.getY(), location.getZ());
        return Objects.requireNonNull(BukkitAdapter.asBlockType((Material)block.getType())).getDefaultState();
    }

    @Override
    public @NonNegative double getHealth(@NonNull PlotPlayer<?> plotPlayer) {
        return Objects.requireNonNull(Bukkit.getPlayer((UUID)plotPlayer.getUUID())).getHealth();
    }

    @Override
    public @NonNegative int getFoodLevel(@NonNull PlotPlayer<?> plotPlayer) {
        return Objects.requireNonNull(Bukkit.getPlayer((UUID)plotPlayer.getUUID())).getFoodLevel();
    }

    @Override
    public void setHealth(@NonNull PlotPlayer<?> plotPlayer, @NonNegative double d) {
        Objects.requireNonNull(Bukkit.getPlayer((UUID)plotPlayer.getUUID())).setHealth(d);
    }

    @Override
    public void setFoodLevel(@NonNull PlotPlayer<?> plotPlayer, @NonNegative int n) {
        Bukkit.getPlayer((UUID)plotPlayer.getUUID()).setFoodLevel(n);
    }

    @Override
    public @NonNull Set<com.sk89q.worldedit.world.entity.EntityType> getTypesInCategory(@NonNull String string) {
        HashSet<Class<Player>> hashSet = new HashSet<Class<Player>>();
        switch (string) {
            case "animal": {
                hashSet.add(IronGolem.class);
                hashSet.add(Snowman.class);
                hashSet.add(Animals.class);
                hashSet.add(WaterMob.class);
                hashSet.add(Ambient.class);
                if (PlotSquared.platform().serverVersion()[1] < 19) break;
                hashSet.add(Allay.class);
                break;
            }
            case "tameable": {
                hashSet.add(Tameable.class);
                break;
            }
            case "vehicle": {
                hashSet.add(Vehicle.class);
                break;
            }
            case "hostile": {
                hashSet.add(Shulker.class);
                hashSet.add(Monster.class);
                hashSet.add(Boss.class);
                hashSet.add(Slime.class);
                hashSet.add(Ghast.class);
                hashSet.add(Phantom.class);
                hashSet.add(EnderCrystal.class);
                break;
            }
            case "hanging": {
                hashSet.add(Hanging.class);
                break;
            }
            case "villager": {
                hashSet.add(NPC.class);
                break;
            }
            case "projectile": {
                hashSet.add(Projectile.class);
                break;
            }
            case "other": {
                hashSet.add(ArmorStand.class);
                hashSet.add(FallingBlock.class);
                hashSet.add(Item.class);
                hashSet.add(Explosive.class);
                hashSet.add(AreaEffectCloud.class);
                hashSet.add(EvokerFangs.class);
                hashSet.add(LightningStrike.class);
                hashSet.add(ExperienceOrb.class);
                hashSet.add(EnderSignal.class);
                hashSet.add(Firework.class);
                break;
            }
            case "player": {
                hashSet.add(Player.class);
                break;
            }
            default: {
                LOGGER.error("Unknown entity category requested: {}", (Object)string);
            }
        }
        Object object = new HashSet();
        block22: for (EntityType entityType : EntityType.values()) {
            Class clazz = entityType.getEntityClass();
            if (clazz == null) continue;
            for (Class clazz2 : hashSet) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                object.add(BukkitAdapter.adapt((EntityType)entityType));
                continue block22;
            }
        }
        return object;
    }

    @Override
    public @NonNull Collection<BlockType> getTileEntityTypes() {
        if (this.tileEntityTypes.isEmpty()) {
            this.tileEntityTypes.addAll(BlockCategories.BANNERS.getAll());
            this.tileEntityTypes.addAll(BlockCategories.SIGNS.getAll());
            this.tileEntityTypes.addAll(BlockCategories.BEDS.getAll());
            this.tileEntityTypes.addAll(BlockCategories.FLOWER_POTS.getAll());
            Stream.of("barrel", "beacon", "beehive", "bee_nest", "bell", "blast_furnace", "brewing_stand", "campfire", "chest", "ender_chest", "trapped_chest", "command_block", "end_gateway", "hopper", "jigsaw", "jubekox", "lectern", "note_block", "black_shulker_box", "blue_shulker_box", "brown_shulker_box", "cyan_shulker_box", "gray_shulker_box", "green_shulker_box", "light_blue_shulker_box", "light_gray_shulker_box", "lime_shulker_box", "magenta_shulker_box", "orange_shulker_box", "pink_shulker_box", "purple_shulker_box", "red_shulker_box", "shulker_box", "white_shulker_box", "yellow_shulker_box", "smoker", "structure_block", "structure_void").map(BlockTypes::get).filter(Objects::nonNull).forEach(this.tileEntityTypes::add);
        }
        return this.tileEntityTypes;
    }

    @Override
    public @NonNegative int getTileEntityCount(@NonNull String string, @NonNull BlockVector2 blockVector2) {
        return Objects.requireNonNull(BukkitUtil.getWorld(string)).getChunkAt(blockVector2.getBlockX(), blockVector2.getBlockZ()).getTileEntities().length;
    }

    @Override
    public Set<BlockVector2> getChunkChunks(String string) {
        Set<BlockVector2> set = super.getChunkChunks(string);
        if (Bukkit.isPrimaryThread()) {
            for (Chunk chunk : Objects.requireNonNull(Bukkit.getWorld((String)string)).getLoadedChunks()) {
                BlockVector2 blockVector2 = BlockVector2.at((int)(chunk.getX() >> 5), (int)(chunk.getZ() >> 5));
                set.add(blockVector2);
            }
        } else {
            Semaphore semaphore = new Semaphore(1);
            try {
                semaphore.acquire();
                Bukkit.getScheduler().runTask((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class), () -> {
                    for (Chunk chunk : Objects.requireNonNull(Bukkit.getWorld((String)string)).getLoadedChunks()) {
                        BlockVector2 blockVector2 = BlockVector2.at((int)(chunk.getX() >> 5), (int)(chunk.getZ() >> 5));
                        set.add(blockVector2);
                    }
                    semaphore.release();
                });
                semaphore.acquireUninterruptibly();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return set;
    }
}

