/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.google.common.base.Charsets;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OfflinePlayerUUIDService
implements UUIDService {
    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> list) {
        if (Settings.UUID.FORCE_LOWERCASE || Bukkit.getWorlds().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        for (UUID uUID : list) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            try {
                if (!offlinePlayer.hasPlayedBefore()) continue;
                arrayList.add(new UUIDMapping(uUID, offlinePlayer.getName()));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        for (String string : list) {
            if (Settings.UUID.OFFLINE) {
                if (Settings.UUID.FORCE_LOWERCASE) {
                    arrayList.add(new UUIDMapping(UUID.nameUUIDFromBytes(("OfflinePlayer:" + string.toLowerCase()).getBytes(Charsets.UTF_8)), string));
                    continue;
                }
                arrayList.add(new UUIDMapping(UUID.nameUUIDFromBytes(("OfflinePlayer:" + string).getBytes(Charsets.UTF_8)), string));
                continue;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
            if (!offlinePlayer.hasPlayedBefore()) continue;
            arrayList.add(new UUIDMapping(offlinePlayer.getUniqueId(), offlinePlayer.getName()));
        }
        return arrayList;
    }
}

