/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.database.SQLite;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SQLiteUUIDService
implements UUIDService,
Consumer<List<UUIDMapping>> {
    private final SQLite sqlite;

    public SQLiteUUIDService(String string) {
        this.sqlite = new SQLite(FileUtils.getFile(PlotSquared.platform().getDirectory(), string));
        try {
            this.sqlite.openConnection();
        }
        catch (ClassNotFoundException | SQLException exception) {
            exception.printStackTrace();
        }
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS `usercache` (uuid VARCHAR(32) NOT NULL, username VARCHAR(32) NOT NULL, PRIMARY KEY (uuid))");){
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() {
        SQLite sQLite = this.sqlite;
        synchronized (sQLite) {
            return this.sqlite.getConnection();
        }
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT `username` FROM `usercache` WHERE `uuid` = ?");){
            for (UUID uUID : list) {
                preparedStatement.setString(1, uUID.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (!resultSet.next()) continue;
                    arrayList.add(new UUIDMapping(uUID, resultSet.getString("username")));
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT `uuid` FROM `usercache` WHERE `username` = ?");){
            for (String string : list) {
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (!resultSet.next()) continue;
                    arrayList.add(new UUIDMapping(UUID.fromString(resultSet.getString("uuid")), string));
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public void accept(List<UUIDMapping> list) {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("INSERT OR REPLACE INTO `usercache` (`uuid`, `username`) VALUES(?, ?)");){
            for (UUIDMapping uUIDMapping : list) {
                preparedStatement.setString(1, uUIDMapping.uuid().toString());
                preparedStatement.setString(2, uUIDMapping.username());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public @NonNull List<UUIDMapping> getAll() {
        LinkedList<UUIDMapping> linkedList = new LinkedList<UUIDMapping>();
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT * FROM `usercache`");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                linkedList.add(new UUIDMapping(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }
}

