/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.google.common.util.concurrent.RateLimiter;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import com.plotsquared.squirrelid.squirrelid.Profile;
import com.plotsquared.squirrelid.squirrelid.resolver.HttpRepositoryService;
import com.plotsquared.squirrelid.squirrelid.resolver.ProfileService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SquirrelIdUUIDService
implements UUIDService {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SquirrelIdUUIDService.class.getSimpleName()));
    private final ProfileService profileService = HttpRepositoryService.forMinecraft();
    private final RateLimiter rateLimiter;

    public SquirrelIdUUIDService(int n) {
        this.rateLimiter = RateLimiter.create((double)((double)n / 600.0));
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        this.rateLimiter.acquire(list.size());
        try {
            try {
                for (Profile profile : this.profileService.findAllByUuid(list)) {
                    arrayList.add(new UUIDMapping(profile.getUniqueId(), profile.getName()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (list.size() >= 2) {
                    if (Settings.DEBUG) {
                        LOGGER.info("(UUID) Found invalid UUID in batch. Will try each UUID individually.");
                    }
                    for (UUID uUID : list) {
                        List<UUIDMapping> list2 = this.getNames(Collections.singletonList(uUID));
                        if (list2.isEmpty()) continue;
                        arrayList.add(list2.get(0));
                    }
                } else if (list.size() == 1 && Settings.DEBUG) {
                    LOGGER.info("(UUID) Found invalid UUID: {}", (Object)list.get(0));
                }
            }
        }
        catch (IOException | InterruptedException exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        this.rateLimiter.acquire(list.size());
        try {
            for (Profile profile : this.profileService.findAllByName(list)) {
                arrayList.add(new UUIDMapping(profile.getUniqueId(), profile.getName()));
            }
        }
        catch (IOException | InterruptedException exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }
}

