/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.annotation;

import com.plotsquared.core.annotation.RegEx;
import com.plotsquared.core.annotation.meta.TypeQualifier;
import com.plotsquared.core.annotation.meta.TypeQualifierValidator;
import com.plotsquared.core.annotation.meta.When;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;

@Documented
@TypeQualifier(applicableTo=String.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MatchesPattern {
    @RegEx
    public String value();

    public int flags() default 0;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Checker
    implements TypeQualifierValidator<MatchesPattern> {
        @Override
        public When forConstantValue(MatchesPattern matchesPattern, Object object) {
            Pattern pattern = Pattern.compile(matchesPattern.value(), matchesPattern.flags());
            if (pattern.matcher((String)object).matches()) {
                return When.ALWAYS;
            }
            return When.NEVER;
        }
    }
}

