/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.collection;

import com.plotsquared.core.collection.RandomCollection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class SimpleRandomCollection<E>
extends RandomCollection<E> {
    private final NavigableMap<Double, E> map = new TreeMap<Double, E>();
    private double total = 0.0;

    public SimpleRandomCollection(Map<E, Double> map, Random random) {
        super(map, random);
        for (Map.Entry<E, Double> entry : map.entrySet()) {
            this.add(entry.getValue(), entry.getKey());
        }
    }

    public void add(double d, E e) {
        if (d <= 0.0) {
            return;
        }
        this.total += d;
        this.map.put(this.total, e);
    }

    @Override
    public E next() {
        return this.map.ceilingEntry(this.random.nextDouble()).getValue();
    }
}

