/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.generator.AugmentedUtils;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="area", permission="plots.area", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.NONE, aliases={"world"}, usage="/plot area <create | info | list | tp | regen>", confirmation=true)
public class Area
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final YamlConfiguration worldConfiguration;
    private final File worldFile;
    private final HybridPlotWorldFactory hybridPlotWorldFactory;
    private final SetupUtils setupUtils;
    private final WorldUtil worldUtil;
    private final GlobalBlockQueue blockQueue;
    private final Map<UUID, Map<String, Object>> metaData = new HashMap<UUID, Map<String, Object>>();

    @Inject
    public Area(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @WorldFile @NonNull File file, @NonNull HybridPlotWorldFactory hybridPlotWorldFactory, @NonNull SetupUtils setupUtils, @NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue globalBlockQueue) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = yamlConfiguration;
        this.worldFile = file;
        this.hybridPlotWorldFactory = hybridPlotWorldFactory;
        this.setupUtils = setupUtils;
        this.worldUtil = worldUtil;
        this.blockQueue = globalBlockQueue;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        if (stringArray.length == 0) {
            this.sendUsage(plotPlayer);
            return false;
        }
        switch (stringArray[0].toLowerCase()) {
            case "single": {
                Object object;
                Object object2;
                ClipboardWriter clipboardWriter;
                if (plotPlayer instanceof ConsolePlayer) {
                    plotPlayer.sendMessage(RequiredType.CONSOLE.getErrorMessage(), new TagResolver[0]);
                    return false;
                }
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_CREATE)));
                    return false;
                }
                if (stringArray.length < 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_needs_name"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot area single <name>"))));
                    return false;
                }
                PlotArea plotArea = this.plotAreaManager.getPlotArea(plotPlayer.getLocation().getWorldName(), stringArray[1]);
                if (plotArea != null && plotArea.getId().equalsIgnoreCase(stringArray[1])) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_name_taken"), new TagResolver[0]);
                    return false;
                }
                LocalSession localSession = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)plotPlayer.toActor());
                if (localSession == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_missing_selection"), new TagResolver[0]);
                    return false;
                }
                Region region = null;
                try {
                    region = localSession.getSelection(((Player)plotPlayer.toActor()).getWorld());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (region == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_missing_selection"), new TagResolver[0]);
                    return false;
                }
                if (region.getWidth() != region.getLength()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_not_square"), new TagResolver[0]);
                    return false;
                }
                if (this.plotAreaManager.getPlotAreas(Objects.requireNonNull(region.getWorld()).getName(), CuboidRegion.makeCuboid((Region)region)).length != 0) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_overlapping"), new TagResolver[0]);
                }
                BlockVector3 blockVector3 = region.getMinimumPoint();
                BlockVector3 blockVector32 = region.getMaximumPoint();
                World world = region.getWorld();
                CuboidRegion cuboidRegion = new CuboidRegion(region.getWorld(), BlockVector3.at((int)blockVector3.getX(), (int)world.getMinY(), (int)blockVector3.getZ()), BlockVector3.at((int)blockVector32.getX(), (int)world.getMaxY(), (int)blockVector32.getZ()));
                PlotId plotId = PlotId.of(1, 1);
                HybridPlotWorld hybridPlotWorld = this.hybridPlotWorldFactory.create(plotPlayer.getLocation().getWorldName(), stringArray[1], Objects.requireNonNull(PlotSquared.platform()).defaultGenerator(), plotId, plotId);
                hybridPlotWorld.SIZE = (short)cuboidRegion.getWidth();
                hybridPlotWorld.PLOT_WIDTH = hybridPlotWorld.SIZE;
                hybridPlotWorld.setTerrain(PlotAreaTerrainType.NONE);
                hybridPlotWorld.setType(PlotAreaType.PARTIAL);
                hybridPlotWorld.PLOT_SCHEMATIC = true;
                hybridPlotWorld.ROAD_OFFSET_Z = 0;
                hybridPlotWorld.ROAD_OFFSET_X = 0;
                hybridPlotWorld.ROAD_WIDTH = 0;
                hybridPlotWorld.ROAD_HEIGHT = hybridPlotWorld.WALL_HEIGHT = blockVector3.getBlockY();
                hybridPlotWorld.PLOT_HEIGHT = hybridPlotWorld.WALL_HEIGHT;
                hybridPlotWorld.setAllowSigns(false);
                File file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + hybridPlotWorld.getWorldName() + File.separator + hybridPlotWorld.getId());
                if (!file.exists() && !file.mkdirs()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_could_not_make_directories"), new TagResolver[0]);
                    return false;
                }
                File file2 = new File(file, "plot.schem");
                try {
                    clipboardWriter = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(file2));
                    try {
                        object2 = new BlockArrayClipboard((Region)cuboidRegion);
                        object = WorldEdit.getInstance().newEditSessionBuilder();
                        object.world(cuboidRegion.getWorld());
                        EditSession editSession = object.build();
                        ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, (Region)cuboidRegion, (Extent)object2, cuboidRegion.getMinimumPoint());
                        forwardExtentCopy.setCopyingBiomes(true);
                        forwardExtentCopy.setCopyingEntities(true);
                        Operations.complete((Operation)forwardExtentCopy);
                        clipboardWriter.write((Clipboard)object2);
                    }
                    finally {
                        if (clipboardWriter != null) {
                            clipboardWriter.close();
                        }
                    }
                }
                catch (Exception exception) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_failed_to_save"), new TagResolver[0]);
                    exception.printStackTrace();
                    return false;
                }
                try {
                    hybridPlotWorld.setupSchematics();
                }
                catch (SchematicHandler.UnsupportedFormatException unsupportedFormatException) {
                    unsupportedFormatException.printStackTrace();
                }
                clipboardWriter = cuboidRegion.getMinimumPoint();
                object2 = PlotAreaBuilder.ofPlotArea(hybridPlotWorld).plotManager(PlotSquared.platform().pluginName()).generatorName(PlotSquared.platform().pluginName()).maximumId(plotId).minimumId(plotId);
                object = () -> this.lambda$onCommand$0(hybridPlotWorld, (PlotAreaBuilder)object2, (BlockVector3)clipboardWriter, plotPlayer);
                object.run();
                return true;
            }
            case "c": 
            case "setup": 
            case "create": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_CREATE)));
                    return false;
                }
                switch (stringArray.length) {
                    case 1: {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot area create [world[:id]] [<modifier>=<value>]..."))));
                        return false;
                    }
                    case 2: {
                        switch (stringArray[1].toLowerCase()) {
                            case "pos1": {
                                HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)this.metaData.computeIfAbsent(plotPlayer.getUUID(), uUID -> new HashMap()).get("area_create_area");
                                if (hybridPlotWorld == null) {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot area create [world[:id]] [<modifier>=<value>]..."))));
                                    return false;
                                }
                                Location location = plotPlayer.getLocation();
                                this.metaData.computeIfAbsent(plotPlayer.getUUID(), uUID -> new HashMap()).put("area_pos1", location);
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("set.set_attribute"), TagResolver.builder().tag("attribute", Tag.inserting(Component.text("area_pos1"))).tag("value", Tag.inserting(((TextComponent)Component.text(location.getX()).append(Component.text(","))).append(Component.text(location.getZ())))).build());
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("area.set_pos2"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot area create pos2"))));
                                return true;
                            }
                            case "pos2": {
                                HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)this.metaData.computeIfAbsent(plotPlayer.getUUID(), uUID -> new HashMap()).get("area_create_area");
                                if (hybridPlotWorld == null) {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot area create [world[:id]] [<modifier>=<value>]..."))));
                                    return false;
                                }
                                Location location = plotPlayer.getLocation();
                                Location location2 = (Location)this.metaData.computeIfAbsent(plotPlayer.getUUID(), uUID -> new HashMap()).get("area_pos1");
                                int n2 = Math.abs(location.getX() - location2.getX());
                                int n3 = Math.abs(location.getZ() - location2.getZ());
                                int n4 = Math.max(1, (n2 + 1 + hybridPlotWorld.ROAD_WIDTH + hybridPlotWorld.SIZE / 2) / hybridPlotWorld.SIZE);
                                int n5 = Math.max(1, (n3 + 1 + hybridPlotWorld.ROAD_WIDTH + hybridPlotWorld.SIZE / 2) / hybridPlotWorld.SIZE);
                                int n6 = n2 - (n4 * hybridPlotWorld.SIZE - hybridPlotWorld.ROAD_WIDTH);
                                int n7 = n3 - (n5 * hybridPlotWorld.SIZE - hybridPlotWorld.ROAD_WIDTH);
                                int n8 = Math.min(location.getX(), location2.getX()) + n6;
                                int n9 = Math.min(location.getZ(), location2.getZ()) + n7;
                                int n10 = Math.max(location.getX(), location2.getX()) - n6;
                                int n11 = Math.max(location.getZ(), location2.getZ()) - n7;
                                int n12 = (hybridPlotWorld.ROAD_WIDTH & 1) == 0 ? hybridPlotWorld.ROAD_WIDTH / 2 - 1 : hybridPlotWorld.ROAD_WIDTH / 2;
                                int n13 = n8 - (hybridPlotWorld.ROAD_WIDTH == 0 ? 0 : n12);
                                int n14 = n9 - (hybridPlotWorld.ROAD_WIDTH == 0 ? 0 : n12);
                                CuboidRegion cuboidRegion = RegionUtil.createRegion(n8, n10, 0, 0, n9, n11);
                                Set<PlotArea> set = this.plotAreaManager.getPlotAreasSet(hybridPlotWorld.getWorldName(), cuboidRegion);
                                if (!set.isEmpty()) {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_intersection"), TagResolver.resolver("cluster", Tag.inserting(set.iterator().next())));
                                    return false;
                                }
                                PlotAreaBuilder plotAreaBuilder = PlotAreaBuilder.ofPlotArea(hybridPlotWorld).plotManager(PlotSquared.platform().pluginName()).generatorName(PlotSquared.platform().pluginName()).minimumId(PlotId.of(1, 1)).maximumId(PlotId.of(n4, n5));
                                String string = "worlds." + hybridPlotWorld.getWorldName() + ".areas." + hybridPlotWorld.getId() + "-" + plotAreaBuilder.minimumId() + "-" + plotAreaBuilder.maximumId();
                                Runnable runnable = () -> {
                                    String string2;
                                    if (n13 != 0) {
                                        this.worldConfiguration.set(string + ".road.offset.x", n13);
                                    }
                                    if (n14 != 0) {
                                        this.worldConfiguration.set(string + ".road.offset.z", n14);
                                    }
                                    if (this.worldUtil.isWorld(string2 = this.setupUtils.setupWorld(plotAreaBuilder))) {
                                        PlotSquared.get().loadWorld(string2, null);
                                        plotPlayer.teleport(this.worldUtil.getSpawn(string2), TeleportCause.COMMAND_AREA_CREATE);
                                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
                                        if (hybridPlotWorld.getTerrain() != PlotAreaTerrainType.ALL) {
                                            QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(string2));
                                            queueCoordinator.setChunkConsumer(blockVector2 -> AugmentedUtils.generateChunk(string2, blockVector2.getX(), blockVector2.getZ(), null));
                                            queueCoordinator.addReadChunks(cuboidRegion.getChunks());
                                            queueCoordinator.enqueue();
                                        }
                                    } else {
                                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.error_create"), TagResolver.resolver("world", Tag.inserting(Component.text(hybridPlotWorld.getWorldName()))));
                                    }
                                };
                                if (this.hasConfirmation(plotPlayer)) {
                                    CmdConfirm.addPending(plotPlayer, this.getCommandString() + " create pos2 (Creates world)", runnable);
                                } else {
                                    runnable.run();
                                }
                                return true;
                            }
                        }
                    }
                }
                String[] stringArray2 = stringArray[1].split(":");
                String string = stringArray2.length == 2 ? stringArray2[1] : null;
                PlotAreaBuilder plotAreaBuilder = PlotAreaBuilder.newBuilder();
                plotAreaBuilder.worldName(stringArray2[0]);
                HybridPlotWorld hybridPlotWorld = this.hybridPlotWorldFactory.create(plotAreaBuilder.worldName(), string, PlotSquared.platform().defaultGenerator(), null, null);
                PlotArea plotArea = this.plotAreaManager.getPlotArea(hybridPlotWorld.getWorldName(), string);
                if (plotArea != null && Objects.equals(hybridPlotWorld.getId(), plotArea.getId())) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_taken"), TagResolver.resolver("value", Tag.inserting(Component.text(hybridPlotWorld.getId()))));
                    return false;
                }
                Set<PlotArea> set = this.plotAreaManager.getPlotAreasSet(hybridPlotWorld.getWorldName());
                if (!set.isEmpty()) {
                    PlotArea plotArea2 = set.iterator().next();
                    hybridPlotWorld.setType(plotArea2.getType());
                }
                hybridPlotWorld.SIZE = (short)(hybridPlotWorld.PLOT_WIDTH + hybridPlotWorld.ROAD_WIDTH);
                block90: for (int i = 2; i < stringArray.length; ++i) {
                    String[] stringArray3 = stringArray[i].split("=");
                    if (stringArray3.length != 2) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(this.getCommandString()))).tag("value2", Tag.inserting(Component.text("create [world[:id]] [<modifier>=<value>]..."))).build());
                        return false;
                    }
                    switch (stringArray3[0].toLowerCase()) {
                        case "s": 
                        case "size": {
                            hybridPlotWorld.PLOT_WIDTH = Integer.parseInt(stringArray3[1]);
                            hybridPlotWorld.SIZE = (short)(hybridPlotWorld.PLOT_WIDTH + hybridPlotWorld.ROAD_WIDTH);
                            continue block90;
                        }
                        case "g": 
                        case "gap": {
                            hybridPlotWorld.ROAD_WIDTH = Integer.parseInt(stringArray3[1]);
                            hybridPlotWorld.SIZE = (short)(hybridPlotWorld.PLOT_WIDTH + hybridPlotWorld.ROAD_WIDTH);
                            continue block90;
                        }
                        case "h": 
                        case "height": {
                            int n15;
                            hybridPlotWorld.PLOT_HEIGHT = n15 = Integer.parseInt(stringArray3[1]);
                            hybridPlotWorld.ROAD_HEIGHT = n15;
                            hybridPlotWorld.WALL_HEIGHT = n15;
                            continue block90;
                        }
                        case "f": 
                        case "floor": {
                            hybridPlotWorld.TOP_BLOCK = ConfigurationUtil.BLOCK_BUCKET.parseString(stringArray3[1]);
                            continue block90;
                        }
                        case "m": 
                        case "main": {
                            hybridPlotWorld.MAIN_BLOCK = ConfigurationUtil.BLOCK_BUCKET.parseString(stringArray3[1]);
                            continue block90;
                        }
                        case "w": 
                        case "wall": {
                            hybridPlotWorld.WALL_FILLING = ConfigurationUtil.BLOCK_BUCKET.parseString(stringArray3[1]);
                            continue block90;
                        }
                        case "b": 
                        case "border": {
                            hybridPlotWorld.WALL_BLOCK = ConfigurationUtil.BLOCK_BUCKET.parseString(stringArray3[1]);
                            continue block90;
                        }
                        case "terrain": {
                            hybridPlotWorld.setTerrain(PlotAreaTerrainType.fromString(stringArray3[1]).orElseThrow(() -> new IllegalArgumentException(stringArray3[1] + " is not a valid terrain.")));
                            plotAreaBuilder.terrainType(hybridPlotWorld.getTerrain());
                            continue block90;
                        }
                        case "type": {
                            hybridPlotWorld.setType(PlotAreaType.fromString(stringArray3[1]).orElseThrow(() -> new IllegalArgumentException(stringArray3[1] + " is not a valid type.")));
                            plotAreaBuilder.plotAreaType(hybridPlotWorld.getType());
                            continue block90;
                        }
                        default: {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(this.getCommandString()))).tag("value2", Tag.inserting(Component.text(" create [world[:id]] [<modifier>=<value>]..."))).build());
                            return false;
                        }
                    }
                }
                if (hybridPlotWorld.getType() != PlotAreaType.PARTIAL) {
                    if (this.worldUtil.isWorld(hybridPlotWorld.getWorldName())) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_taken"), TagResolver.resolver("value", Tag.inserting(Component.text(hybridPlotWorld.getWorldName()))));
                        return false;
                    }
                    Runnable runnable = () -> {
                        String string = "worlds." + hybridPlotWorld.getWorldName();
                        if (!this.worldConfiguration.contains(string)) {
                            this.worldConfiguration.createSection(string);
                        }
                        ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection(string);
                        hybridPlotWorld.saveConfiguration(configurationSection);
                        hybridPlotWorld.loadConfiguration(configurationSection);
                        plotAreaBuilder.plotManager(PlotSquared.platform().pluginName());
                        plotAreaBuilder.generatorName(PlotSquared.platform().pluginName());
                        String string2 = this.setupUtils.setupWorld(plotAreaBuilder);
                        if (this.worldUtil.isWorld(string2)) {
                            plotPlayer.teleport(this.worldUtil.getSpawn(string2), TeleportCause.COMMAND_AREA_CREATE);
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
                        } else {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.error_create"), TagResolver.resolver("world", Tag.inserting(Component.text(hybridPlotWorld.getWorldName()))));
                        }
                        try {
                            this.worldConfiguration.save(this.worldFile);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    };
                    if (this.hasConfirmation(plotPlayer)) {
                        CmdConfirm.addPending(plotPlayer, this.getCommandString() + " " + StringMan.join(stringArray, " "), runnable);
                    } else {
                        runnable.run();
                    }
                    return true;
                }
                if (hybridPlotWorld.getId() == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(this.getCommandString()))).tag("value2", Tag.inserting(Component.text(" create [world[:id]] [<modifier>=<value>]..."))).build());
                    return false;
                }
                if (this.worldUtil.isWorld(hybridPlotWorld.getWorldName())) {
                    if (!plotPlayer.getLocation().getWorldName().equals(hybridPlotWorld.getWorldName())) {
                        plotPlayer.teleport(this.worldUtil.getSpawn(hybridPlotWorld.getWorldName()), TeleportCause.COMMAND_AREA_CREATE);
                    }
                } else {
                    plotAreaBuilder.terrainType(PlotAreaTerrainType.NONE);
                    plotAreaBuilder.plotAreaType(PlotAreaType.NORMAL);
                    this.setupUtils.setupWorld(plotAreaBuilder);
                    plotPlayer.teleport(this.worldUtil.getSpawn(hybridPlotWorld.getWorldName()), TeleportCause.COMMAND_AREA_CREATE);
                }
                this.metaData.computeIfAbsent(plotPlayer.getUUID(), uUID -> new HashMap()).put("area_create_area", hybridPlotWorld);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.get_position"), TagResolver.resolver("command", Tag.inserting(Component.text(this.getCommandString()))));
                return true;
            }
            case "i": 
            case "info": {
                String string;
                double d;
                Object object;
                Object object3;
                PlotArea plotArea;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_INFO)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_INFO)));
                    return false;
                }
                switch (stringArray.length) {
                    case 1: {
                        plotArea = plotPlayer.getApplicablePlotArea();
                        break;
                    }
                    case 2: {
                        plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[1]);
                        break;
                    }
                    default: {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(this.getCommandString()))).tag("value2", Tag.inserting(Component.text(" info [area]"))).build());
                        return false;
                    }
                }
                if (plotArea == null) {
                    if (stringArray.length == 2) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    }
                    return false;
                }
                int n16 = plotArea.getPlotCount();
                int n17 = plotArea.getClusters().size();
                String string2 = String.valueOf(plotArea.getGenerator());
                if (plotArea.getType() == PlotAreaType.PARTIAL) {
                    object3 = plotArea.getMin();
                    PlotId plotId = plotArea.getMax();
                    object = plotArea.getWorldName() + ";" + plotArea.getId() + ";" + (PlotId)object3 + ";" + plotId;
                    int n18 = (plotId.getX() - ((PlotId)object3).getX() + 1) * (plotId.getY() - ((PlotId)object3).getY() + 1);
                    d = n16 == 0 ? 0.0 : (double)n18 / (double)n16;
                    string = plotArea.getRegion().toString();
                } else {
                    object = plotArea.getWorldName();
                    d = n16 == 0 ? 0.0 : 100.0 * (double)n16 / 2.147483647E9;
                    string = "N/A";
                }
                object3 = TagResolver.builder().tag("header", Tag.inserting(TranslatableCaption.of("info.plot_info_header").toComponent(plotPlayer))).tag("name", Tag.inserting(Component.text((String)object))).tag("type", Tag.inserting(Component.text(plotArea.getType().name()))).tag("terrain", Tag.inserting(Component.text(plotArea.getTerrain().name()))).tag("usage", Tag.inserting(Component.text(String.format("%.2f", d)))).tag("claimed", Tag.inserting(Component.text(n16))).tag("clusters", Tag.inserting(Component.text(n17))).tag("region", Tag.inserting(Component.text(string))).tag("generator", Tag.inserting(Component.text(string2))).tag("footer", Tag.inserting(TranslatableCaption.of("info.plot_info_footer").toComponent(plotPlayer))).build();
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.area_info_format"), new TagResolver[]{object3});
                return true;
            }
            case "l": 
            case "list": {
                int n19;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_LIST)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_LIST)));
                    return false;
                }
                switch (stringArray.length) {
                    case 1: {
                        n19 = 0;
                        break;
                    }
                    case 2: {
                        if (MathMan.isInteger(stringArray[1])) {
                            n19 = Integer.parseInt(stringArray[1]) - 1;
                            break;
                        }
                    }
                    default: {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax_extended"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(this.getCommandString()))).tag("value2", Tag.inserting(Component.text(" list [#]"))).build());
                        return false;
                    }
                }
                ArrayList<PlotArea> arrayList = new ArrayList<PlotArea>(Arrays.asList(this.plotAreaManager.getAllPlotAreas()));
                this.paginate(plotPlayer, arrayList, 8, n19, new RunnableVal3<Integer, PlotArea, CaptionHolder>(){

                    @Override
                    public void run(Integer n, PlotArea plotArea, CaptionHolder captionHolder) {
                        String string;
                        double d;
                        Object object;
                        Object object2;
                        Object object3;
                        int n2 = plotArea.getPlotCount();
                        int n3 = plotArea.getClusters().size();
                        String string2 = String.valueOf(plotArea.getGenerator());
                        if (plotArea.getType() == PlotAreaType.PARTIAL) {
                            object3 = plotArea.getMin();
                            object2 = plotArea.getMax();
                            object = plotArea.getWorldName() + ";" + plotArea.getId() + ";" + (PlotId)object3 + ";" + (PlotId)object2;
                            int n4 = (((PlotId)object2).getX() - ((PlotId)object3).getX() + 1) * (((PlotId)object2).getY() - ((PlotId)object3).getY() + 1);
                            d = n2 == 0 ? 0.0 : (double)n2 / (double)n4;
                            string = plotArea.getRegion().toString();
                        } else {
                            object = plotArea.getWorldName();
                            d = n2 == 0 ? 0.0 : (double)n2 / 32767.0 * 32767.0;
                            string = "N/A";
                        }
                        object3 = Command.MINI_MESSAGE.deserialize(TranslatableCaption.of("info.area_list_tooltip").getComponent(plotPlayer), TagResolver.builder().tag("claimed", Tag.inserting(Component.text(n2))).tag("usage", Tag.inserting(Component.text(String.format("%.2f", d) + "%"))).tag("clusters", Tag.inserting(Component.text(n3))).tag("region", Tag.inserting(Component.text(string))).tag("generator", Tag.inserting(Component.text(string2))).build());
                        object2 = TagResolver.builder().tag("hover_info", Tag.inserting((Component)object3)).tag("command_tp", Tag.preProcessParsed("/plot area tp " + (String)object)).tag("command_info", Tag.preProcessParsed("/plot area info " + (String)object)).tag("number", Tag.inserting(Component.text(n))).tag("area_name", Tag.inserting(Component.text((String)object))).tag("area_type", Tag.inserting(Component.text(plotArea.getType().name()))).tag("area_terrain", Tag.inserting(Component.text(plotArea.getTerrain().name()))).build();
                        captionHolder.set(TranslatableCaption.of("info.area_list_item"));
                        captionHolder.setTagResolvers(new TagResolver[]{object2});
                    }
                }, "/plot area list", TranslatableCaption.of("list.area_list_header_paged"));
                return true;
            }
            case "regen": 
            case "clear": 
            case "reset": 
            case "regenerate": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_REGEN)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_REGEN)));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (plotArea.getType() != PlotAreaType.PARTIAL) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.delete_world_region"), TagResolver.resolver("world", Tag.inserting(Component.text(plotArea.getWorldName()))));
                    return false;
                }
                QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(plotArea.getWorldName()));
                queueCoordinator.setChunkConsumer(blockVector2 -> AugmentedUtils.generateChunk(plotArea.getWorldName(), blockVector2.getX(), blockVector2.getZ(), null));
                queueCoordinator.addReadChunks(plotArea.getRegion().getChunks());
                queueCoordinator.setCompleteTask(() -> plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.regeneration_complete"), new TagResolver[0]));
                queueCoordinator.enqueue();
                return true;
            }
            case "goto": 
            case "v": 
            case "teleport": 
            case "visit": 
            case "tp": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_AREA_TP)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_AREA_TP)));
                    return false;
                }
                if (stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot area tp [area]"))));
                    return false;
                }
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[1]);
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    return false;
                }
                if (plotArea instanceof SinglePlotArea) {
                    ((SinglePlotArea)plotArea).loadWorld(PlotId.of(0, 0));
                    Location location = this.worldUtil.getSpawn(PlotId.of(0, 0).toUnderscoreSeparatedString());
                    plotPlayer.teleport(location, TeleportCause.COMMAND_AREA_TELEPORT);
                } else if (plotArea.getType() != PlotAreaType.PARTIAL) {
                    Location location = this.worldUtil.getSpawn(plotArea.getWorldName());
                    plotPlayer.teleport(location, TeleportCause.COMMAND_AREA_TELEPORT);
                } else {
                    CuboidRegion cuboidRegion = plotArea.getRegion();
                    Location location = Location.at(plotArea.getWorldName(), cuboidRegion.getMinimumPoint().getX() + (cuboidRegion.getMaximumPoint().getX() - cuboidRegion.getMinimumPoint().getX()) / 2, 0, cuboidRegion.getMinimumPoint().getZ() + (cuboidRegion.getMaximumPoint().getZ() - cuboidRegion.getMinimumPoint().getZ()) / 2);
                    this.worldUtil.getHighestBlock(plotArea.getWorldName(), location.getX(), location.getZ(), n -> plotPlayer.teleport(location.withY(1 + n), TeleportCause.COMMAND_AREA_TELEPORT));
                }
                return true;
            }
            case "delete": 
            case "remove": {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.worldcreation_location"), new TagResolver[0]);
                return true;
            }
        }
        this.sendUsage(plotPlayer);
        return false;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                linkedList.add("create");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_CREATE)) {
                linkedList.add("single");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_LIST)) {
                linkedList.add("list");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_INFO)) {
                linkedList.add("info");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_AREA_TP)) {
                linkedList.add("tp");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_AREA) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }

    private /* synthetic */ void lambda$onCommand$0(HybridPlotWorld hybridPlotWorld, PlotAreaBuilder plotAreaBuilder, BlockVector3 blockVector3, PlotPlayer plotPlayer) {
        String string;
        String string2 = "worlds." + hybridPlotWorld.getWorldName() + ".areas." + hybridPlotWorld.getId() + "-" + plotAreaBuilder.minimumId() + "-" + plotAreaBuilder.maximumId();
        int n = blockVector3.getX();
        int n2 = blockVector3.getZ();
        if (n != 0) {
            this.worldConfiguration.set(string2 + ".road.offset.x", n);
        }
        if (n2 != 0) {
            this.worldConfiguration.set(string2 + ".road.offset.z", n2);
        }
        if (this.worldUtil.isWorld(string = this.setupUtils.setupWorld(plotAreaBuilder))) {
            PlotSquared.get().loadWorld(string, null);
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("single.single_area_created"), new TagResolver[0]);
        } else {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.error_create"), TagResolver.resolver("world", Tag.inserting(Component.text(hybridPlotWorld.getWorldName()))));
        }
    }
}

