/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="clear", requiredType=RequiredType.NONE, permission="plots.clear", category=CommandCategory.APPEARANCE, usage="/plot clear", aliases={"reset"}, confirmation=true)
public class Clear
extends Command {
    private final EventDispatcher eventDispatcher;
    private final GlobalBlockQueue blockQueue;

    @Inject
    public Clear(@NonNull EventDispatcher eventDispatcher, @NonNull GlobalBlockQueue globalBlockQueue) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
        this.blockQueue = globalBlockQueue;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (stringArray.length != 0) {
            this.sendUsage(plotPlayer);
            return CompletableFuture.completedFuture(false);
        }
        Plot plot = this.check(plotPlayer.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
        Result result = this.eventDispatcher.callClear(plot).getEventResult();
        if (result == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Clear"))));
            return CompletableFuture.completedFuture(true);
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return CompletableFuture.completedFuture(true);
        }
        boolean bl = result == Result.FORCE;
        this.checkTrue(bl || plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission("plots.admin.command.clear"), TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
        this.checkTrue(plot.getRunning() == 0, TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
        this.checkTrue(bl || !Settings.Done.RESTRICT_BUILDING || !DoneFlag.isDone(plot) || plotPlayer.hasPermission("plots.continue"), TranslatableCaption.of("done.done_already_done"), new TagResolver[0]);
        runnableVal3.run(this, () -> {
            if (Settings.Teleport.ON_CLEAR) {
                plot.getPlayersInPlot().forEach(plotPlayer -> plot.teleportPlayer((PlotPlayer<?>)plotPlayer, TeleportCause.COMMAND_CLEAR, bl -> {}));
            }
            BackupManager.backup(plotPlayer, plot, () -> {
                long l = System.currentTimeMillis();
                boolean bl = plot.getPlotModificationManager().clear(true, false, plotPlayer, () -> TaskManager.runTask(() -> {
                    PlotFlag plotFlag;
                    PlotFlagRemoveEvent plotFlagRemoveEvent;
                    plot.removeRunning();
                    if (DoneFlag.isDone(plot) && (plotFlagRemoveEvent = this.eventDispatcher.callFlagRemove(plotFlag = plot.getFlagContainer().getFlag(DoneFlag.class), plot)).getEventResult() != Result.DENY) {
                        plot.removeFlag(plotFlagRemoveEvent.getFlag());
                    }
                    if (!((List)plot.getFlag(AnalysisFlag.class)).isEmpty() && (plotFlagRemoveEvent = this.eventDispatcher.callFlagRemove(plotFlag = plot.getFlagContainer().getFlag(AnalysisFlag.class), plot)).getEventResult() != Result.DENY) {
                        plot.removeFlag(plotFlagRemoveEvent.getFlag());
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.clearing_done"), TagResolver.builder().tag("amount", Tag.inserting(Component.text(System.currentTimeMillis() - l))).tag("plot", Tag.inserting(Component.text(plot.getId().toString()))).build());
                }));
                if (!bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
                } else {
                    plot.addRunning();
                }
            });
        }, null);
        return CompletableFuture.completedFuture(true);
    }
}

