/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.format.NamedTextColor;
import com.plotsquared.core.configuration.adventure.text.format.Style;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.util.ComponentHelper;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@CommandDeclaration(command="cluster", aliases={"clusters"}, category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.NONE, permission="plots.cluster")
public class Cluster
extends SubCommand {
    private static final Component[] AVAILABLE_ARGS = (Component[])Stream.of("list", "create", "delete", "resize", "invite", "kick", "leave", "helpers", "tp", "sethome").map(string -> (TextComponent)Component.text(string).style(Style.style(NamedTextColor.DARK_AQUA))).toArray(Component[]::new);
    private static final Component SEPARATOR = Component.text(", ").style(Style.style(NamedTextColor.GRAY));

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_available_args"), TagResolver.resolver("list", Tag.inserting(ComponentHelper.join(AVAILABLE_ARGS, SEPARATOR))));
            return false;
        }
        switch (string = stringArray[0].toLowerCase()) {
            case "l": 
            case "list": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_LIST)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_LIST)));
                    return false;
                }
                if (stringArray.length != 1) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster list"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                Set<PlotCluster> set = plotArea.getClusters();
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_heading"), TagResolver.resolver("amount", Tag.inserting(Component.text(set.size()))));
                for (PlotCluster plotCluster : set) {
                    String string3 = "'" + plotCluster.getName() + "' : " + plotCluster;
                    if (plotPlayer.getUUID().equals(plotCluster.owner)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element_owner"), TagResolver.resolver("cluster", Tag.inserting(Component.text(string3))));
                        continue;
                    }
                    if (plotCluster.helpers.contains(plotPlayer.getUUID())) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element_helpers"), TagResolver.resolver("cluster", Tag.inserting(Component.text(string3))));
                        continue;
                    }
                    if (plotCluster.invited.contains(plotPlayer.getUUID())) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element_invited"), TagResolver.resolver("cluster", Tag.inserting(Component.text(string3))));
                        continue;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_list_element"), TagResolver.resolver("cluster", Tag.inserting(Component.text(plotCluster.toString()))));
                }
                return true;
            }
            case "c": 
            case "create": {
                Object object;
                PlotId plotId;
                Object object2;
                int n;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_CREATE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_CREATE)));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (stringArray.length != 4) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster create <name> <id-bot> <id-top>"))));
                    return false;
                }
                int n2 = n = Settings.Limit.GLOBAL ? plotPlayer.getClusterCount() : plotPlayer.getPlotCount(plotPlayer.getLocation().getWorldName());
                if (n >= plotPlayer.getAllowedPlots()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_claim_more_clusters"), TagResolver.resolver("amount", Tag.inserting(Component.text(plotPlayer.getAllowedPlots()))));
                }
                try {
                    object2 = PlotId.fromString(stringArray[2]);
                    plotId = PlotId.fromString(stringArray[3]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), new TagResolver[0]);
                    return false;
                }
                String string4 = stringArray[1];
                if (plotArea.getCluster(string4) != null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("alias.alias_is_taken"), TagResolver.resolver("alias", Tag.inserting(Component.text(string4))));
                    return false;
                }
                if (plotId.getX() < ((PlotId)object2).getX() || plotId.getY() < ((PlotId)object2).getY()) {
                    object = PlotId.of(Math.min(((PlotId)object2).getX(), plotId.getX()), Math.min(((PlotId)object2).getY(), plotId.getY()));
                    plotId = PlotId.of(Math.max(((PlotId)object2).getX(), plotId.getX()), Math.max(((PlotId)object2).getY(), plotId.getY()));
                    object2 = object;
                }
                if ((object = plotArea.getFirstIntersectingCluster((PlotId)object2, plotId)) != null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_intersection"), TagResolver.resolver("cluster", Tag.inserting(Component.text(((PlotCluster)object).getName()))));
                    return false;
                }
                if (!plotArea.contains((PlotId)object2) || !plotArea.contains(plotId)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_outside"), TagResolver.resolver("area", Tag.inserting(Component.text(plotArea.toString()))));
                    return false;
                }
                Set<Plot> set = plotArea.getPlotSelectionOwned((PlotId)object2, plotId);
                if (!set.isEmpty() && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_CREATE_OTHER)) {
                    UUID uUID2 = plotPlayer.getUUID();
                    for (Plot object3 : set) {
                        if (object3.isOwner(uUID2)) continue;
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_CREATE_OTHER)));
                        return false;
                    }
                }
                object = new PlotCluster(plotArea, (PlotId)object2, plotId, plotPlayer.getUUID());
                int n3 = Settings.Limit.GLOBAL ? plotPlayer.getPlayerClusterCount() : plotPlayer.getPlayerClusterCount(plotPlayer.getLocation().getWorldName());
                int n4 = plotPlayer.hasPermissionRange(Permission.PERMISSION_CLUSTER_SIZE, Settings.Limit.MAX_PLOTS);
                if (n3 + ((PlotCluster)object).getArea() > n4) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_CLUSTER_SIZE + "." + (n3 + ((PlotCluster)object).getArea())))));
                    return false;
                }
                ((PlotCluster)object).settings.setAlias(string4);
                plotArea.addCluster((PlotCluster)object);
                DBFunc.createCluster((PlotCluster)object);
                for (Plot plot : set) {
                    if (!plot.hasOwner() || ((PlotCluster)object).isAdded(plot.getOwner())) continue;
                    ((PlotCluster)object).invited.add(plot.getOwner());
                    DBFunc.setInvited((PlotCluster)object, plot.getOwner());
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_created"), TagResolver.resolver("name", Tag.inserting(Component.text(string4))));
                return true;
            }
            case "disband": 
            case "del": 
            case "delete": {
                PlotCluster plotCluster;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_DELETE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_DELETE)));
                    return false;
                }
                if (stringArray.length != 1 && stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster delete [name]"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (stringArray.length == 2) {
                    plotCluster = plotArea.getCluster(stringArray[1]);
                    if (plotCluster == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), TagResolver.resolver("cluster", Tag.inserting(Component.text(stringArray[1]))));
                        return false;
                    }
                } else {
                    plotCluster = plotArea.getCluster(plotPlayer.getLocation());
                    if (plotCluster == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                        return false;
                    }
                }
                if (!plotCluster.owner.equals(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_DELETE_OTHER)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_DELETE_OTHER)));
                    return false;
                }
                DBFunc.delete(plotCluster);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_deleted"), TagResolver.resolver("cluster", Tag.inserting(Component.text(plotCluster.toString()))));
                return true;
            }
            case "res": 
            case "resize": {
                PlotArea plotArea;
                PlotId plotId;
                PlotId plotId2;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_RESIZE)));
                    return false;
                }
                if (stringArray.length != 3) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster resize [name]"))));
                    return false;
                }
                try {
                    plotId2 = PlotId.fromString(stringArray[2]);
                    plotId = PlotId.fromString(stringArray[3]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), new TagResolver[0]);
                    return false;
                }
                if (plotId.getX() < plotId2.getX() || plotId.getY() < plotId2.getY()) {
                    plotId2 = PlotId.of(Math.min(plotId2.getX(), plotId.getX()), Math.min(plotId2.getY(), plotId.getY()));
                    plotId = PlotId.of(Math.max(plotId2.getX(), plotId.getX()), Math.max(plotId2.getY(), plotId.getY()));
                }
                if ((plotArea = plotPlayer.getApplicablePlotArea()) == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                PlotCluster plotCluster = plotArea.getCluster(plotPlayer.getLocation());
                if (plotCluster == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!plotCluster.hasHelperRights(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE_OTHER)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_RESIZE_OTHER)));
                    return false;
                }
                PlotCluster plotCluster2 = plotArea.getFirstIntersectingCluster(plotId2, plotId);
                if (plotCluster2 != null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_intersection"), TagResolver.resolver("cluster", Tag.inserting(Component.text(plotCluster2.getName()))));
                    return false;
                }
                Set<Plot> set = plotArea.getPlotSelectionOwned(plotCluster.getP1(), plotCluster.getP2());
                Set<Plot> set2 = plotArea.getPlotSelectionOwned(plotId2, plotId);
                HashSet<Plot> hashSet = new HashSet<Plot>(set);
                hashSet.removeAll(set2);
                if (!hashSet.isEmpty() && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE_SHRINK)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_RESIZE_SHRINK)));
                    return false;
                }
                set2.removeAll(set);
                if (!set2.isEmpty() && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE_EXPAND)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_RESIZE_EXPAND)));
                    return false;
                }
                int n = Settings.Limit.GLOBAL ? plotPlayer.getPlayerClusterCount() : plotPlayer.getPlayerClusterCount(plotPlayer.getLocation().getWorldName());
                int n3 = plotPlayer.hasPermissionRange(Permission.PERMISSION_CLUSTER, Settings.Limit.MAX_PLOTS);
                if ((n -= plotCluster.getArea() + (1 + plotId.getX() - plotId2.getX()) * (1 + plotId.getY() - plotId2.getY())) + plotCluster.getArea() > n3) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_CLUSTER + "." + (n + plotCluster.getArea())))));
                    return false;
                }
                DBFunc.resizeCluster(plotCluster, plotId2, plotId);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_resized"), new TagResolver[0]);
                return true;
            }
            case "add": 
            case "inv": 
            case "invite": {
                PlotCluster plotCluster;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_INVITE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_INVITE)));
                    return false;
                }
                if (stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster invite <player>"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((plotCluster = plotArea.getCluster(plotPlayer.getLocation())) == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!plotCluster.hasHelperRights(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_INVITE_OTHER)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_INVITE_OTHER)));
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(stringArray[1], (uUID, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    } else {
                        if (!plotCluster.isAdded((UUID)uUID)) {
                            plotCluster.invited.add((UUID)uUID);
                            DBFunc.setInvited(plotCluster, uUID);
                            PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uUID);
                            if (plotPlayer2 != null) {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_invited"), TagResolver.resolver("cluster", Tag.inserting(Component.text(plotCluster.getName()))));
                            }
                        }
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_added_user"), new TagResolver[0]);
                    }
                });
                return true;
            }
            case "k": 
            case "remove": 
            case "kick": {
                PlotCluster plotCluster;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_KICK)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_KICK)));
                    return false;
                }
                if (stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster kick <player>"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((plotCluster = plotArea.getCluster(plotPlayer.getLocation())) == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!plotCluster.hasHelperRights(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_KICK_OTHER)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_KICK_OTHER)));
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(stringArray[1], (uUID, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    } else if (uUID.equals(plotPlayer.getUUID()) || uUID.equals(plotCluster.owner) || !plotCluster.isAdded((UUID)uUID)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cannot_kick_player"), TagResolver.resolver("value", Tag.inserting(Component.text(plotCluster.getName()))));
                    } else {
                        if (plotCluster.helpers.contains(uUID)) {
                            plotCluster.helpers.remove(uUID);
                            DBFunc.removeHelper(plotCluster, uUID);
                        }
                        plotCluster.invited.remove(uUID);
                        DBFunc.removeInvited(plotCluster, uUID);
                        PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uUID);
                        if (plotPlayer2 != null) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_removed"), TagResolver.resolver("cluster", Tag.inserting(Component.text(plotCluster.getName()))));
                        }
                        this.removePlayerPlots(plotCluster, (UUID)uUID, plotPlayer2.getLocation().getWorldName());
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_kicked_user"), new TagResolver[0]);
                    }
                });
                return true;
            }
            case "quit": 
            case "leave": {
                UUID uUID3;
                PlotCluster plotCluster;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_LEAVE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_LEAVE)));
                    return false;
                }
                if (stringArray.length != 1 && stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster leave [name]"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if (stringArray.length == 2) {
                    plotCluster = plotArea.getCluster(stringArray[1]);
                    if (plotCluster == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), TagResolver.resolver("cluster", Tag.inserting(Component.text(stringArray[1]))));
                        return false;
                    }
                } else {
                    plotCluster = plotArea.getCluster(plotPlayer.getLocation());
                    if (plotCluster == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                        return false;
                    }
                }
                if (!plotCluster.isAdded(uUID3 = plotPlayer.getUUID())) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_not_added"), new TagResolver[0]);
                    return false;
                }
                if (uUID3.equals(plotCluster.owner)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_cannot_leave"), new TagResolver[0]);
                    return false;
                }
                if (plotCluster.helpers.contains(uUID3)) {
                    plotCluster.helpers.remove(uUID3);
                    DBFunc.removeHelper(plotCluster, uUID3);
                }
                plotCluster.invited.remove(uUID3);
                DBFunc.removeInvited(plotCluster, uUID3);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_removed"), TagResolver.resolver("cluster", Tag.inserting(Component.text(plotCluster.getName()))));
                this.removePlayerPlots(plotCluster, uUID3, plotPlayer.getLocation().getWorldName());
                return true;
            }
            case "members": {
                PlotCluster plotCluster;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_HELPERS)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_CLUSTER_HELPERS.toString()))));
                    return false;
                }
                if (stringArray.length != 3) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster members <add | remove> <player>"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((plotCluster = plotArea.getCluster(plotPlayer.getLocation())) == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(stringArray[2], (uUID, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[2]))));
                    } else if (stringArray[1].equalsIgnoreCase("add")) {
                        plotCluster.helpers.add((UUID)uUID);
                        DBFunc.setHelper(plotCluster, uUID);
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_added_helper"), new TagResolver[0]);
                    } else if (stringArray[1].equalsIgnoreCase("remove")) {
                        plotCluster.helpers.remove(uUID);
                        DBFunc.removeHelper(plotCluster, uUID);
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_removed_helper"), new TagResolver[0]);
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster members <add | remove> <player>"))));
                    }
                });
                return true;
            }
            case "spawn": 
            case "home": 
            case "tp": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_TP)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_TP)));
                    return false;
                }
                if (stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster tp <name>"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                PlotCluster plotCluster = plotArea.getCluster(stringArray[1]);
                if (plotCluster == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), TagResolver.resolver("cluster", Tag.inserting(Component.text(stringArray[1]))));
                    return false;
                }
                UUID uUID4 = plotPlayer.getUUID();
                if (!plotCluster.isAdded(uUID4) && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_TP_OTHER)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_TP_OTHER)));
                    return false;
                }
                plotCluster.getHome(location -> plotPlayer.teleport((Location)location, TeleportCause.COMMAND_CLUSTER_TELEPORT));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_teleporting"), new TagResolver[0]);
                return true;
            }
            case "i": 
            case "info": 
            case "show": 
            case "information": {
                PlotCluster plotCluster;
                PlotArea plotArea;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_INFO)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_TP)));
                    return false;
                }
                if (stringArray.length != 1 && stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster info [name]"))));
                }
                if ((plotArea = plotPlayer.getApplicablePlotArea()) == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                    return false;
                }
                if (stringArray.length == 2) {
                    plotCluster = plotArea.getCluster(stringArray[1]);
                    if (plotCluster == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.invalid_cluster_name"), TagResolver.resolver("cluster", Tag.inserting(Component.text(stringArray[1]))));
                        return false;
                    }
                } else {
                    plotCluster = plotArea.getCluster(plotPlayer.getLocation());
                    if (plotCluster == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                        return false;
                    }
                }
                String string5 = plotCluster.toString();
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(plotCluster.owner, (string2, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else {
                        String string3 = Objects.requireNonNullElse(string2, "unknown");
                        String string4 = plotCluster.getName();
                        String string5 = plotCluster.getP2().getX() - plotCluster.getP1().getX() + 1 + "x" + (plotCluster.getP2().getY() - plotCluster.getP1().getY() + 1);
                        String string6 = "" + plotCluster.isAdded(plotPlayer.getUUID());
                        TranslatableCaption translatableCaption = TranslatableCaption.of("cluster.cluster_info");
                        TagResolver tagResolver = TagResolver.builder().tag("id", Tag.inserting(Component.text(string5))).tag("owner", Tag.inserting(Component.text(string3))).tag("name", Tag.inserting(Component.text(string4))).tag("size", Tag.inserting(Component.text(string5))).tag("rights", Tag.inserting(Component.text(string6))).build();
                        plotPlayer.sendMessage((Caption)translatableCaption, tagResolver);
                    }
                });
                return true;
            }
            case "sh": 
            case "setspawn": 
            case "sethome": {
                PlotCluster plotCluster;
                if (!plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_SETHOME)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_SETHOME)));
                    return false;
                }
                if (stringArray.length != 1 && stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot cluster sethome"))));
                    return false;
                }
                PlotArea plotArea = plotPlayer.getApplicablePlotArea();
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
                }
                if ((plotCluster = plotArea.getCluster(plotPlayer.getLocation())) == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_cluster"), new TagResolver[0]);
                    return false;
                }
                if (!plotCluster.hasHelperRights(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_SETHOME_OTHER)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_CLUSTER_SETHOME_OTHER)));
                    return false;
                }
                Location location2 = plotCluster.getClusterBottom();
                Location location3 = plotPlayer.getLocation().subtract(location2.getX(), 0, location2.getZ());
                BlockLoc blockLoc = new BlockLoc(location3.getX(), location3.getY(), location3.getZ());
                plotCluster.settings.setPosition(blockLoc);
                DBFunc.setPosition(plotCluster, location3.getX() + "," + location3.getY() + "," + location3.getZ());
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("position.position_set"), new TagResolver[0]);
                return true;
            }
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("cluster.cluster_available_args"), TagResolver.resolver("list", Tag.inserting(ComponentHelper.join(AVAILABLE_ARGS, SEPARATOR))));
        return false;
    }

    private void removePlayerPlots(PlotCluster plotCluster, UUID uUID, String string) {
        block0: for (Plot plot : PlotQuery.newQuery().inWorld(string).ownedBy(uUID)) {
            PlotCluster plotCluster2 = plot.getCluster();
            if (plotCluster2 == null || !plotCluster2.equals(plotCluster)) continue;
            if (plot.getOwners().size() == 1) {
                plot.unclaim();
                continue;
            }
            for (UUID uUID2 : plot.getOwners()) {
                if (uUID2.equals(uUID)) continue;
                plot.setOwner(uUID2);
                continue block0;
            }
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_LIST)) {
                linkedList.add("list");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_CREATE)) {
                linkedList.add("create");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_DELETE)) {
                linkedList.add("delete");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_RESIZE)) {
                linkedList.add("resize");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_INVITE)) {
                linkedList.add("invite");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_KICK)) {
                linkedList.add("kick");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_KICK)) {
                linkedList.add("leave");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_HELPERS)) {
                linkedList.add("members");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_INFO)) {
                linkedList.add("info");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_TP)) {
                linkedList.add("tp");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER_SETHOME)) {
                linkedList.add("sethome");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_CLUSTER) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

