/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CmdInstance;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CmdConfirm {
    public static @Nullable CmdInstance getPending(PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<CmdInstance> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_CONFIRM);){
            CmdInstance cmdInstance = metaDataAccess.get().orElse(null);
            return cmdInstance;
        }
    }

    public static void removePending(PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<CmdInstance> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_CONFIRM);){
            metaDataAccess.remove();
        }
    }

    public static void addPending(PlotPlayer<?> plotPlayer, String string, Runnable runnable) {
        CmdConfirm.removePending(plotPlayer);
        if (string != null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("confirm.requires_confirm"), TagResolver.builder().tag("command", Tag.inserting(Component.text(string))).tag("timeout", Tag.inserting(Component.text(Settings.Confirmation.CONFIRMATION_TIMEOUT_SECONDS))).tag("value", Tag.inserting(Component.text("/plot confirm"))).build());
        }
        TaskManager.runTaskLater(() -> {
            CmdInstance cmdInstance = new CmdInstance(runnable);
            try (MetaDataAccess<CmdInstance> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_CONFIRM);){
                metaDataAccess.set(cmdInstance);
            }
        }, TaskTime.ticks(1L));
    }
}

