/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Command {
    static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final ArrayList<Command> allCommands = new ArrayList();
    private final ArrayList<Command> dynamicCommands = new ArrayList();
    private final HashMap<String, Command> staticCommands = new HashMap();
    private final Command parent;
    private final boolean isStatic;
    private String id;
    private List<String> aliases;
    private RequiredType required;
    private String usage;
    private Caption description;
    private String permission;
    private boolean confirmation;
    private CommandCategory category;
    private Argument<?>[] arguments;

    public Command(Command command, boolean bl, String string, String string2, RequiredType requiredType, CommandCategory commandCategory) {
        this.parent = command;
        this.isStatic = bl;
        this.id = string;
        this.permission = string2;
        this.required = requiredType;
        this.category = commandCategory;
        this.aliases = Collections.singletonList(string);
        if (this.parent != null) {
            this.parent.register(this);
        }
    }

    public Command(Command command, boolean bl) {
        this.parent = command;
        this.isStatic = bl;
        CommandDeclaration commandDeclaration = this.getClass().getAnnotation(CommandDeclaration.class);
        if (commandDeclaration != null) {
            this.init(commandDeclaration);
        }
        for (final Method method : this.getClass().getDeclaredMethods()) {
            Class<?>[] classArray;
            if (!method.isAnnotationPresent(CommandDeclaration.class) || (classArray = method.getParameterTypes()).length != 5 || classArray[0] != Command.class || classArray[1] != PlotPlayer.class || classArray[2] != String[].class || classArray[3] != RunnableVal3.class || classArray[4] != RunnableVal2.class) continue;
            Command command2 = new Command(this, true){

                @Override
                public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, CommandResult> runnableVal2) {
                    try {
                        method.invoke((Object)Command.this, this, plotPlayer, stringArray, runnableVal3, runnableVal2);
                        return CompletableFuture.completedFuture(true);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                        return CompletableFuture.completedFuture(false);
                    }
                }
            };
            command2.init(method.getAnnotation(CommandDeclaration.class));
        }
    }

    public Command getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public String getFullId() {
        if (this.parent != null && this.parent.getParent() != null) {
            return this.parent.getFullId() + "." + this.id;
        }
        return this.id;
    }

    public List<Command> getCommands(PlotPlayer<?> plotPlayer) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Command command : this.allCommands) {
            if (!command.canExecute(plotPlayer, false)) continue;
            arrayList.add(command);
        }
        return arrayList;
    }

    public List<Command> getCommands(CommandCategory commandCategory, PlotPlayer<?> plotPlayer) {
        List<Command> list = this.getCommands(plotPlayer);
        if (commandCategory != null) {
            list.removeIf(command -> command.category != commandCategory);
        }
        return list;
    }

    public List<Command> getCommands() {
        return this.allCommands;
    }

    public boolean hasConfirmation(PermissionHolder permissionHolder) {
        return this.confirmation && !permissionHolder.hasPermission(this.getPermission() + ".confirm.bypass");
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Caption getDescription() {
        return this.description;
    }

    public RequiredType getRequiredType() {
        return this.required;
    }

    public Argument<?>[] getRequiredArguments() {
        return this.arguments;
    }

    public void setRequiredArguments(Argument<?>[] argumentArray) {
        this.arguments = argumentArray;
    }

    public void init(CommandDeclaration commandDeclaration) {
        this.id = commandDeclaration.command();
        this.permission = commandDeclaration.permission();
        this.required = commandDeclaration.requiredType();
        this.category = commandDeclaration.category();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.id);
        arrayList.addAll(Arrays.asList(commandDeclaration.aliases()));
        this.aliases = arrayList;
        if (commandDeclaration.description().isEmpty()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(this.id);
            for (Command command = this.getParent(); command != null && !command.equals(MainCommand.getInstance()); command = command.getParent()) {
                arrayList2.add(command.getId());
            }
            Collections.reverse(arrayList2);
            String string = String.join((CharSequence)".", arrayList2);
            this.description = TranslatableCaption.of(String.format("commands.description.%s", string));
        } else {
            this.description = StaticCaption.of(commandDeclaration.description());
        }
        this.usage = commandDeclaration.usage();
        this.confirmation = commandDeclaration.confirmation();
        if (this.parent != null) {
            this.parent.register(this);
        }
    }

    public void register(Command command) {
        if (command.isStatic) {
            for (String string : command.aliases) {
                this.staticCommands.put(string.toLowerCase(), command);
            }
        } else {
            this.dynamicCommands.add(command);
        }
        this.allCommands.add(command);
    }

    public String getPermission() {
        if (this.permission != null && !this.permission.isEmpty()) {
            return this.permission;
        }
        if (this.parent == null) {
            return "plots.use";
        }
        return "plots." + this.getFullId();
    }

    public <T> void paginate(PlotPlayer<?> plotPlayer, List<T> list, int n, int n2, RunnableVal3<Integer, T, CaptionHolder> runnableVal3, String string, Caption caption) {
        int n3;
        int n4;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > (n4 = (int)Math.floor((double)list.size() / (double)n))) {
            n2 = n4;
        }
        if ((n3 = n2 * n + n) > list.size()) {
            n3 = list.size();
        }
        plotPlayer.sendMessage(caption, TagResolver.builder().tag("cur", Tag.inserting(Component.text(n2 + 1))).tag("max", Tag.inserting(Component.text(n4 + 1))).tag("amount", Tag.inserting(Component.text(list.size()))).build());
        List<T> list2 = list.subList(n2 * n, n3);
        int n5 = n2 * n;
        for (T t : list2) {
            CaptionHolder captionHolder = new CaptionHolder();
            runnableVal3.run(++n5, (Integer)t, captionHolder);
            plotPlayer.sendMessage(captionHolder.get(), captionHolder.getTagResolvers());
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("list.page_turn"), TagResolver.builder().tag("cur", Tag.inserting(Component.text(n2 + 1))).tag("command1", Tag.preProcessParsed(string + " " + n2)).tag("command2", Tag.preProcessParsed(string + " " + (n2 + 2))).tag("clickable", Tag.inserting(TranslatableCaption.of("list.clickable").toComponent(plotPlayer))).build());
    }

    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, CommandResult> runnableVal2) {
        if (stringArray.length == 0 || stringArray[0] == null) {
            if (this.parent == null) {
                MainCommand.getInstance().help.displayHelp(plotPlayer, null, 0);
            } else {
                this.sendUsage(plotPlayer);
            }
            return CompletableFuture.completedFuture(false);
        }
        if (this.allCommands.isEmpty()) {
            plotPlayer.sendMessage((Caption)StaticCaption.of("Not Implemented: https://github.com/IntellectualSites/PlotSquared/issues"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        Command object = this.getCommand(stringArray[0]);
        if (object == null) {
            if (this.parent != null) {
                this.sendUsage(plotPlayer);
                return CompletableFuture.completedFuture(false);
            }
            try {
                if (!MathMan.isInteger(stringArray[0])) {
                    CommandCategory.valueOf(stringArray[0].toUpperCase());
                }
                MainCommand.getInstance().help.execute(plotPlayer, stringArray, null, null);
                return CompletableFuture.completedFuture(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.not_valid_subcommand"), new TagResolver[0]);
                List<Command> list = this.getCommands(plotPlayer);
                if (list.isEmpty()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.did_you_mean"), TagResolver.resolver("value", Tag.inserting(Component.text(MainCommand.getInstance().help.getUsage()))));
                    return CompletableFuture.completedFuture(false);
                }
                HashSet<String> hashSet = new HashSet<String>(stringArray.length);
                for (String object2 : stringArray) {
                    hashSet.add(object2.toLowerCase());
                }
                String[] stringArray2 = hashSet.toArray(new String[0]);
                int n = 0;
                for (Command command : list) {
                    int n2 = this.getMatch(stringArray2, command, plotPlayer);
                    if (n2 <= n) continue;
                    object = command;
                }
                if (object == null) {
                    object = new StringComparison<Command>(stringArray[0], this.allCommands).getMatchObject();
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.did_you_mean"), TagResolver.resolver("value", Tag.inserting(Component.text(object.getUsage()))));
                return CompletableFuture.completedFuture(false);
            }
        }
        String[] stringArray3 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
        if (!object.checkArgs(plotPlayer, stringArray3) || !object.canExecute(plotPlayer, true)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            object.execute(plotPlayer, stringArray3, runnableVal3, runnableVal2);
        }
        catch (CommandException commandException) {
            commandException.perform(plotPlayer);
        }
        return CompletableFuture.completedFuture(true);
    }

    public boolean checkArgs(PlotPlayer<?> plotPlayer, String[] stringArray) {
        Argument<?>[] argumentArray = this.getRequiredArguments();
        if (argumentArray != null && argumentArray.length > 0) {
            boolean bl = stringArray.length < argumentArray.length;
            String[] stringArray2 = this.getCommandString().split(" ");
            Object[] objectArray = this.getUsage().split(" ");
            if (objectArray.length - stringArray2.length < argumentArray.length) {
                String[] stringArray3 = new String[stringArray2.length + argumentArray.length];
                System.arraycopy(objectArray, 0, stringArray3, 0, objectArray.length);
                objectArray = stringArray3;
            }
            for (int i = 0; i < argumentArray.length; ++i) {
                objectArray[i + stringArray2.length] = argumentArray[i].getExample().toString();
                bl = bl || argumentArray[i].parse(stringArray[i]) == null;
            }
            if (bl) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(StringMan.join(objectArray, " ")))));
                return false;
            }
        }
        return true;
    }

    public int getMatch(String[] stringArray, Command command, PlotPlayer<?> plotPlayer) {
        String string2 = command.getPermission();
        int n = command.getAliases().stream().filter(string -> string.startsWith(stringArray[0])).mapToInt(string -> 5).sum();
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, command.getDescription().getComponent(plotPlayer).split(" "));
        for (String stringArray2 : stringArray) {
            if (string2.startsWith(stringArray2)) {
                ++n;
            }
            if (!hashSet.contains(stringArray2)) continue;
            ++n;
        }
        String[] stringArray3 = command.getUsage().split(" ");
        for (int i = 0; i < Math.min(4, stringArray3.length); ++i) {
            String[] stringArray2;
            int n2 = stringArray3[i].startsWith("<") ? 1 : 0;
            for (String string3 : stringArray2 = stringArray3[i].split("\\|| |\\>|\\<|\\[|\\]|\\{|\\}|\\_|\\/")) {
                for (String string4 : stringArray) {
                    if (!string4.equalsIgnoreCase(string3)) continue;
                    n += 5 - i + n2;
                }
            }
        }
        return n += StringMan.intersection(hashSet, stringArray);
    }

    public Command getCommand(String string) {
        Command command = this.staticCommands.get(string.toLowerCase());
        if (command == null) {
            for (Command command2 : this.dynamicCommands) {
                if (!command2.matches(string)) continue;
                return command2;
            }
        }
        return command;
    }

    public Command getCommand(Class<?> clazz) {
        for (Command command : this.allCommands) {
            if (command.getClass() != clazz) continue;
            return command;
        }
        return null;
    }

    public Command getCommandById(String string) {
        Command command = this.staticCommands.get(string);
        if (command != null) {
            return command;
        }
        for (Command command2 : this.allCommands) {
            if (!command2.getId().equals(string)) continue;
            return command2;
        }
        return null;
    }

    public boolean canExecute(PlotPlayer<?> plotPlayer, boolean bl) {
        if (plotPlayer == null) {
            return true;
        }
        if (!this.required.allows(plotPlayer)) {
            if (bl) {
                plotPlayer.sendMessage(this.required.getErrorMessage(), new TagResolver[0]);
            }
        } else if (!plotPlayer.hasPermission(this.getPermission())) {
            if (bl) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(this.getPermission()))));
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean matches(String string) {
        return StringMan.isEqual(string = string.toLowerCase(), this.id) || this.aliases.contains(string);
    }

    public String getCommandString() {
        if (this.parent == null) {
            return "/" + this.toString();
        }
        return this.parent.getCommandString() + " " + this.toString();
    }

    public void sendUsage(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
    }

    public String getUsage() {
        if (this.usage != null && !this.usage.isEmpty()) {
            if (this.usage.startsWith("/")) {
                return this.usage;
            }
            return this.getCommandString() + " " + this.usage;
        }
        if (this.allCommands.isEmpty()) {
            return this.getCommandString();
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        String string = "";
        for (Command command : this.allCommands) {
            stringBuilder.append(string).append((String)(command.isStatic ? command.toString() : "<" + command + ">"));
            string = "|";
        }
        return this.getCommandString() + " " + stringBuilder + "]";
    }

    public Collection<Command> tabOf(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl, String ... stringArray2) {
        if (!bl) {
            return null;
        }
        ArrayList<Command> arrayList = new ArrayList<Command>();
        int n = stringArray.length;
        for (String string : stringArray2) {
            String[] stringArray3 = (string = string.replace(this.getCommandString() + " ", "")).split(" ");
            if (stringArray3.length <= n) continue;
            string = StringMan.join(Arrays.copyOfRange(stringArray3, n, stringArray3.length), " ");
            Command command = new Command(null, false, string, this.getPermission(), this.getRequiredType(), null){};
            arrayList.add(command);
        }
        return arrayList;
    }

    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        switch (stringArray.length) {
            case 0: {
                return this.allCommands;
            }
            case 1: {
                String string = stringArray[0].toLowerCase();
                if (bl) {
                    Command command = this.getCommand(string);
                    if (command != null && command.canExecute(plotPlayer, false)) {
                        return command.tab(plotPlayer, Arrays.copyOfRange(stringArray, 1, stringArray.length), bl);
                    }
                    return null;
                }
                HashSet<Command> hashSet = new HashSet<Command>();
                for (Map.Entry<String, Command> entry : this.staticCommands.entrySet()) {
                    if (!entry.getKey().startsWith(string) || !entry.getValue().canExecute(plotPlayer, false)) continue;
                    hashSet.add(entry.getValue());
                }
                return hashSet;
            }
        }
        Command command = this.getCommand(stringArray[0]);
        if (command != null) {
            return command.tab(plotPlayer, Arrays.copyOfRange(stringArray, 1, stringArray.length), bl);
        }
        return null;
    }

    public String toString() {
        return !this.aliases.isEmpty() ? this.aliases.get(0) : this.id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Command command = (Command)object;
        if (this.hashCode() != command.hashCode()) {
            return false;
        }
        return this.getFullId().equals(command.getFullId());
    }

    public int hashCode() {
        return this.getFullId().hashCode();
    }

    public void checkTrue(boolean bl, Caption caption, TagResolver ... tagResolverArray) {
        if (!bl) {
            throw new CommandException(caption, tagResolverArray);
        }
    }

    public <T> T check(T t, Caption caption, TagResolver ... tagResolverArray) {
        if (t == null) {
            throw new CommandException(caption, tagResolverArray);
        }
        return t;
    }

    public static class CommandException
    extends RuntimeException {
        private final Caption message;
        private final TagResolver[] args;

        public CommandException(@Nullable Caption caption, TagResolver ... tagResolverArray) {
            this.message = caption;
            this.args = tagResolverArray;
        }

        public void perform(@Nullable PlotPlayer<?> plotPlayer) {
            if (plotPlayer != null && this.message != null) {
                plotPlayer.sendMessage(this.message, this.args);
            }
        }
    }

    public static enum CommandResult {
        FAILURE,
        SUCCESS;

    }
}

