/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.CommentInbox;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.StringMan;
import java.util.Arrays;
import java.util.Locale;

@CommandDeclaration(command="comment", aliases={"msg"}, category=CommandCategory.CHAT, requiredType=RequiredType.PLAYER, permission="plots.comment")
public class Comment
extends SubCommand {
    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_syntax"), TagResolver.builder().tag("command", Tag.inserting(Component.text("/plot comment [X;Z]"))).tag("list", Tag.inserting(Component.text(StringMan.join(CommentManager.inboxes.keySet(), "|")))).build());
            return false;
        }
        Plot plot = null;
        if (!CommentManager.inboxes.containsKey(stringArray[0].toLowerCase(Locale.ENGLISH))) {
            plot = Plot.getPlotFromString(plotPlayer, stringArray[0], false);
        }
        if (plot == null) {
            n = 1;
            plot = plotPlayer.getLocation().getPlotAbs();
        } else {
            if (stringArray.length < 3) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_syntax"), TagResolver.builder().tag("command", Tag.inserting(Component.text("/plot comment [X;Z]"))).tag("list", Tag.inserting(Component.text(StringMan.join(CommentManager.inboxes.keySet(), "|")))).build());
                return false;
            }
            n = 2;
        }
        CommentInbox commentInbox = CommentManager.inboxes.get(stringArray[n - 1].toLowerCase());
        if (commentInbox == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_syntax"), TagResolver.builder().tag("command", Tag.inserting(Component.text("/plot comment [X;Z]"))).tag("list", Tag.inserting(Component.text(StringMan.join(CommentManager.inboxes.keySet(), "|")))).build());
            return false;
        }
        if (!commentInbox.canWrite(plot, plotPlayer)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.no_perm_inbox"), new TagResolver[0]);
            return false;
        }
        String string = StringMan.join(Arrays.copyOfRange(stringArray, n, stringArray.length), " ");
        PlotComment plotComment = new PlotComment(plotPlayer.getLocation().getWorldName(), plot.getId(), string, plotPlayer.getName(), commentInbox.toString(), System.currentTimeMillis());
        boolean bl = commentInbox.addComment(plot, plotComment);
        if (!bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.no_plot_inbox"), new TagResolver[0]);
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_syntax"), TagResolver.builder().tag("command", Tag.inserting(Component.text("/plot comment [X;Z]"))).tag("list", Tag.inserting(Component.text(StringMan.join(CommentManager.inboxes.keySet(), "|")))).build());
            return false;
        }
        for (PlotPlayer<?> plotPlayer2 : PlotSquared.platform().playerManager().getPlayers()) {
            if (!plotPlayer2.getAttribute("chatspy")) continue;
            plotPlayer2.sendMessage((Caption)StaticCaption.of("/plot comment " + StringMan.join(stringArray, " ")), new TagResolver[0]);
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_added"), new TagResolver[0]);
        return true;
    }
}

