/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="delete", permission="plots.delete", usage="/plot delete", aliases={"dispose", "del"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE, confirmation=true)
public class Delete
extends SubCommand {
    private final EventDispatcher eventDispatcher;
    private final EconHandler econHandler;

    @Inject
    public Delete(@NonNull EventDispatcher eventDispatcher, @NonNull EconHandler econHandler) {
        this.eventDispatcher = eventDispatcher;
        this.econHandler = econHandler;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        boolean bl;
        Location location = plotPlayer.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        Result result = this.eventDispatcher.callDelete(plot).getEventResult();
        if (result == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Delete"))));
            return true;
        }
        boolean bl2 = bl = result == Result.FORCE;
        if (!(bl || plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DELETE))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        PlotArea plotArea = plot.getArea();
        Set<Plot> set = plot.getConnectedPlots();
        int n = Settings.Limit.GLOBAL ? plotPlayer.getPlotCount() : plotPlayer.getPlotCount(location.getWorldName());
        Runnable runnable = () -> {
            boolean bl;
            if (plot.getRunning() > 0) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
                return;
            }
            long l = System.currentTimeMillis();
            if (Settings.Teleport.ON_DELETE) {
                plot.getPlayersInPlot().forEach(plotPlayer -> plot.teleportPlayer((PlotPlayer<?>)plotPlayer, TeleportCause.COMMAND_DELETE, bl -> {}));
            }
            if (bl = plot.getPlotModificationManager().deletePlot(plotPlayer, () -> {
                plot.removeRunning();
                if (this.econHandler.isEnabled(plotArea)) {
                    PlotExpression plotExpression = plotArea.getPrices().get("sell");
                    double[] dArray = new double[]{n};
                    double d = (double)set.size() * plotExpression.evaluate(dArray);
                    if (d > 0.0) {
                        this.econHandler.depositMoney(plotPlayer, d);
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("economy.added_balance"), TagResolver.resolver("money", Tag.inserting(Component.text(this.econHandler.format(d)))));
                    }
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.deleting_done"), TagResolver.resolver("amount", Tag.inserting(Component.text(String.valueOf(System.currentTimeMillis() - l)))), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
                this.eventDispatcher.callPostDelete(plot);
            })) {
                plot.addRunning();
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            }
        };
        if (this.hasConfirmation(plotPlayer)) {
            CmdConfirm.addPending(plotPlayer, this.getCommandString() + " " + plot.getId(), runnable);
        } else {
            TaskManager.runTask(runnable);
        }
        return true;
    }
}

