/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.PlotUploader;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(usage="/plot download [schem | world]", command="download", aliases={"dl"}, category=CommandCategory.SCHEMATIC, requiredType=RequiredType.NONE, permission="plots.download")
public class Download
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final PlotUploader plotUploader;
    private final @NonNull SchematicHandler schematicHandler;
    private final WorldUtil worldUtil;

    @Inject
    public Download(@NonNull PlotAreaManager plotAreaManager, @NonNull PlotUploader plotUploader, @NonNull SchematicHandler schematicHandler, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.plotUploader = plotUploader;
        this.schematicHandler = schematicHandler;
        this.worldUtil = worldUtil;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        String string = plotPlayer.getLocation().getWorldName();
        if (!this.plotAreaManager.hasPlotArea(string)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot_world"), new TagResolver[0]);
            return false;
        }
        final Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (Settings.Done.REQUIRED_FOR_DOWNLOAD && !DoneFlag.isDone(plot) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DOWNLOAD)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("done.done_not_done"), new TagResolver[0]);
            return false;
        }
        if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        if (stringArray.length == 0 || stringArray.length == 1 && StringMan.isEqualIgnoreCaseToAny(stringArray[0], "sch", "schem", "schematic")) {
            if (plot.getVolume() > 2.147483647E9) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
                return false;
            }
            plot.addRunning();
            this.upload(plotPlayer, plot);
        } else if (stringArray.length == 1 && StringMan.isEqualIgnoreCaseToAny(stringArray[0], "mcr", "world", "mca")) {
            if (!plotPlayer.hasPermission(Permission.PERMISSION_DOWNLOAD_WORLD)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_DOWNLOAD_WORLD)));
                return false;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.mca_file_size"), new TagResolver[0]);
            plot.addRunning();
            this.worldUtil.saveWorld(string);
            this.worldUtil.upload(plot, null, null, new RunnableVal<URL>(){

                @Override
                public void run(URL uRL) {
                    plot.removeRunning();
                    if (uRL == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generating_link_failed"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
                        return;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generation_link_success_legacy_world"), TagResolver.resolver("url", Tag.inserting(Component.text(uRL.toString()))));
                }
            });
        } else {
            this.sendUsage(plotPlayer);
            return false;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generating_link"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_DOWNLOAD)) {
                linkedList.add("schem");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_DOWNLOAD_WORLD)) {
                linkedList.add("world");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_DOWNLOAD) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }

    private void upload(final PlotPlayer<?> plotPlayer, final Plot plot) {
        if (Settings.Web.LEGACY_WEBINTERFACE) {
            this.schematicHandler.getCompoundTag(plot).whenComplete((compoundTag, throwable) -> this.schematicHandler.upload((CompoundTag)compoundTag, null, null, new RunnableVal<URL>(){

                @Override
                public void run(URL uRL) {
                    plot.removeRunning();
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generation_link_success"), TagResolver.builder().tag("download", Tag.preProcessParsed(uRL.toString())).tag("delete", Tag.preProcessParsed("Not available")).build());
                    plotPlayer.sendMessage((Caption)StaticCaption.of(uRL.toString()), new TagResolver[0]);
                }
            }));
            return;
        }
        this.plotUploader.upload(plot).whenComplete((plotUploadResult, throwable) -> {
            if (throwable != null || !plotUploadResult.isSuccess()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generating_link_failed"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("web.generation_link_success"), TagResolver.builder().tag("download", Tag.preProcessParsed(plotUploadResult.getDownloadUrl())).tag("delete", Tag.preProcessParsed(plotUploadResult.getDeletionUrl())).build());
            }
        });
    }
}

