/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.common.primitives.Ints;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

@CommandDeclaration(command="grant", category=CommandCategory.CLAIMING, usage="/plot grant <check | add> [player]", permission="plots.grant", requiredType=RequiredType.NONE)
public class Grant
extends Command {
    public Grant() {
        super(MainCommand.getInstance(), true);
    }

    @Override
    public CompletableFuture<Boolean> execute(final PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        String string;
        this.checkTrue(stringArray.length >= 1 && stringArray.length <= 2, TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot grant <check | add> [player]"))));
        switch (string = stringArray[0].toLowerCase()) {
            case "add": 
            case "check": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_GRANT.format(string))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text(Permission.PERMISSION_GRANT.format(string)))));
                    return CompletableFuture.completedFuture(false);
                }
                if (stringArray.length != 2) break;
                PlayerManager.getUUIDsFromString(stringArray[1], (collection, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null || collection.size() != 1) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(String.valueOf(collection)))));
                    } else {
                        final UUID uUID = (UUID)collection.iterator().next();
                        PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
                        if (plotPlayer2 != null) {
                            try (MetaDataAccess<Integer> metaDataAccess = plotPlayer2.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                                if (stringArray[0].equalsIgnoreCase("check")) {
                                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("grants.granted_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(metaDataAccess.get().orElse(0)))));
                                }
                                metaDataAccess.set(metaDataAccess.get().orElse(0) + 1);
                            }
                        } else {
                            DBFunc.getPersistentMeta(uUID, new RunnableVal<Map<String, byte[]>>(){

                                @Override
                                public void run(Map<String, byte[]> map) {
                                    byte[] byArray = map.get("grantedPlots");
                                    if (string.equals("check")) {
                                        int n = byArray == null ? 0 : Ints.fromByteArray((byte[])byArray);
                                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("grants.granted_plots"), TagResolver.resolver("amount", Tag.inserting(Component.text(n))));
                                    } else {
                                        int n = byArray == null ? 1 : 1 + Ints.fromByteArray((byte[])byArray);
                                        boolean bl = byArray != null;
                                        String string2 = "grantedPlots";
                                        byte[] byArray2 = Ints.toByteArray((int)n);
                                        DBFunc.addPersistentMeta(uUID, string2, byArray2, bl);
                                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("grants.added"), TagResolver.resolver("grants", Tag.inserting(Component.text(n))));
                                    }
                                }
                            });
                        }
                    }
                });
                return CompletableFuture.completedFuture(true);
            }
        }
        this.sendUsage(plotPlayer);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_GRANT_ADD)) {
                linkedList.add("add");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_GRANT_CHECK)) {
                linkedList.add("check");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_GRANT_SINGLE) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

