/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.helpmenu.HelpMenu;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;

@CommandDeclaration(command="help", aliases={"?"}, category=CommandCategory.INFO, usage="help [category | #]", permission="plots.use")
public class Help
extends Command {
    public Help(Command command) {
        super(command, true);
    }

    @Override
    public boolean canExecute(PlotPlayer<?> plotPlayer, boolean bl) {
        return true;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        switch (stringArray.length) {
            case 0: {
                return this.displayHelp(plotPlayer, null, 0);
            }
            case 1: {
                if (MathMan.isInteger(stringArray[0])) {
                    try {
                        return this.displayHelp(plotPlayer, null, Integer.parseInt(stringArray[0]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.displayHelp(plotPlayer, null, 1);
                    }
                }
                return this.displayHelp(plotPlayer, stringArray[0], 1);
            }
            case 2: {
                if (MathMan.isInteger(stringArray[1])) {
                    try {
                        return this.displayHelp(plotPlayer, stringArray[0], Integer.parseInt(stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.displayHelp(plotPlayer, stringArray[0], 1);
                    }
                }
                return CompletableFuture.completedFuture(false);
            }
        }
        this.sendUsage(plotPlayer);
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<Boolean> displayHelp(PlotPlayer<?> plotPlayer, String string, int n) {
        return CompletableFuture.supplyAsync(() -> {
            String string2 = string;
            CommandCategory commandCategory = null;
            if (string2 != null && !"all".equalsIgnoreCase(string2)) {
                for (CommandCategory commandCategory2 : CommandCategory.values()) {
                    if (!StringMan.isEqualIgnoreCaseToAny(string2, commandCategory2.name(), commandCategory2.toString())) continue;
                    commandCategory = commandCategory2;
                    string2 = commandCategory2.name();
                    break;
                }
                if (commandCategory == null) {
                    string2 = null;
                }
            }
            if (string2 == null && n == 0) {
                TextComponent.Builder builder = Component.text();
                builder.append((Component)MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_header").getComponent(plotPlayer)));
                for (CommandCategory commandCategory3 : CommandCategory.values()) {
                    if (!commandCategory3.canAccess(plotPlayer)) continue;
                    ((TextComponent.Builder)builder.append((Component)Component.newline())).append(MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_info_item").getComponent(plotPlayer), TagResolver.builder().tag("command", Tag.inserting(Component.text("/plot help"))).tag("category", Tag.inserting(Component.text(commandCategory3.name().toLowerCase()))).tag("category_desc", Tag.inserting(commandCategory3.toComponent(plotPlayer))).build()));
                }
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append(MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_info_item").getComponent(plotPlayer), TagResolver.builder().tag("command", Tag.inserting(Component.text("/plot help"))).tag("category", Tag.inserting(Component.text("all"))).tag("category_desc", Tag.inserting(TranslatableCaption.of("help.help_display_all_commands").toComponent(plotPlayer))).build()));
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_footer").getComponent(plotPlayer)));
                plotPlayer.sendMessage((Caption)StaticCaption.of((String)MINI_MESSAGE.serialize(builder.asComponent())), new TagResolver[0]);
                return true;
            }
            new HelpMenu(plotPlayer).setCategory(commandCategory).getCommands().generateMaxPages().generatePage(n - 1, this.getParent().toString(), plotPlayer).render();
            return true;
        });
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        String string = stringArray[0].toLowerCase(Locale.ENGLISH);
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (CommandCategory commandCategory : CommandCategory.values()) {
            String string2;
            if (!commandCategory.canAccess(plotPlayer) || !(string2 = commandCategory.name().toLowerCase()).startsWith(string)) continue;
            arrayList.add(new Command(null, false, string2, "", RequiredType.NONE, null){});
        }
        if ("all".startsWith(string)) {
            arrayList.add(new Command(null, false, "all", "", RequiredType.NONE, null){});
        }
        return arrayList;
    }
}

