/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.CommentInbox;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.TypeLiteral;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@CommandDeclaration(command="inbox", usage="/plot inbox [inbox] [delete <index> | clear | page]", permission="plots.inbox", category=CommandCategory.CHAT, requiredType=RequiredType.PLAYER)
public class Inbox
extends SubCommand {
    public void displayComments(PlotPlayer<?> plotPlayer, List<PlotComment> list, int n) {
        int n2;
        int n3;
        if (list == null || list.isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.inbox_empty"), new TagResolver[0]);
            return;
        }
        PlotComment[] plotCommentArray = list.toArray(new PlotComment[0]);
        if (n < 0) {
            n = 0;
        }
        if (n > (n3 = (int)Math.ceil(plotCommentArray.length / 12))) {
            n = n3;
        }
        if ((n2 = n * 12 + 12) > plotCommentArray.length) {
            n2 = plotCommentArray.length;
        }
        TextComponent.Builder builder = Component.text();
        builder.append(MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_header_paged").getComponent(plotPlayer) + "\n", TagResolver.builder().tag("amount", Tag.inserting(Component.text(plotCommentArray.length))).tag("cur", Tag.inserting(Component.text(n + 1))).tag("max", Tag.inserting(Component.text(n3 + 1))).tag("word", Tag.inserting(Component.text("all"))).build()));
        for (int i = n * 12; i < n2; ++i) {
            PlotComment plotComment = plotCommentArray[i];
            Component component = plotPlayer.getName().equals(plotComment.senderName()) ? MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_by_lister").getComponent(plotPlayer), (TagResolver)TagResolver.resolver("comment", Tag.inserting(Component.text(plotComment.comment())))) : MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_by_other").getComponent(plotPlayer), (TagResolver)TagResolver.resolver("comment", Tag.inserting(Component.text(plotComment.comment()))));
            TagResolver tagResolver = TagResolver.builder().tag("number", Tag.inserting(Component.text(i))).tag("world", Tag.inserting(Component.text(plotComment.world()))).tag("plot_id", Tag.inserting(Component.text(plotComment.id().getX() + ";" + plotComment.id().getY()))).tag("commenter", Tag.inserting(Component.text(plotComment.senderName()))).tag("comment", Tag.inserting(component)).build();
            builder.append(MINI_MESSAGE.deserialize(TranslatableCaption.of("list.comment_list_comment").getComponent(plotPlayer), tagResolver));
        }
        plotPlayer.sendMessage((Caption)StaticCaption.of((String)MINI_MESSAGE.serialize(builder.build())), new TagResolver[0]);
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n;
        final Plot plot = plotPlayer.getCurrentPlot();
        if (plot == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        if (stringArray.length == 0) {
            this.sendUsage(plotPlayer);
            for (final CommentInbox commentInbox : CommentManager.inboxes.values()) {
                if (!commentInbox.canRead(plot, plotPlayer) || commentInbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

                    @Override
                    public void run(List<PlotComment> list) {
                        if (list != null) {
                            int n = 0;
                            int n2 = 0;
                            for (PlotComment plotComment : list) {
                                ++n;
                                if (plotComment.timestamp() <= CommentManager.getTimestamp(plotPlayer, commentInbox.toString())) continue;
                                ++n2;
                            }
                            if (n != 0) {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.inbox_item"), TagResolver.resolver("value", Tag.inserting(Component.text(commentInbox + " (" + n + "/" + n2 + ")"))));
                                return;
                            }
                        }
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.inbox_item"), TagResolver.resolver("value", Tag.inserting(Component.text(commentInbox.toString()))));
                    }
                })) continue;
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.inbox_item"), TagResolver.resolver("value", Tag.inserting(Component.text(commentInbox.toString()))));
            }
            return false;
        }
        final CommentInbox commentInbox = CommentManager.inboxes.get(stringArray[0].toLowerCase());
        if (commentInbox == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.invalid_inbox"), TagResolver.resolver("list", Tag.inserting(Component.text(StringMan.join(CommentManager.inboxes.keySet(), ", ")))));
            return false;
        }
        MetaDataKey<Long> metaDataKey = MetaDataKey.of(String.format("inbox:%s", commentInbox), new TypeLiteral<Long>(){});
        try (MetaDataAccess<Long> metaDataAccess = plotPlayer.accessTemporaryMetaData(metaDataKey);){
            metaDataAccess.set(System.currentTimeMillis());
        }
        if (stringArray.length > 1) {
            switch (stringArray[1].toLowerCase()) {
                case "delete": {
                    int n2;
                    if (!commentInbox.canModify(plot, plotPlayer)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.no_perm_inbox_modify"), new TagResolver[0]);
                        return false;
                    }
                    if (stringArray.length != 3) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot inbox " + commentInbox + " delete <index>"))));
                        return true;
                    }
                    try {
                        n2 = Integer.parseInt(stringArray[2]);
                        if (n2 < 1) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.not_valid_inbox_index"), TagResolver.resolver("number", Tag.inserting(Component.text(n2))));
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot inbox " + commentInbox + " delete <index>"))));
                        return false;
                    }
                    if (!commentInbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

                        @Override
                        public void run(List<PlotComment> list) {
                            if (n2 > list.size()) {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.not_valid_inbox_index"), TagResolver.resolver("number", Tag.inserting(Component.text(n2))));
                                return;
                            }
                            PlotComment plotComment = list.get(n2 - 1);
                            commentInbox.removeComment(plot, plotComment);
                            boolean bl = plot.getPlotCommentContainer().removeComment(plotComment);
                            if (bl) {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_removed_success"), TagResolver.resolver("value", Tag.inserting(Component.text(plotComment.comment()))));
                            } else {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_removed_failure"), new TagResolver[0]);
                            }
                        }
                    })) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                        return false;
                    }
                    return true;
                }
                case "clear": {
                    if (!commentInbox.canModify(plot, plotPlayer)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.no_perm_inbox_modify"), new TagResolver[0]);
                    }
                    commentInbox.clearInbox(plot);
                    List<PlotComment> list = plot.getPlotCommentContainer().getComments(commentInbox.toString());
                    if (!list.isEmpty()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.comment_removed_success"), TagResolver.resolver("value", Tag.inserting(Component.text("*"))));
                        plot.getPlotCommentContainer().removeComments(list);
                    }
                    return true;
                }
            }
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.sendUsage(plotPlayer);
                return false;
            }
        }
        n = 1;
        if (!commentInbox.canRead(plot, plotPlayer)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("comment.no_perm_inbox"), new TagResolver[0]);
            return false;
        }
        if (!commentInbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

            @Override
            public void run(List<PlotComment> list) {
                Inbox.this.displayComments(plotPlayer, list, n);
            }
        })) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_INBOX_READ_OWNER)) {
                linkedList.add("owner");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_INBOX_READ_PUBLIC)) {
                linkedList.add("public");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_INBOX_READ_REPORT)) {
                linkedList.add("report");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.PLAYER, CommandCategory.CHAT){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_INBOX) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

