/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotRateEvent;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="like", permission="plots.like", usage="/plot like [next | purge]", category=CommandCategory.INFO, requiredType=RequiredType.PLAYER)
public class Like
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Like(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public static double getLikesPercentage(Plot plot) {
        if (!plot.hasRatings()) {
            return 0.0;
        }
        Collection<Boolean> collection = plot.getLikes().values();
        double d = 0.0;
        double d2 = 0.0;
        for (boolean bl : collection) {
            if (bl) {
                d += 1.0;
                continue;
            }
            d2 += 1.0;
        }
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d2 == 0.0) {
            return 1.0;
        }
        return d / (d + d2);
    }

    protected boolean handleLike(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl2) {
        Object object;
        UUID uUID = plotPlayer.getUUID();
        if (stringArray.length == 1) {
            switch (stringArray[0].toLowerCase()) {
                case "next": {
                    List<Plot> list = PlotQuery.newQuery().whereBasePlot().asList();
                    list.sort((plot, plot2) -> {
                        double d;
                        double d2 = Like.getLikesPercentage(plot);
                        if (d2 == (d = Like.getLikesPercentage(plot2))) {
                            return 0;
                        }
                        return d > d2 ? 1 : -1;
                    });
                    for (Plot plot3 : list) {
                        if (Settings.Done.REQUIRED_FOR_RATINGS && !DoneFlag.isDone(plot3) || !plot3.isBasePlot() || plot3.getLikes().containsKey(uUID)) continue;
                        plot3.teleportPlayer(plotPlayer, TeleportCause.COMMAND_LIKE, bl -> {});
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("tutorial.rate_this"), new TagResolver[0]);
                        return true;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
                    return true;
                }
                case "purge": {
                    Plot plot4 = plotPlayer.getCurrentPlot();
                    if (plot4 == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                        return false;
                    }
                    if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS, true)) {
                        return false;
                    }
                    plot4.clearRatings();
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.ratings_purged"), new TagResolver[0]);
                    return true;
                }
            }
        }
        if ((object = plotPlayer.getCurrentPlot()) == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!((Plot)object).hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_owned"), new TagResolver[0]);
            return false;
        }
        if (((Plot)object).isOwner(plotPlayer.getUUID())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_your_own"), new TagResolver[0]);
            return false;
        }
        if (Settings.Done.REQUIRED_FOR_RATINGS && !DoneFlag.isDone((Plot)object)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_done"), new TagResolver[0]);
            return false;
        }
        Runnable runnable = () -> this.lambda$handleLike$2((Plot)object, uUID, plotPlayer, bl2);
        if (((Plot)object).getSettings().getRatings() == null) {
            if (!Settings.Enabled_Components.RATING_CACHE) {
                TaskManager.runTaskAsync(() -> Like.lambda$handleLike$3((Plot)object, runnable));
                return true;
            }
            ((Plot)object).getSettings().setRatings(new HashMap<UUID, Integer>());
        }
        runnable.run();
        return true;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        return this.handleLike(plotPlayer, stringArray, true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS)) {
                linkedList.add("purge");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.PLAYER, CommandCategory.INFO){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_RATE) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }

    private static /* synthetic */ void lambda$handleLike$3(Plot plot, Runnable runnable) {
        plot.getSettings().setRatings(DBFunc.getRatings(plot));
        runnable.run();
    }

    private /* synthetic */ void lambda$handleLike$2(Plot plot, UUID uUID, PlotPlayer plotPlayer, boolean bl) {
        Boolean bl2 = plot.getLikes().get(uUID);
        if (bl2 != null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_already_exists"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            return;
        }
        int n = bl ? 10 : 1;
        plot.addRating(uUID, new Rating(n));
        PlotRateEvent plotRateEvent = this.eventDispatcher.callRating(plotPlayer, plot, new Rating(n));
        if (plotRateEvent.getRating() != null) {
            plot.addRating(uUID, plotRateEvent.getRating());
            if (bl) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_liked"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            } else {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_disliked"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            }
        }
    }
}

