/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.PriceFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="list", aliases={"l", "find", "search"}, permission="plots.list", category=CommandCategory.INFO, usage="/plot list <forsale | mine | shared | world | top | all | unowned | player | world | done | fuzzy <search...>> [#]")
public class ListCmd
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final EconHandler econHandler;

    @Inject
    public ListCmd(@NonNull PlotAreaManager plotAreaManager, @NonNull EconHandler econHandler) {
        this.plotAreaManager = plotAreaManager;
        this.econHandler = econHandler;
    }

    private String[] getArgumentList(PlotPlayer<?> plotPlayer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.econHandler != null && plotPlayer.hasPermission(Permission.PERMISSION_LIST_FOR_SALE)) {
            arrayList.add("forsale");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_MINE)) {
            arrayList.add("mine");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_SHARED)) {
            arrayList.add("shared");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
            arrayList.add("world");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_TOP)) {
            arrayList.add("top");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_ALL)) {
            arrayList.add("all");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_UNOWNED)) {
            arrayList.add("unowned");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_PLAYER)) {
            arrayList.add("<player>");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
            arrayList.add("<world>");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_DONE)) {
            arrayList.add("done");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_EXPIRED)) {
            arrayList.add("expired");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_FUZZY)) {
            arrayList.add("fuzzy <search...>");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void noArgs(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.subcommand_set_options_header"), TagResolver.resolver("values", Tag.inserting(Component.text(Arrays.toString(this.getArgumentList(plotPlayer))))));
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            this.noArgs(plotPlayer);
            return false;
        }
        if (stringArray.length > 1) {
            int n2 = -1;
            try {
                n2 = Integer.parseInt(stringArray[stringArray.length - 1]);
                if (--n2 < 0) {
                    n2 = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n = n2;
        } else {
            n = 0;
        }
        String string = plotPlayer.getLocation().getWorldName();
        PlotArea plotArea = plotPlayer.getApplicablePlotArea();
        String string2 = stringArray[0].toLowerCase();
        boolean[] blArray = new boolean[]{true};
        Consumer<PlotQuery> consumer = plotQuery -> {
            List<Plot> list;
            if (plotQuery == null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.did_you_mean"), TagResolver.resolver("value", Tag.inserting(Component.text(new StringComparison<String>(stringArray[0], new String[]{"mine", "shared", "world", "all"}).getBestMatch()))));
                return;
            }
            if (plotArea != null) {
                plotQuery.relativeToArea(plotArea);
            }
            if (blArray[0]) {
                plotQuery.withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
            }
            if ((list = plotQuery.asList()).isEmpty()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
                return;
            }
            this.displayPlots(plotPlayer, list, 12, n, stringArray);
        };
        switch (string2) {
            case "mine": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_MINE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.mine"))));
                    return false;
                }
                blArray[0] = false;
                consumer.accept(PlotQuery.newQuery().ownersInclude(plotPlayer).whereBasePlot().withSortingStrategy(SortingStrategy.SORT_BY_TEMP));
                break;
            }
            case "shared": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_SHARED)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.shared"))));
                    return false;
                }
                consumer.accept(PlotQuery.newQuery().withMember(plotPlayer.getUUID()).thatPasses(plot -> !plot.isOwnerAbs(plotPlayer.getUUID())));
                break;
            }
            case "world": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.world"))));
                    return false;
                }
                if (!plotPlayer.hasPermission("plots.list.world." + string)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.world." + string))));
                    return false;
                }
                consumer.accept(PlotQuery.newQuery().inWorld(string));
                break;
            }
            case "expired": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_EXPIRED)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.expired"))));
                    return false;
                }
                if (PlotSquared.platform().expireManager() == null) {
                    consumer.accept(PlotQuery.newQuery().noPlots());
                    break;
                }
                consumer.accept(PlotQuery.newQuery().expiredPlots());
                break;
            }
            case "area": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_AREA)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.area"))));
                    return false;
                }
                if (!plotPlayer.hasPermission("plots.list.world." + string)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.world." + string))));
                    return false;
                }
                if (plotArea == null) {
                    consumer.accept(PlotQuery.newQuery().noPlots());
                    break;
                }
                consumer.accept(PlotQuery.newQuery().inArea(plotArea));
                break;
            }
            case "all": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_ALL)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.all"))));
                    return false;
                }
                consumer.accept(PlotQuery.newQuery().allPlots());
                break;
            }
            case "done": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_DONE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.done"))));
                    return false;
                }
                blArray[0] = false;
                consumer.accept(PlotQuery.newQuery().allPlots().thatPasses(DoneFlag::isDone).withSortingStrategy(SortingStrategy.SORT_BY_DONE));
                break;
            }
            case "top": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_TOP)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.top"))));
                    return false;
                }
                blArray[0] = false;
                consumer.accept(PlotQuery.newQuery().allPlots().withSortingStrategy(SortingStrategy.SORT_BY_RATING));
                break;
            }
            case "forsale": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_FOR_SALE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.forsale"))));
                    return false;
                }
                if (this.econHandler.isSupported()) break;
                consumer.accept(PlotQuery.newQuery().allPlots().thatPasses(plot -> (Double)plot.getFlag(PriceFlag.class) > 0.0));
                break;
            }
            case "unowned": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_UNOWNED)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.unowned"))));
                    return false;
                }
                consumer.accept(PlotQuery.newQuery().allPlots().thatPasses(plot -> plot.getOwner() == null));
                break;
            }
            case "fuzzy": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_FUZZY)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.fuzzy"))));
                    return false;
                }
                if (stringArray.length < (n == -1 ? 2 : 3)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot list fuzzy <search...> [#]"))));
                    return false;
                }
                String string3 = MathMan.isInteger(stringArray[stringArray.length - 1]) ? StringMan.join(Arrays.copyOfRange(stringArray, 1, stringArray.length - 1), " ") : StringMan.join(Arrays.copyOfRange(stringArray, 1, stringArray.length), " ");
                blArray[0] = false;
                consumer.accept(PlotQuery.newQuery().plotsBySearch(string3));
                break;
            }
            default: {
                if (this.plotAreaManager.hasPlotArea(stringArray[0])) {
                    if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.world"))));
                        return false;
                    }
                    if (!plotPlayer.hasPermission("plots.list.world." + stringArray[0])) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.world." + stringArray[0]))));
                        return false;
                    }
                    consumer.accept(PlotQuery.newQuery().inWorld(stringArray[0]));
                    break;
                }
                PlotSquared.get().getImpromptuUUIDPipeline().getSingle(stringArray[0], (uUID, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    } else if (throwable != null && uUID == null) {
                        try {
                            uUID = UUID.fromString(stringArray[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uUID == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
                    } else if (!plotPlayer.hasPermission(Permission.PERMISSION_LIST_PLAYER)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.list.player"))));
                    } else {
                        blArray[0] = false;
                        consumer.accept(PlotQuery.newQuery().ownersInclude((UUID)uUID).whereBasePlot().withSortingStrategy(SortingStrategy.SORT_BY_TEMP));
                    }
                });
            }
        }
        return true;
    }

    public void displayPlots(final PlotPlayer<?> plotPlayer, List<Plot> list, int n, int n2, String[] stringArray) {
        list.removeIf(plot -> !plot.isBasePlot());
        this.paginate(plotPlayer, list, n, n2, new RunnableVal3<Integer, Plot, CaptionHolder>(){

            @Override
            public void run(Integer n, Plot plot, CaptionHolder captionHolder) {
                TranslatableCaption translatableCaption = plot.getOwner() == null ? TranslatableCaption.of("info.plot_list_no_owner") : (plot.isOwner(plotPlayer.getUUID()) || plot.getOwner().equals(DBFunc.EVERYONE) ? TranslatableCaption.of("info.plot_list_owned_by") : (plot.isAdded(plotPlayer.getUUID()) ? TranslatableCaption.of("info.plot_list_added_to") : (plot.isDenied(plotPlayer.getUUID()) ? TranslatableCaption.of("info.plot_list_denied_on") : TranslatableCaption.of("info.plot_list_default"))));
                Component component = Command.MINI_MESSAGE.deserialize(TranslatableCaption.of("info.plot_info_trusted").getComponent(plotPlayer), (TagResolver)TagResolver.resolver("trusted", Tag.inserting(PlayerManager.getPlayerList(plot.getTrusted(), plotPlayer))));
                Component component2 = Command.MINI_MESSAGE.deserialize(TranslatableCaption.of("info.plot_info_members").getComponent(plotPlayer), (TagResolver)TagResolver.resolver("members", Tag.inserting(PlayerManager.getPlayerList(plot.getMembers(), plotPlayer))));
                TagResolver.Builder builder = TagResolver.builder();
                builder.tag("command_tp", Tag.preProcessParsed("/plot visit " + plot.getArea() + ";" + plot.getId()));
                builder.tag("command_info", Tag.preProcessParsed("/plot info " + plot.getArea() + ";" + plot.getId()));
                builder.tag("hover_info", Tag.inserting(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(component)).append((Component)Component.newline())).append(component2)).asComponent()));
                builder.tag("number", Tag.inserting(Component.text(n)));
                builder.tag("plot", Tag.inserting(Command.MINI_MESSAGE.deserialize(translatableCaption.getComponent(plotPlayer), (TagResolver)TagResolver.resolver("plot", Tag.inserting(Component.text(plot.toString()))))));
                String string = "";
                String string2 = TranslatableCaption.of("info.plot_list_player_online").getComponent(plotPlayer);
                String string3 = TranslatableCaption.of("info.plot_list_player_offline").getComponent(plotPlayer);
                String string4 = TranslatableCaption.of("info.plot_list_player_unknown").getComponent(plotPlayer);
                String string5 = TranslatableCaption.of("info.plot_list_player_server").getComponent(plotPlayer);
                String string6 = TranslatableCaption.of("info.plot_list_player_everyone").getComponent(plotPlayer);
                TextComponent.Builder builder2 = Component.text();
                if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
                    TagResolver.Single single = TagResolver.resolver("info.server", Tag.inserting(TranslatableCaption.of("info.server").toComponent(plotPlayer)));
                    builder2.append(Command.MINI_MESSAGE.deserialize(string5, (TagResolver)single));
                } else {
                    try {
                        List<UUIDMapping> list = PlotSquared.get().getImpromptuUUIDPipeline().getNames(plot.getOwners()).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS);
                        for (UUIDMapping uUIDMapping : list) {
                            PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists(uUIDMapping.uuid());
                            TagResolver tagResolver = TagResolver.builder().tag("prefix", Tag.inserting(Component.text(string))).tag("player", Tag.inserting(Component.text(uUIDMapping.username()))).build();
                            if (plotPlayer2 != null) {
                                builder2.append(Command.MINI_MESSAGE.deserialize(string2, tagResolver));
                            } else if (uUIDMapping.username().equalsIgnoreCase("unknown")) {
                                var20_26 = TagResolver.resolver("info.unknown", Tag.inserting(TranslatableCaption.of("info.unknown").toComponent(plotPlayer)));
                                builder2.append(Command.MINI_MESSAGE.deserialize(string4, (TagResolver)var20_26));
                            } else if (uUIDMapping.uuid().equals(DBFunc.EVERYONE)) {
                                var20_26 = TagResolver.resolver("info.everyone", Tag.inserting(TranslatableCaption.of("info.everyone").toComponent(plotPlayer)));
                                builder2.append(Command.MINI_MESSAGE.deserialize(string6, (TagResolver)var20_26));
                            } else {
                                builder2.append(Command.MINI_MESSAGE.deserialize(string3, tagResolver));
                            }
                            string = ", ";
                        }
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Iterator<UUID> iterator = plot.getOwners().iterator();
                        while (iterator.hasNext()) {
                            UUID uUID = iterator.next();
                            stringBuilder.append(uUID);
                            if (!iterator.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringBuilder.toString()))));
                    }
                    catch (TimeoutException timeoutException) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                    }
                }
                builder.tag("players", Tag.inserting(builder2.asComponent()));
                builder.tag("size", Tag.inserting(Component.text(plot.getConnectedPlots().size())));
                captionHolder.set(TranslatableCaption.of("info.plot_list_item"));
                captionHolder.setTagResolvers(builder.build());
            }
        }, "/plot list " + stringArray[0], TranslatableCaption.of("list.plot_list_header_paged"));
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.econHandler.isSupported() && plotPlayer.hasPermission(Permission.PERMISSION_LIST_FOR_SALE)) {
            linkedList.add("forsale");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_MINE)) {
            linkedList.add("mine");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_SHARED)) {
            linkedList.add("shared");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_WORLD)) {
            linkedList.addAll(PlotSquared.platform().worldManager().getWorlds());
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_TOP)) {
            linkedList.add("top");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_ALL)) {
            linkedList.add("all");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_UNOWNED)) {
            linkedList.add("unowned");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_DONE)) {
            linkedList.add("done");
        }
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_EXPIRED)) {
            linkedList.add("expired");
        }
        List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.TELEPORT){}).collect(Collectors.toCollection(LinkedList::new));
        if (plotPlayer.hasPermission(Permission.PERMISSION_LIST_PLAYER) && stringArray[0].length() > 0) {
            list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
        }
        return list;
    }
}

