/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(usage="/plot move <X;Z>", command="move", permission="plots.move", category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER)
public class Move
extends SubCommand {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public Move(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        Plot plot;
        Location location = plotPlayer.getLocation();
        Plot plot2 = location.getPlotAbs();
        if (plot2 == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!plot2.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        boolean bl2 = false;
        if (stringArray.length == 2 && stringArray[1].equalsIgnoreCase("-f")) {
            stringArray = new String[]{stringArray[0]};
            bl2 = true;
        }
        if (stringArray.length != 1) {
            this.sendUsage(plotPlayer);
            return CompletableFuture.completedFuture(false);
        }
        PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[0]);
        if (plotArea == null) {
            plot = Plot.getPlotFromString(plotPlayer, stringArray[0], true);
            if (plot == null) {
                return CompletableFuture.completedFuture(false);
            }
        } else {
            plot = plotArea.getPlotAbs(plot2.getId());
        }
        if (plot2.equals(plot)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.origin_cant_be_target"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!(plot2.getArea().isCompatible(plot.getArea()) || bl2 && plotPlayer.hasPermission(Permission.PERMISSION_ADMIN))) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.plotworld_incompatible"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (plot2.isMerged() || plot.isMerged()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("move.move_merged"), new TagResolver[0]);
            return CompletableFuture.completedFuture(false);
        }
        String string = plot2.toString();
        String string2 = plot.toString();
        return plot2.getPlotModificationManager().move(plot, plotPlayer, () -> {}, false).thenApply(bl -> {
            if (bl.booleanValue()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("move.move_success"), TagResolver.builder().tag("origin", Tag.inserting(Component.text(string))).tag("target", Tag.inserting(Component.text(string2))).build());
                return true;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("move.requires_unowned"), new TagResolver[0]);
            return false;
        });
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        return true;
    }
}

