/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotChangeOwnerEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@CommandDeclaration(command="setowner", permission="plots.admin.command.setowner", usage="/plot setowner <player>", aliases={"owner", "so", "seto"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.NONE, confirmation=true)
public class Owner
extends SetCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Owner(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean set(PlotPlayer<?> plotPlayer, Plot plot, String string) {
        if (string == null || string.isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot setowner <owner>"))));
            return false;
        }
        @Nullable UUID uUID3 = plot.getOwnerAbs();
        Set<Plot> set = plot.getConnectedPlots();
        Consumer<UUID> consumer = uUID2 -> {
            boolean bl;
            if (!(uUID2 != null || string.equalsIgnoreCase("none") || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("-"))) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                return;
            }
            PlotChangeOwnerEvent plotChangeOwnerEvent = this.eventDispatcher.callOwnerChange(plotPlayer, plot, plot.hasOwner() ? plot.getOwnerAbs() : null, (UUID)uUID2, plot.hasOwner());
            if (plotChangeOwnerEvent.getEventResult() == Result.DENY) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Owner change"))));
                return;
            }
            uUID2 = plotChangeOwnerEvent.getNewOwner();
            boolean bl2 = bl = plotChangeOwnerEvent.getEventResult() == Result.FORCE;
            if (uUID2 == null) {
                if (!bl && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_SET_OWNER, true)) {
                    return;
                }
                PlotUnlinkEvent plotUnlinkEvent = this.eventDispatcher.callUnlink(plot.getArea(), plot, false, false, PlotUnlinkEvent.REASON.NEW_OWNER);
                if (plotUnlinkEvent.getEventResult() == Result.DENY) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Unlink on owner change"))));
                    return;
                }
                if (plot.getPlotModificationManager().unlinkPlot(plotUnlinkEvent.isCreateRoad(), plotUnlinkEvent.isCreateRoad())) {
                    this.eventDispatcher.callPostUnlink(plot, PlotUnlinkEvent.REASON.NEW_OWNER);
                }
                Set<Plot> set2 = plot.getConnectedPlots();
                for (Plot plot2 : set2) {
                    plot2.unclaim();
                    plot2.getPlotModificationManager().removeSign();
                }
                this.eventDispatcher.callPostOwnerChange(plotPlayer, plot, uUID3);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("owner.set_owner"), new TagResolver[0]);
                return;
            }
            PlotPlayer<?> plotPlayer2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)uUID2);
            if (plot.isOwner((UUID)uUID2)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("member.already_owner"), (CompletableFuture<TagResolver>)PlotSquared.platform().playerManager().getUsernameCaption((UUID)uUID2).thenApply(caption -> TagResolver.resolver("player", Tag.inserting(caption.toComponent(plotPlayer)))));
                return;
            }
            if (!bl && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_SET_OWNER)) {
                if (plotPlayer2 == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player_offline"), (CompletableFuture<TagResolver>)PlotSquared.platform().playerManager().getUsernameCaption((UUID)uUID2).thenApply(caption -> TagResolver.resolver("player", Tag.inserting(caption.toComponent(plotPlayer)))));
                    return;
                }
                int n = set.size();
                int n2 = (Settings.Limit.GLOBAL ? plotPlayer2.getPlotCount() : plotPlayer2.getPlotCount(plot.getWorldName())) + n;
                try (MetaDataAccess<Integer> metaDataAccess = plotPlayer.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                    int n3;
                    if (n2 >= plotPlayer2.getAllowedPlots() && metaDataAccess.isPresent() && (n3 = metaDataAccess.get().orElse(0).intValue()) <= 0) {
                        metaDataAccess.remove();
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.cant_transfer_more_plots"), new TagResolver[0]);
                        return;
                    }
                }
            }
            UUID uUID3 = uUID2;
            PlotSquared.get().getImpromptuUUIDPipeline().getSingle((UUID)uUID2, (string2, throwable) -> {
                boolean bl = plot.isDenied(uUID3);
                Runnable runnable = () -> {
                    if (plot.setOwner(uUID3, plotPlayer)) {
                        if (bl) {
                            plot.removeDenied(uUID3);
                        }
                        plot.getPlotModificationManager().setSign((String)string2);
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("owner.set_owner"), new TagResolver[0]);
                        this.eventDispatcher.callPostOwnerChange(plotPlayer, plot, uUID3);
                        if (plotPlayer2 != null) {
                            plotPlayer2.sendMessage((Caption)TranslatableCaption.of("owner.now_owner"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getArea() + ";" + plot.getId()))));
                        }
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("owner.set_owner_cancelled"), new TagResolver[0]);
                    }
                };
                if (this.hasConfirmation(plotPlayer)) {
                    CmdConfirm.addPending(plotPlayer, "/plot setowner " + string, runnable);
                } else {
                    TaskManager.runTask(runnable);
                }
            });
        };
        if (string.length() == 36) {
            try {
                consumer.accept(UUID.fromString(string));
            }
            catch (Exception exception) {}
        } else {
            PlotSquared.get().getImpromptuUUIDPipeline().getSingle(string, (uUID, throwable) -> consumer.accept((UUID)uUID));
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

