/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotRateEvent;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.InventoryUtil;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="rate", permission="plots.rate", usage="/plot rate [# | next | purge]", aliases={"rt"}, category=CommandCategory.INFO, requiredType=RequiredType.PLAYER)
public class Rate
extends SubCommand {
    private final EventDispatcher eventDispatcher;
    private final InventoryUtil inventoryUtil;

    @Inject
    public Rate(@NonNull EventDispatcher eventDispatcher, @NonNull InventoryUtil inventoryUtil) {
        this.eventDispatcher = eventDispatcher;
        this.inventoryUtil = inventoryUtil;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n;
        Object object;
        if (stringArray.length == 1) {
            switch (stringArray[0].toLowerCase()) {
                case "next": {
                    List<Plot> list = PlotQuery.newQuery().whereBasePlot().asList();
                    list.sort((plot, plot2) -> {
                        double d = 0.0;
                        if (!plot.getRatings().isEmpty()) {
                            for (Map.Entry<UUID, Rating> entry : plot.getRatings().entrySet()) {
                                d -= 11.0 - entry.getValue().getAverageRating();
                            }
                        }
                        double d2 = 0.0;
                        if (!plot2.getRatings().isEmpty()) {
                            for (Map.Entry<UUID, Rating> entry : plot2.getRatings().entrySet()) {
                                d2 -= 11.0 - entry.getValue().getAverageRating();
                            }
                        }
                        if (d == d2) {
                            return 0;
                        }
                        return d2 > d ? 1 : -1;
                    });
                    UUID uUID = plotPlayer.getUUID();
                    for (Plot plot3 : list) {
                        if (Settings.Done.REQUIRED_FOR_RATINGS && !DoneFlag.isDone(plot3) || !plot3.isBasePlot() || plot3.getRatings().containsKey(uUID) || plot3.isAdded(uUID)) continue;
                        plot3.teleportPlayer(plotPlayer, TeleportCause.COMMAND_RATE, bl -> {});
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("tutorial.rate_this"), new TagResolver[0]);
                        return true;
                    }
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
                    return false;
                }
                case "purge": {
                    Plot plot4 = plotPlayer.getCurrentPlot();
                    if (plot4 == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                        return false;
                    }
                    if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS, true)) {
                        return false;
                    }
                    plot4.clearRatings();
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.ratings_purged"), new TagResolver[0]);
                    return true;
                }
            }
        }
        if ((object = plotPlayer.getCurrentPlot()) == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        if (!((Plot)object).hasOwner()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_owned"), new TagResolver[0]);
            return false;
        }
        if (((Plot)object).isOwner(plotPlayer.getUUID())) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_your_own"), new TagResolver[0]);
            return false;
        }
        if (Settings.Done.REQUIRED_FOR_RATINGS && !DoneFlag.isDone((Plot)object)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_done"), new TagResolver[0]);
            return false;
        }
        if (Settings.Ratings.CATEGORIES != null && !Settings.Ratings.CATEGORIES.isEmpty()) {
            Runnable runnable = new Runnable(){
                final /* synthetic */ Plot val$plot;
                final /* synthetic */ PlotPlayer val$player;
                {
                    this.val$plot = plot;
                    this.val$player = plotPlayer;
                }

                @Override
                public void run() {
                    if (this.val$plot.getRatings().containsKey(this.val$player.getUUID())) {
                        this.val$player.sendMessage((Caption)TranslatableCaption.of("ratings.rating_already_exists"), TagResolver.resolver("plot", Tag.inserting(Component.text(this.val$plot.getId().toString()))));
                        return;
                    }
                    final MutableInt mutableInt = new MutableInt(0);
                    final MutableInt mutableInt2 = new MutableInt(0);
                    String string = Settings.Ratings.CATEGORIES.get(0);
                    PlotInventory plotInventory = new PlotInventory(Rate.this.inventoryUtil, this.val$player, 1, string){

                        @Override
                        public boolean onClick(int n) {
                            mutableInt2.add((double)(n + 1) * Math.pow(10.0, mutableInt.getValue()));
                            mutableInt.increment();
                            if (mutableInt.getValue() >= Settings.Ratings.CATEGORIES.size()) {
                                int n2 = mutableInt2.getValue();
                                PlotRateEvent plotRateEvent = Rate.this.eventDispatcher.callRating(this.getPlayer(), val$plot, new Rating(n2));
                                if (plotRateEvent.getRating() != null) {
                                    val$plot.addRating(this.getPlayer().getUUID(), plotRateEvent.getRating());
                                    this.getPlayer().sendMessage((Caption)TranslatableCaption.of("ratings.rating_applied"), TagResolver.resolver("plot", Tag.inserting(Component.text(val$plot.getId().toString()))));
                                }
                                return false;
                            }
                            this.setTitle(Settings.Ratings.CATEGORIES.get(mutableInt.getValue()));
                            return true;
                        }
                    };
                    plotInventory.setItem(0, new PlotItemStack(Settings.Ratings.BLOCK_0, 1, TranslatableCaption.of("ratings.0-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(1, new PlotItemStack(Settings.Ratings.BLOCK_1, 1, TranslatableCaption.of("ratings.1-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(2, new PlotItemStack(Settings.Ratings.BLOCK_2, 2, TranslatableCaption.of("ratings.2-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(3, new PlotItemStack(Settings.Ratings.BLOCK_3, 3, TranslatableCaption.of("ratings.3-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(4, new PlotItemStack(Settings.Ratings.BLOCK_4, 4, TranslatableCaption.of("ratings.4-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(5, new PlotItemStack(Settings.Ratings.BLOCK_5, 5, TranslatableCaption.of("ratings.5-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(6, new PlotItemStack(Settings.Ratings.BLOCK_6, 6, TranslatableCaption.of("ratings.6-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(7, new PlotItemStack(Settings.Ratings.BLOCK_7, 7, TranslatableCaption.of("ratings.7-8").getComponent(this.val$player), new String[0]));
                    plotInventory.setItem(8, new PlotItemStack(Settings.Ratings.BLOCK_8, 8, TranslatableCaption.of("ratings.8-8").getComponent(this.val$player), new String[0]));
                    plotInventory.openInventory();
                }
            };
            if (((Plot)object).getSettings().getRatings() == null) {
                if (!Settings.Enabled_Components.RATING_CACHE) {
                    TaskManager.runTaskAsync(() -> Rate.lambda$onCommand$2((Plot)object, runnable));
                    return true;
                }
                ((Plot)object).getSettings().setRatings(new HashMap<UUID, Integer>());
            }
            runnable.run();
            return true;
        }
        if (stringArray.length < 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_valid"), new TagResolver[0]);
            return true;
        }
        String string = stringArray[0];
        if (MathMan.isInteger(string) && string.length() < 3 && !string.isEmpty()) {
            n = Integer.parseInt(string);
            if (n > 10 || n < 1) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_valid"), new TagResolver[0]);
                return false;
            }
        } else {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_not_valid"), new TagResolver[0]);
            return false;
        }
        UUID uUID = plotPlayer.getUUID();
        Runnable runnable = () -> this.lambda$onCommand$3((Plot)object, uUID, plotPlayer, n);
        if (((Plot)object).getSettings().getRatings() == null) {
            if (!Settings.Enabled_Components.RATING_CACHE) {
                TaskManager.runTaskAsync(() -> Rate.lambda$onCommand$4((Plot)object, runnable));
                return true;
            }
            ((Plot)object).getSettings().setRatings(new HashMap<UUID, Integer>());
        }
        runnable.run();
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_RATE)) {
                linkedList.add("1 - 10");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS)) {
                linkedList.add("purge");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.PLAYER, CommandCategory.INFO){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_RATE) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }

    private static /* synthetic */ void lambda$onCommand$4(Plot plot, Runnable runnable) {
        plot.getSettings().setRatings(DBFunc.getRatings(plot));
        runnable.run();
    }

    private /* synthetic */ void lambda$onCommand$3(Plot plot, UUID uUID, PlotPlayer plotPlayer, int n) {
        if (plot.getRatings().containsKey(uUID)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_already_exists"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
            return;
        }
        PlotRateEvent plotRateEvent = this.eventDispatcher.callRating(plotPlayer, plot, new Rating(n));
        if (plotRateEvent.getRating() != null) {
            plot.addRating(uUID, plotRateEvent.getRating());
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("ratings.rating_applied"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
        }
    }

    private static /* synthetic */ void lambda$onCommand$2(Plot plot, Runnable runnable) {
        plot.getSettings().setRatings(DBFunc.getRatings(plot));
        runnable.run();
    }

    private static class MutableInt {
        private int value;

        MutableInt(int n) {
            this.value = n;
        }

        void increment() {
            ++this.value;
        }

        void decrement() {
            --this.value;
        }

        int getValue() {
            return this.value;
        }

        void add(Number number) {
            this.value += number.intValue();
        }
    }
}

