/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="regenallroads", aliases={"rgar"}, usage="/plot regenallroads <world> [height]", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE, permission="plots.regenallroads")
public class RegenAllRoads
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final HybridUtils hybridUtils;

    @Inject
    public RegenAllRoads(@NonNull PlotAreaManager plotAreaManager, @NonNull HybridUtils hybridUtils) {
        this.plotAreaManager = plotAreaManager;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        int n = 0;
        if (stringArray.length == 2) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_number"), TagResolver.resolver("value", Tag.inserting(Component.text("(0, 256)"))));
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot regenallroads <world> [height]"))));
                return false;
            }
        } else if (stringArray.length != 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot regenallroads <world> [height]"))));
            return false;
        }
        PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[0]);
        if (plotArea == null) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[0]))));
            return false;
        }
        PlotManager plotManager = plotArea.getPlotManager();
        if (!(plotManager instanceof HybridPlotManager)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_plot_world"), new TagResolver[0]);
            return false;
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugroadregen.schematic"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot createroadschematic"))));
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugroadregen.regenallroads_started"), new TagResolver[0]);
        boolean bl = this.hybridUtils.scheduleRoadUpdate(plotArea, n);
        if (!bl) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new TagResolver[0]);
            return false;
        }
        return true;
    }
}

