/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.google.Inject;
import java.io.File;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="reload", aliases={"rl"}, permission="plots.admin.command.reload", usage="/plot reload", category=CommandCategory.ADMINISTRATION)
public class Reload
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private YamlConfiguration worldConfiguration;
    private File worldFile;

    @Inject
    public Reload(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @WorldFile @NonNull File file) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = yamlConfiguration;
        this.worldFile = file;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        try {
            PlotSquared.get().setupConfigs();
            this.worldConfiguration = PlotSquared.get().getWorldConfiguration();
            this.worldFile = PlotSquared.get().getWorldsFile();
            PlotSquared.get().loadCaptionMap();
            this.plotAreaManager.forEachPlotArea(plotArea -> {
                ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection("worlds." + plotArea.getWorldName());
                if (configurationSection == null) {
                    return;
                }
                if (plotArea.getType() != PlotAreaType.PARTIAL || !configurationSection.contains("areas")) {
                    plotArea.saveConfiguration(configurationSection);
                    plotArea.loadDefaultConfiguration(configurationSection);
                } else {
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("areas." + plotArea.getId() + "-" + plotArea.getMin() + "-" + plotArea.getMax());
                    YamlConfiguration yamlConfiguration = new YamlConfiguration();
                    for (String string : configurationSection2.getKeys(true)) {
                        if (configurationSection2.get(string) instanceof MemorySection || yamlConfiguration.contains(string)) continue;
                        yamlConfiguration.set(string, configurationSection2.get(string));
                    }
                    for (String string : configurationSection.getKeys(true)) {
                        if (configurationSection.get(string) instanceof MemorySection || string.startsWith("areas") || yamlConfiguration.contains(string)) continue;
                        yamlConfiguration.set(string, configurationSection.get(string));
                    }
                    plotArea.saveConfiguration(yamlConfiguration);
                    for (String string : yamlConfiguration.getKeys(true)) {
                        if (yamlConfiguration.get(string) instanceof MemorySection) continue;
                        if (!configurationSection.contains(string)) {
                            configurationSection.set(string, yamlConfiguration.get(string));
                            continue;
                        }
                        Object object = configurationSection.get(string);
                        if (!Objects.equals(object, yamlConfiguration.get(string))) continue;
                        configurationSection2.set(string, yamlConfiguration.get(string));
                    }
                    plotArea.loadDefaultConfiguration(yamlConfiguration);
                }
            });
            this.worldConfiguration.save(this.worldFile);
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("reload.reloaded_configs"), new TagResolver[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("reload.reload_failed"), new TagResolver[0]);
        }
        return true;
    }
}

