/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.common.collect.Lists;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="schematic", permission="plots.schematic", aliases={"schem"}, category=CommandCategory.SCHEMATIC, usage="/plot schematic <save | saveall | paste | list>")
public class SchematicCmd
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final SchematicHandler schematicHandler;
    private boolean running = false;

    @Inject
    public SchematicCmd(@NonNull PlotAreaManager plotAreaManager, @NonNull SchematicHandler schematicHandler) {
        this.plotAreaManager = plotAreaManager;
        this.schematicHandler = schematicHandler;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> plotPlayer, String[] stringArray) {
        String string;
        if (stringArray.length < 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Possible values: save, paste, exportall, list"))));
            return true;
        }
        switch (string = stringArray[0].toLowerCase()) {
            case "paste": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC_PASTE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_SCHEMATIC_PASTE)));
                    return false;
                }
                if (stringArray.length < 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Possible values: save, paste, exportall, list"))));
                    break;
                }
                Location location = plotPlayer.getLocation();
                Plot plot = location.getPlotAbs();
                if (plot == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                    return false;
                }
                if (!plot.hasOwner()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
                    return false;
                }
                if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission("plots.admin.command.schematic.paste")) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                    return false;
                }
                if (plot.getVolume() > 2.147483647E9) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
                    return false;
                }
                if (this.running) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                String string2 = stringArray[1];
                this.running = true;
                TaskManager.runTaskAsync(() -> {
                    Schematic schematic = null;
                    if (string2.startsWith("url:")) {
                        try {
                            UUID uUID = UUID.fromString(string2.substring(4));
                            URL uRL = URI.create(Settings.Web.URL + "uploads/" + uUID + ".schematic").toURL();
                            schematic = this.schematicHandler.getSchematic(uRL);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid"), TagResolver.resolver("reason", Tag.inserting(Component.text("non-existent url: " + string2))));
                            this.running = false;
                            return;
                        }
                    }
                    try {
                        schematic = this.schematicHandler.getSchematic(string2);
                    }
                    catch (SchematicHandler.UnsupportedFormatException unsupportedFormatException) {
                        unsupportedFormatException.printStackTrace();
                    }
                    if (schematic == null) {
                        this.running = false;
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_invalid"), TagResolver.resolver("reason", Tag.inserting(Component.text("non-existent or not in gzip format"))));
                        return;
                    }
                    this.schematicHandler.paste(schematic, plot, 0, plot.getArea().getMinBuildHeight(), 0, false, plotPlayer, new RunnableVal<Boolean>(){

                        @Override
                        public void run(Boolean bl) {
                            SchematicCmd.this.running = false;
                            if (bl.booleanValue()) {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_success"), new TagResolver[0]);
                            } else {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_failed"), new TagResolver[0]);
                            }
                        }
                    });
                });
                break;
            }
            case "saveall": 
            case "exportall": {
                if (!(plotPlayer instanceof ConsolePlayer)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("console.not_console"), new TagResolver[0]);
                    return false;
                }
                if (stringArray.length != 2) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_world_args"), new TagResolver[0]);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Use /plot schematic exportall <area>"))));
                    return false;
                }
                PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[1]);
                if (plotArea == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    return false;
                }
                Collection<Plot> collection = plotArea.getPlots();
                if (collection.isEmpty()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematic.schematic_exportall_world"), new TagResolver[0]);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Use /plot sch exportall <area>"))));
                    return false;
                }
                boolean bl = this.schematicHandler.exportAll(collection, null, null, () -> plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_finished"), new TagResolver[0]));
                if (!bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_started"), new TagResolver[0]);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.plot_to_schem"), TagResolver.resolver("amount", Tag.inserting(Component.text(collection.size()))));
                break;
            }
            case "export": 
            case "save": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC_SAVE)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_SCHEMATIC_SAVE)));
                    return false;
                }
                if (this.running) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                Location location = plotPlayer.getLocation();
                Plot plot = location.getPlotAbs();
                if (plot == null) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
                    return false;
                }
                if (!plot.hasOwner()) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("info.plot_unowned"), new TagResolver[0]);
                    return false;
                }
                if (plot.getVolume() > 2.147483647E9) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
                    return false;
                }
                if (!plot.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission("plots.admin.command.schematic.save")) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
                    return false;
                }
                ArrayList arrayList = Lists.newArrayList((Object[])new Plot[]{plot});
                boolean bl = this.schematicHandler.exportAll(arrayList, null, null, () -> {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_single_finished"), new TagResolver[0]);
                    this.running = false;
                });
                if (!bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("error.task_in_process"), new TagResolver[0]);
                    return false;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_exportall_started"), new TagResolver[0]);
                break;
            }
            case "list": {
                if (!plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC_LIST)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_SCHEMATIC_LIST)));
                    return false;
                }
                String string3 = StringMan.join(this.schematicHandler.getSchematicNames(), "$2, $1");
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_list"), TagResolver.resolver("list", Tag.inserting(Component.text(string3))));
                break;
            }
            default: {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Possible values: save, paste, exportall, list"))));
            }
        }
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC_SAVE)) {
                linkedList.add("save");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC_LIST)) {
                linkedList.add("list");
            }
            if (plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC_PASTE)) {
                linkedList.add("paste");
            }
            List list = linkedList.stream().filter(string -> string.toLowerCase().startsWith(stringArray[0].toLowerCase())).map(string -> new Command(null, true, (String)string, "", RequiredType.NONE, CommandCategory.ADMINISTRATION){}).collect(Collectors.toCollection(LinkedList::new));
            if (plotPlayer.hasPermission(Permission.PERMISSION_SCHEMATIC) && stringArray[0].length() > 0) {
                list.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
            }
            return list;
        }
        return TabCompletions.completePlayers(plotPlayer, String.join((CharSequence)",", stringArray).trim(), Collections.emptyList());
    }
}

