/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.setup.SetupProcess;
import com.plotsquared.core.setup.SetupStep;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="setup", permission="plots.admin.command.setup", usage="/plot setup", aliases={"create"}, category=CommandCategory.ADMINISTRATION)
public class Setup
extends SubCommand {
    private final SetupUtils setupUtils;

    @Inject
    public Setup(@NonNull SetupUtils setupUtils) {
        this.setupUtils = setupUtils;
    }

    public void displayGenerators(PlotPlayer<?> plotPlayer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TranslatableCaption.of("setup.choose_generator").getComponent(plotPlayer));
        for (Map.Entry<String, GeneratorWrapper<?>> entry : SetupUtils.generators.entrySet()) {
            if (entry.getKey().equals(PlotSquared.platform().pluginName())) {
                stringBuilder.append("\n<dark_gray> - </dark_gray><dark_green>").append(entry.getKey()).append(" (Default Generator)</dark_green>");
                continue;
            }
            if (entry.getValue().isFull()) {
                stringBuilder.append("\n<dark_gray> - </dark_gray><gray>").append(entry.getKey()).append(" (Plot Generator)</gray>");
                continue;
            }
            stringBuilder.append("\n<dark_gray> - </dark_gray><gray>").append(entry.getKey()).append(" (Unknown structure)</gray>");
        }
        plotPlayer.sendMessage((Caption)StaticCaption.of(stringBuilder.toString()), new TagResolver[0]);
    }

    @Override
    public boolean onCommand(PlotPlayer<?> plotPlayer, String[] stringArray) {
        try (MetaDataAccess<SetupProcess> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SETUP);){
            SetupProcess setupProcess = metaDataAccess.get().orElse(null);
            if (setupProcess == null) {
                if (stringArray.length > 0) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_not_started"), new TagResolver[0]);
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("Use /plot setup to start a setup process."))));
                    boolean bl = true;
                    return bl;
                }
                setupProcess = new SetupProcess();
                metaDataAccess.set(setupProcess);
                this.setupUtils.updateGenerators(false);
                SetupStep setupStep = setupProcess.getCurrentStep();
                setupStep.announce(plotPlayer);
                this.displayGenerators(plotPlayer);
                boolean bl = true;
                return bl;
            }
            if (stringArray.length == 1) {
                if ("back".equalsIgnoreCase(stringArray[0])) {
                    setupProcess.back();
                    setupProcess.getCurrentStep().announce(plotPlayer);
                } else if ("cancel".equalsIgnoreCase(stringArray[0])) {
                    metaDataAccess.remove();
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_cancelled"), new TagResolver[0]);
                } else {
                    setupProcess.handleInput(plotPlayer, stringArray[0]);
                    if (setupProcess.getCurrentStep() != null) {
                        setupProcess.getCurrentStep().announce(plotPlayer);
                    }
                }
            } else {
                setupProcess.getCurrentStep().announce(plotPlayer);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        SetupProcess setupProcess;
        try (Object object = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SETUP);){
            setupProcess = ((MetaDataAccess)object).get().orElse(null);
        }
        if (setupProcess == null) {
            return Collections.emptyList();
        }
        if (stringArray.length > 1 || stringArray.length == 1 && bl) {
            return Collections.emptyList();
        }
        object = setupProcess.getCurrentStep();
        ArrayList<Command> arrayList = new ArrayList<Command>(object.createSuggestions(plotPlayer, bl ? "" : stringArray[0]));
        this.tryAddSubCommand("back", stringArray[0], arrayList);
        this.tryAddSubCommand("cancel", stringArray[0], arrayList);
        return arrayList;
    }

    private void tryAddSubCommand(String string, String string2, List<Command> list) {
        if (!string2.isEmpty() && string.startsWith(string2)) {
            list.add(new Command(null, false, string, "", RequiredType.NONE, null){});
        }
    }
}

