/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.UntrustedVisitFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.query.SortingStrategy;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.google.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="visit", permission="plots.visit", usage="/plot visit <player> | <alias> | <plot> [area]|[#] [#]", aliases={"v", "tp", "teleport", "goto", "warp"}, requiredType=RequiredType.PLAYER, category=CommandCategory.TELEPORT)
public class Visit
extends Command {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public Visit(@NonNull PlotAreaManager plotAreaManager) {
        super(MainCommand.getInstance(), true);
        this.plotAreaManager = plotAreaManager;
    }

    private void visit(@NonNull PlotPlayer<?> plotPlayer, @NonNull PlotQuery plotQuery, PlotArea plotArea, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2, int n) {
        List<Plot> list = plotQuery.asList();
        if (list.size() > 1) {
            plotQuery.whereBasePlot();
        }
        if (n == Integer.MIN_VALUE) {
            n = 1;
        }
        PlotArea plotArea2 = plotArea;
        if (Settings.Teleport.PER_WORLD_VISIT && plotArea == null) {
            plotArea2 = plotPlayer.getApplicablePlotArea();
        }
        if (plotArea2 != null) {
            plotQuery.relativeToArea(plotArea2).withSortingStrategy(SortingStrategy.SORT_BY_CREATION);
        } else {
            plotQuery.withSortingStrategy(SortingStrategy.SORT_BY_TEMP);
        }
        List<Plot> list2 = plotQuery.asList();
        if (list2.isEmpty()) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.found_no_plots"), new TagResolver[0]);
            return;
        }
        if (list2.size() < n || n < 1) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.number_not_in_range"), TagResolver.builder().tag("min", Tag.inserting(Component.text(1))).tag("max", Tag.inserting(Component.text(list2.size()))).build());
            return;
        }
        Plot plot = list2.get(n - 1);
        if (!plot.hasOwner()) {
            if (!plotPlayer.hasPermission(Permission.PERMISSION_VISIT_UNOWNED)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.visit.unowned"))));
                return;
            }
        } else if (plot.isOwner(plotPlayer.getUUID())) {
            if (!plotPlayer.hasPermission(Permission.PERMISSION_VISIT_OWNED) && !plotPlayer.hasPermission(Permission.PERMISSION_HOME)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.visit.owned"))));
                return;
            }
        } else if (plot.isAdded(plotPlayer.getUUID())) {
            if (!plotPlayer.hasPermission(Permission.PERMISSION_SHARED)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.visit.shared"))));
                return;
            }
        } else {
            if (!(((Boolean)plot.getFlag(UntrustedVisitFlag.class)).booleanValue() || plotPlayer.hasPermission(Permission.PERMISSION_VISIT_OTHER) || plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_VISIT_UNTRUSTED))) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Component.text("plots.visit.other"))));
                return;
            }
            if (plot.isDenied(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_VISIT_DENIED)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("permission.no_permission"), TagResolver.resolver("node", Tag.inserting(Permission.PERMISSION_VISIT_DENIED)));
                return;
            }
        }
        runnableVal3.run(this, () -> plot.teleportPlayer(plotPlayer, TeleportCause.COMMAND_VISIT, bl -> {
            if (bl.booleanValue()) {
                runnableVal2.run(this, Command.CommandResult.SUCCESS);
            } else {
                runnableVal2.run(this, Command.CommandResult.FAILURE);
            }
        }), () -> runnableVal2.run(this, Command.CommandResult.FAILURE));
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> plotPlayer, String[] stringArray, RunnableVal3<Command, Runnable, Runnable> runnableVal3, RunnableVal2<Command, Command.CommandResult> runnableVal2) {
        if (stringArray.length > 3) {
            this.sendUsage(plotPlayer);
            return CompletableFuture.completedFuture(false);
        }
        if (stringArray.length == 1 && stringArray[0].contains(":")) {
            stringArray = stringArray[0].split(":");
        }
        int n = Integer.MIN_VALUE;
        switch (stringArray.length) {
            case 3: {
                if (!MathMan.isInteger(stringArray[2])) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_number"), TagResolver.resolver("value", Tag.inserting(Component.text("(1, \u221e)"))));
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
                    return CompletableFuture.completedFuture(false);
                }
                n = Integer.parseInt(stringArray[2]);
            }
            case 2: {
                if (n != Integer.MIN_VALUE || !MathMan.isInteger(stringArray[1])) {
                    PlotArea plotArea = this.plotAreaManager.getPlotAreaByString(stringArray[1]);
                    if (plotArea == null) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_number"), TagResolver.resolver("value", Tag.inserting(Component.text("(1, \u221e)"))));
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
                        return CompletableFuture.completedFuture(false);
                    }
                    PlotArea plotArea2 = plotArea;
                    int n2 = n;
                    PlayerManager.getUUIDsFromString(stringArray[0], (collection, throwable) -> {
                        if (throwable instanceof TimeoutException) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                        } else if (throwable != null || collection.size() != 1) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
                        } else {
                            UUID uUID = collection.toArray(new UUID[0])[0];
                            PlotQuery plotQuery = PlotQuery.newQuery();
                            if (Settings.Teleport.VISIT_MERGED_OWNERS) {
                                plotQuery.whereBasePlot().ownersInclude(uUID);
                            } else {
                                plotQuery.whereBasePlot().ownedBy(uUID);
                            }
                            this.visit(plotPlayer, plotQuery, plotArea2, runnableVal3, runnableVal2, n2);
                        }
                    });
                    break;
                }
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_a_number"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray[1]))));
                    return CompletableFuture.completedFuture(false);
                }
            }
            case 1: {
                String[] stringArray2 = stringArray;
                int n3 = n;
                if (stringArray[0].length() >= 2 && !stringArray[0].contains(";") && !stringArray[0].contains(",")) {
                    PlotSquared.get().getImpromptuUUIDPipeline().getSingle(stringArray[0], (uUID, throwable) -> {
                        if (throwable instanceof TimeoutException) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("players.fetching_players_timeout"), new TagResolver[0]);
                        } else if (uUID != null && (Settings.Teleport.VISIT_MERGED_OWNERS ? !PlotQuery.newQuery().ownersInclude((UUID)uUID).anyMatch() : !PlotQuery.newQuery().ownedBy((UUID)uUID).anyMatch())) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.player_no_plots"), new TagResolver[0]);
                        } else if (uUID == null) {
                            if (n3 == Integer.MIN_VALUE) {
                                this.visit(plotPlayer, PlotQuery.newQuery().withAlias(stringArray2[0]), plotPlayer.getApplicablePlotArea(), runnableVal3, runnableVal2, 1);
                            } else {
                                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_player"), TagResolver.resolver("value", Tag.inserting(Component.text(stringArray2[0]))));
                            }
                        } else {
                            this.visit(plotPlayer, Settings.Teleport.VISIT_MERGED_OWNERS ? PlotQuery.newQuery().ownersInclude((UUID)uUID).whereBasePlot() : PlotQuery.newQuery().ownedBy((UUID)uUID).whereBasePlot(), null, runnableVal3, runnableVal2, n3);
                        }
                    });
                    break;
                }
                Plot plot = Plot.getPlotFromString(plotPlayer, stringArray2[0], true);
                if (plot == null) break;
                this.visit(plotPlayer, PlotQuery.newQuery().withPlot(plot), null, runnableVal3, runnableVal2, 1);
                break;
            }
            case 0: {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text(this.getUsage()))));
                return CompletableFuture.completedFuture(false);
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> plotPlayer, String[] stringArray, boolean bl) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        switch (stringArray.length - 1) {
            case 0: {
                arrayList.addAll(TabCompletions.completePlayers(plotPlayer, stringArray[0], Collections.emptyList()));
                break;
            }
            case 1: {
                arrayList.addAll(TabCompletions.completeAreas(stringArray[1]));
                if (stringArray[1].isEmpty()) {
                    arrayList.addAll(TabCompletions.asCompletions("1", "2", "3"));
                    break;
                }
                arrayList.addAll(TabCompletions.completeNumbers(stringArray[1], 10, 999));
                break;
            }
            case 2: {
                if (stringArray[2].isEmpty()) {
                    arrayList.addAll(TabCompletions.asCompletions("1", "2", "3"));
                    break;
                }
                arrayList.addAll(TabCompletions.completeNumbers(stringArray[2], 10, 999));
            }
        }
        return arrayList;
    }
}

