/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.text.minimessage.tag.standard;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.configuration.adventure.text.format.TextColor;
import com.plotsquared.core.configuration.adventure.text.minimessage.Context;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import com.plotsquared.core.configuration.adventure.util.HSVLike;
import com.plotsquared.core.configuration.examination.ExaminableProperty;
import java.util.Objects;
import java.util.stream.Stream;

final class RainbowTag
extends AbstractColorChangingTag {
    private static final String REVERSE = "!";
    private static final String RAINBOW = "rainbow";
    static final TagResolver RESOLVER = TagResolver.resolver("rainbow", RainbowTag::create);
    private final boolean reversed;
    private final int phase;
    private int colorIndex = 0;

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        boolean bl = false;
        int n = 0;
        if (argumentQueue.hasNext()) {
            String string = argumentQueue.pop().value();
            if (string.startsWith(REVERSE)) {
                bl = true;
                string = string.substring(REVERSE.length());
            }
            if (string.length() > 0) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw context.newException("Expected phase, got " + string);
                }
            }
        }
        return new RainbowTag(bl, n);
    }

    private RainbowTag(boolean bl, int n) {
        this.reversed = bl;
        this.phase = n;
    }

    @Override
    protected void init() {
        if (this.reversed) {
            this.colorIndex = this.size() - 1;
        }
    }

    @Override
    protected void advanceColor() {
        this.colorIndex = this.reversed ? (this.colorIndex == 0 ? this.size() - 1 : --this.colorIndex) : ++this.colorIndex;
    }

    @Override
    protected TextColor color() {
        float f = this.colorIndex;
        float f2 = (f / (float)this.size() + (float)this.phase / 10.0f) % 1.0f;
        return TextColor.color(HSVLike.hsvLike(f2, 1.0f, 1.0f));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RainbowTag rainbowTag = (RainbowTag)object;
        return this.colorIndex == rainbowTag.colorIndex && this.phase == rainbowTag.phase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.colorIndex, this.phase);
    }
}

