/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.util;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import java.util.function.BooleanSupplier;

public enum TriState {
    NOT_SET,
    FALSE,
    TRUE;


    @Nullable
    public Boolean toBoolean() {
        switch (this) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean toBooleanOrElse(boolean bl) {
        switch (this) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return bl;
    }

    public boolean toBooleanOrElseGet(@NotNull BooleanSupplier booleanSupplier) {
        switch (this) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return booleanSupplier.getAsBoolean();
    }

    @NotNull
    public static TriState byBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @NotNull
    public static TriState byBoolean(@Nullable Boolean bl) {
        return bl == null ? NOT_SET : TriState.byBoolean((boolean)bl);
    }
}

