/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.event.ClickEvent;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.ParsingException;
import com.plotsquared.core.configuration.caption.ChatFormatter;
import com.plotsquared.core.configuration.caption.ComponentTransform;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DescriptionFlag;
import com.plotsquared.core.plot.flag.implementations.FarewellFlag;
import com.plotsquared.core.plot.flag.implementations.GreetingFlag;
import com.plotsquared.core.plot.flag.implementations.PlotTitleFlag;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CaptionUtility {
    private static final Pattern LEGACY_FORMATTING = Pattern.compile("\u00a7[a-gklmnor0-9]");
    private static final Set<Class<? extends PlotFlag<?, ?>>> MINI_MESSAGE_FLAGS = Set.of(GreetingFlag.class, FarewellFlag.class, DescriptionFlag.class, PlotTitleFlag.class);
    private static final ComponentTransform CLICK_STRIP_TRANSFORM = ComponentTransform.nested(ComponentTransform.stripClicks((ClickEvent.Action[])Settings.Chat.CLICK_EVENT_ACTIONS_TO_REMOVE.stream().map(ClickEvent.Action::valueOf).toArray(ClickEvent.Action[]::new)));

    public static String formatRaw(PlotPlayer<?> plotPlayer, String string) {
        ChatFormatter.ChatContext chatContext = new ChatFormatter.ChatContext(plotPlayer, string, true);
        for (ChatFormatter chatFormatter : ChatFormatter.formatters) {
            chatFormatter.format(chatContext);
        }
        return chatContext.getMessage();
    }

    public static String format(@Nullable PlotPlayer<?> plotPlayer, @NonNull String string) {
        ChatFormatter.ChatContext chatContext = new ChatFormatter.ChatContext(plotPlayer, string, false);
        for (ChatFormatter chatFormatter : ChatFormatter.formatters) {
            chatFormatter.format(chatContext);
        }
        return chatContext.getMessage();
    }

    public static String stripClickEvents(@NonNull String string) {
        Object object;
        try {
            object = MiniMessage.miniMessage().deserialize(string);
        }
        catch (ParsingException parsingException) {
            String string2 = LEGACY_FORMATTING.matcher(string).replaceAll("");
            object = MiniMessage.miniMessage().deserialize(string2);
        }
        object = CLICK_STRIP_TRANSFORM.transform((Component)object);
        return (String)MiniMessage.miniMessage().serialize(object);
    }

    public static String stripClickEvents(@NonNull PlotFlag<?, ?> plotFlag, @NonNull String string) {
        if (MINI_MESSAGE_FLAGS.contains(plotFlag.getClass())) {
            return CaptionUtility.stripClickEvents(string);
        }
        return string;
    }
}

