/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.serialization;

import com.plotsquared.core.configuration.serialization.ConfigurationSerializable;
import com.plotsquared.core.configuration.serialization.DelegateDeserialization;
import com.plotsquared.core.configuration.serialization.SerializableAs;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationSerialization {
    public static final String SERIALIZED_TYPE_KEY = "==";
    private static final Map<String, Class<? extends ConfigurationSerializable>> aliases = new HashMap<String, Class<? extends ConfigurationSerializable>>();
    private final Class<? extends ConfigurationSerializable> clazz;

    protected ConfigurationSerialization(Class<? extends ConfigurationSerializable> clazz) {
        this.clazz = clazz;
    }

    public static ConfigurationSerializable deserializeObject(Map<String, ?> map, Class<? extends ConfigurationSerializable> clazz) {
        return new ConfigurationSerialization(clazz).deserialize(map);
    }

    public static ConfigurationSerializable deserializeObject(Map<String, ?> map) {
        Class<? extends ConfigurationSerializable> clazz;
        block5: {
            clazz = null;
            if (map.containsKey(SERIALIZED_TYPE_KEY)) {
                try {
                    String string = (String)map.get(SERIALIZED_TYPE_KEY);
                    if (string == null) {
                        throw new IllegalArgumentException("Cannot have null alias");
                    }
                    clazz = ConfigurationSerialization.getClassByAlias(string);
                    if (clazz == null) {
                        throw new IllegalArgumentException("Specified class does not exist ('" + string + "')");
                    }
                    break block5;
                }
                catch (ClassCastException classCastException) {
                    classCastException.fillInStackTrace();
                    throw classCastException;
                }
            }
            throw new IllegalArgumentException("Args doesn't contain type key ('==')");
        }
        return new ConfigurationSerialization(clazz).deserialize(map);
    }

    public static void registerClass(Class<? extends ConfigurationSerializable> clazz) {
        DelegateDeserialization delegateDeserialization = clazz.getAnnotation(DelegateDeserialization.class);
        if (delegateDeserialization == null) {
            ConfigurationSerialization.registerClass(clazz, ConfigurationSerialization.getAlias(clazz));
            ConfigurationSerialization.registerClass(clazz, clazz.getName());
        }
    }

    public static void registerClass(Class<? extends ConfigurationSerializable> clazz, String string) {
        aliases.put(string, clazz);
    }

    public static void unregisterClass(String string) {
        aliases.remove(string);
    }

    public static void unregisterClass(Class<? extends ConfigurationSerializable> clazz) {
        while (aliases.values().remove(clazz)) {
        }
    }

    public static Class<? extends ConfigurationSerializable> getClassByAlias(String string) {
        return aliases.get(string);
    }

    public static String getAlias(Class<? extends ConfigurationSerializable> clazz) {
        SerializableAs serializableAs;
        DelegateDeserialization delegateDeserialization = clazz.getAnnotation(DelegateDeserialization.class);
        if (delegateDeserialization != null) {
            if (delegateDeserialization.value() == clazz) {
                delegateDeserialization = null;
            } else {
                return ConfigurationSerialization.getAlias(delegateDeserialization.value());
            }
        }
        if ((serializableAs = clazz.getAnnotation(SerializableAs.class)) != null) {
            return serializableAs.value();
        }
        return clazz.getName();
    }

    protected Method getMethod(String string, boolean bl) {
        try {
            Method method = this.clazz.getDeclaredMethod(string, Map.class);
            if (!ConfigurationSerializable.class.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            if (Modifier.isStatic(method.getModifiers()) != bl) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    protected Constructor<? extends ConfigurationSerializable> getConstructor() {
        try {
            return this.clazz.getConstructor(Map.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    protected ConfigurationSerializable deserializeViaMethod(Method method, Map<String, ?> map) {
        try {
            ConfigurationSerializable configurationSerializable = (ConfigurationSerializable)method.invoke(null, map);
            if (configurationSerializable != null) {
                return configurationSerializable;
            }
            Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call method '" + method + "' of " + this.clazz + " for deserialization: method returned null");
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            if (exception instanceof InvocationTargetException) {
                Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call method '" + method + "' of " + this.clazz + " for deserialization", exception.getCause());
            }
            Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call method '" + method + "' of " + this.clazz + " for deserialization", exception);
        }
        return null;
    }

    protected ConfigurationSerializable deserializeViaCtor(Constructor<? extends ConfigurationSerializable> constructor, Map<String, ?> map) {
        try {
            return constructor.newInstance(map);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            if (exception instanceof InvocationTargetException) {
                Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call constructor '" + constructor + "' of " + this.clazz + " for deserialization", exception.getCause());
            } else {
                Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call constructor '" + constructor + "' of " + this.clazz + " for deserialization", exception);
            }
            return null;
        }
    }

    public ConfigurationSerializable deserialize(Map<String, ?> map) {
        Constructor<? extends ConfigurationSerializable> constructor;
        if (map == null) {
            throw new NullPointerException("Args must not be null");
        }
        ConfigurationSerializable configurationSerializable = null;
        Method method = this.getMethod("deserialize", true);
        if (method != null) {
            configurationSerializable = this.deserializeViaMethod(method, map);
        }
        if (configurationSerializable == null && (method = this.getMethod("valueOf", true)) != null) {
            configurationSerializable = this.deserializeViaMethod(method, map);
        }
        if (configurationSerializable == null && (constructor = this.getConstructor()) != null) {
            configurationSerializable = this.deserializeViaCtor(constructor, map);
        }
        return configurationSerializable;
    }
}

