/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.plotsquared.core.database.AbstractDB;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.task.RunnableVal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class DBFunc {
    public static final UUID EVERYONE = UUID.fromString("1-1-3-3-7");
    public static final UUID SERVER = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static AbstractDB dbManager;

    public static void updateTables(int[] nArray) {
        if (dbManager != null) {
            dbManager.updateTables(nArray);
        }
    }

    public static void addPersistentMeta(UUID uUID, String string, byte[] byArray, boolean bl) {
        if (dbManager != null) {
            dbManager.addPersistentMeta(uUID, string, byArray, bl);
        }
    }

    public static void getPersistentMeta(UUID uUID, RunnableVal<Map<String, byte[]>> runnableVal) {
        if (dbManager != null) {
            dbManager.getPersistentMeta(uUID, runnableVal);
        }
    }

    public static void removePersistentMeta(UUID uUID, String string) {
        if (dbManager != null) {
            dbManager.removePersistentMeta(uUID, string);
        }
    }

    public static CompletableFuture<Boolean> swapPlots(Plot plot, Plot plot2) {
        if (dbManager != null) {
            return dbManager.swapPlots(plot, plot2);
        }
        return CompletableFuture.completedFuture(false);
    }

    public static boolean deleteTables() {
        return dbManager != null && dbManager.deleteTables();
    }

    public static void movePlot(Plot plot, Plot plot2) {
        if (plot.temp == -1 || plot2.temp == -1) {
            return;
        }
        dbManager.movePlot(plot, plot2);
    }

    public static void validatePlots(Set<Plot> set) {
        if (dbManager == null) {
            return;
        }
        dbManager.validateAllPlots(set);
    }

    @Deprecated
    public static boolean hasColumn(ResultSet resultSet, String string) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                if (!string.equals(resultSetMetaData.getColumnName(i))) continue;
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public static void setOwner(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setOwner(plot, uUID);
    }

    public static void createPlotsAndData(List<Plot> list, Runnable runnable) {
        if (dbManager == null) {
            return;
        }
        dbManager.createPlotsAndData(list, runnable);
    }

    public static void createPlotSafe(Plot plot, Runnable runnable, Runnable runnable2) {
        if (dbManager == null) {
            return;
        }
        dbManager.createPlotSafe(plot, runnable, runnable2);
    }

    public static void createPlotAndSettings(Plot plot, Runnable runnable) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.createPlotAndSettings(plot, runnable);
    }

    public static void createTables() {
        if (dbManager == null) {
            return;
        }
        dbManager.createTables();
    }

    public static void delete(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.delete(plot);
        plot.temp = -1;
    }

    public static void deleteRatings(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteRatings(plot);
    }

    public static void deleteTrusted(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteHelpers(plot);
    }

    public static void deleteMembers(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteTrusted(plot);
    }

    public static void deleteDenied(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteDenied(plot);
    }

    public static void deleteComments(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteComments(plot);
    }

    public static void deleteSettings(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteSettings(plot);
    }

    public static void delete(PlotCluster plotCluster) {
        if (dbManager == null) {
            return;
        }
        dbManager.delete(plotCluster);
    }

    public static void createPlotSettings(int n, Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.createPlotSettings(n, plot);
    }

    public static int getId(Plot plot) {
        if (dbManager == null) {
            return 0;
        }
        return dbManager.getId(plot);
    }

    public static HashMap<String, HashMap<PlotId, Plot>> getPlots() {
        if (dbManager == null) {
            return new HashMap<String, HashMap<PlotId, Plot>>();
        }
        return dbManager.getPlots();
    }

    public static void setMerged(Plot plot, boolean[] blArray) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setMerged(plot, blArray);
    }

    public static void setFlag(Plot plot, PlotFlag<?, ?> plotFlag) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setFlag(plot, plotFlag);
    }

    public static void removeFlag(Plot plot, PlotFlag<?, ?> plotFlag) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeFlag(plot, plotFlag);
    }

    public static void setAlias(Plot plot, String string) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setAlias(plot, string);
    }

    public static void purgeIds(Set<Integer> set) {
        if (dbManager == null) {
            return;
        }
        dbManager.purgeIds(set);
    }

    public static void purge(PlotArea plotArea, Set<PlotId> set) {
        if (dbManager == null) {
            return;
        }
        dbManager.purge(plotArea, set);
    }

    public static void setPosition(Plot plot, String string) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setPosition(plot, string);
    }

    public static void removeComment(Plot plot, PlotComment plotComment) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeComment(plot, plotComment);
    }

    public static void clearInbox(Plot plot, String string) {
        if (plot != null && plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.clearInbox(plot, string);
    }

    public static void setComment(Plot plot, PlotComment plotComment) {
        if (plot != null && plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setComment(plot, plotComment);
    }

    public static void getComments(Plot plot, String string, RunnableVal<List<PlotComment>> runnableVal) {
        if (plot != null && plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.getComments(plot, string, runnableVal);
    }

    public static void removeTrusted(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeTrusted(plot, uUID);
    }

    public static void removeHelper(PlotCluster plotCluster, UUID uUID) {
        if (dbManager == null) {
            return;
        }
        dbManager.removeHelper(plotCluster, uUID);
    }

    public static void createCluster(PlotCluster plotCluster) {
        if (dbManager == null) {
            return;
        }
        dbManager.createCluster(plotCluster);
    }

    public static void resizeCluster(PlotCluster plotCluster, PlotId plotId, PlotId plotId2) {
        if (dbManager == null) {
            return;
        }
        dbManager.resizeCluster(plotCluster, plotId, plotId2);
    }

    public static void removeMember(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeMember(plot, uUID);
    }

    public static void removeInvited(PlotCluster plotCluster, UUID uUID) {
        if (dbManager == null) {
            return;
        }
        dbManager.removeInvited(plotCluster, uUID);
    }

    public static void setTrusted(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setTrusted(plot, uUID);
    }

    public static void setHelper(PlotCluster plotCluster, UUID uUID) {
        if (dbManager == null) {
            return;
        }
        dbManager.setHelper(plotCluster, uUID);
    }

    public static void setMember(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setMember(plot, uUID);
    }

    public static void setInvited(PlotCluster plotCluster, UUID uUID) {
        if (dbManager == null) {
            return;
        }
        dbManager.setInvited(plotCluster, uUID);
    }

    public static void removeDenied(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeDenied(plot, uUID);
    }

    public static void setDenied(Plot plot, UUID uUID) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setDenied(plot, uUID);
    }

    public static HashMap<UUID, Integer> getRatings(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return new HashMap<UUID, Integer>(0);
        }
        return dbManager.getRatings(plot);
    }

    public static void setRating(Plot plot, UUID uUID, int n) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setRating(plot, uUID, n);
    }

    public static HashMap<String, Set<PlotCluster>> getClusters() {
        if (dbManager == null) {
            return new HashMap<String, Set<PlotCluster>>();
        }
        return dbManager.getClusters();
    }

    public static void setPosition(PlotCluster plotCluster, String string) {
        if (dbManager == null) {
            return;
        }
        dbManager.setPosition(plotCluster, string);
    }

    public static void replaceWorld(String string, String string2, PlotId plotId, PlotId plotId2) {
        if (dbManager == null) {
            return;
        }
        dbManager.replaceWorld(string, string2, plotId, plotId2);
    }

    public static void replaceUUID(UUID uUID, UUID uUID2) {
        if (dbManager == null) {
            return;
        }
        dbManager.replaceUUID(uUID, uUID2);
    }

    public static void close() {
        if (dbManager != null) {
            dbManager.close();
        }
    }
}

