/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.google.common.base.Charsets;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.database.AbstractDB;
import com.plotsquared.core.database.Database;
import com.plotsquared.core.database.MySQL;
import com.plotsquared.core.database.StmtMod;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeListFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.HashUtil;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SQLManager
implements AbstractDB {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SQLManager.class.getSimpleName()));
    public final String SET_OWNER;
    public final String GET_ALL_PLOTS;
    public final String CREATE_PLOTS;
    public final String CREATE_SETTINGS;
    public final String CREATE_TIERS;
    public final String CREATE_PLOT;
    public final String CREATE_PLOT_SAFE;
    public final String CREATE_CLUSTER;
    private final String prefix;
    private final Database database;
    private final boolean mySQL;
    private final EventDispatcher eventDispatcher;
    private final PlotListener plotListener;
    private final YamlConfiguration worldConfiguration;
    public volatile Queue<Runnable> globalTasks;
    public volatile Queue<Runnable> notifyTasks;
    public volatile ConcurrentHashMap<Plot, Queue<UniqueStatement>> plotTasks;
    public volatile ConcurrentHashMap<UUID, Queue<UniqueStatement>> playerTasks;
    public volatile ConcurrentHashMap<PlotCluster, Queue<UniqueStatement>> clusterTasks;
    private Connection connection;
    private boolean supportsGetGeneratedKeys;
    private boolean closed = false;

    public SQLManager(@NonNull Database database, @NonNull String string, @NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration yamlConfiguration) {
        String string2;
        this.eventDispatcher = eventDispatcher;
        this.plotListener = plotListener;
        this.worldConfiguration = yamlConfiguration;
        this.database = database;
        this.connection = database.openConnection();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.supportsGetGeneratedKeys = databaseMetaData.supportsGetGeneratedKeys();
        this.mySQL = database instanceof MySQL;
        this.globalTasks = new ConcurrentLinkedQueue<Runnable>();
        this.notifyTasks = new ConcurrentLinkedQueue<Runnable>();
        this.plotTasks = new ConcurrentHashMap();
        this.playerTasks = new ConcurrentHashMap();
        this.clusterTasks = new ConcurrentHashMap();
        this.prefix = string;
        if (this.mySQL && !this.supportsGetGeneratedKeys) {
            String string3 = databaseMetaData.getDriverName();
            String string4 = databaseMetaData.getDriverVersion();
            throw new SQLException("Database Driver for MySQL does not support Statement#getGeneratedKeys - which breaks PlotSquared functionality (Using " + string3 + ":" + string4 + ")");
        }
        this.SET_OWNER = "UPDATE `" + this.prefix + "plot` SET `owner` = ? WHERE `plot_id_x` = ? AND `plot_id_z` = ? AND `world` = ?";
        this.GET_ALL_PLOTS = "SELECT `id`, `plot_id_x`, `plot_id_z`, `world` FROM `" + this.prefix + "plot`";
        this.CREATE_PLOTS = "INSERT INTO `" + this.prefix + "plot`(`plot_id_x`, `plot_id_z`, `owner`, `world`, `timestamp`) values ";
        this.CREATE_SETTINGS = "INSERT INTO `" + this.prefix + "plot_settings` (`plot_plot_id`) values ";
        this.CREATE_TIERS = "INSERT INTO `" + this.prefix + "plot_%tier%` (`plot_plot_id`, `user_uuid`) values ";
        String string5 = "INSERT INTO `" + this.prefix + "plot`(`plot_id_x`, `plot_id_z`, `owner`, `world`, `timestamp`) VALUES(?, ?, ?, ?, ?)";
        if (!this.supportsGetGeneratedKeys) {
            string5 = string5 + " RETURNING `id`";
        }
        this.CREATE_PLOT = string5;
        if (this.mySQL) {
            this.CREATE_PLOT_SAFE = "INSERT IGNORE INTO `" + this.prefix + "plot`(`plot_id_x`, `plot_id_z`, `owner`, `world`, `timestamp`) SELECT ?, ?, ?, ?, ? FROM DUAL WHERE NOT EXISTS (SELECT null FROM `" + this.prefix + "plot` WHERE `world` = ? AND `plot_id_x` = ? AND `plot_id_z` = ?)";
        } else {
            string2 = "INSERT INTO `" + this.prefix + "plot`(`plot_id_x`, `plot_id_z`, `owner`, `world`, `timestamp`) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT null FROM `" + this.prefix + "plot` WHERE `world` = ? AND `plot_id_x` = ? AND `plot_id_z` = ?)";
            if (!this.supportsGetGeneratedKeys) {
                string2 = string2 + " RETURNING `id`";
            }
            this.CREATE_PLOT_SAFE = string2;
        }
        string2 = "INSERT INTO `" + this.prefix + "cluster`(`pos1_x`, `pos1_z`, `pos2_x`, `pos2_z`, `owner`, `world`) VALUES(?, ?, ?, ?, ?, ?)";
        if (!this.supportsGetGeneratedKeys) {
            string2 = string2 + " RETURNING `id`";
        }
        this.CREATE_CLUSTER = string2;
        try {
            this.createTables();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        TaskManager.runTaskAsync(() -> {
            long l = System.currentTimeMillis();
            while (!this.closed) {
                boolean bl;
                boolean bl2 = bl = !this.globalTasks.isEmpty() || !this.playerTasks.isEmpty() || !this.plotTasks.isEmpty() || !this.clusterTasks.isEmpty();
                if (bl) {
                    if (this.mySQL && System.currentTimeMillis() - l > 550000L || !this.isValid()) {
                        l = System.currentTimeMillis();
                        this.reconnect();
                    }
                    if (this.sendBatch()) continue;
                    try {
                        if (!this.getNotifyTasks().isEmpty()) {
                            for (Runnable runnable : this.getNotifyTasks()) {
                                TaskManager.runTask(runnable);
                            }
                            this.getNotifyTasks().clear();
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }

    public boolean isValid() {
        boolean bl;
        block11: {
            try {
                if (this.connection.isClosed()) {
                    return false;
                }
            }
            catch (SQLException sQLException) {
                return false;
            }
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT 1");
            try {
                preparedStatement.execute();
                bl = true;
                if (preparedStatement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    public void reconnect() {
        try {
            this.close();
            this.closed = false;
            this.connection = this.database.forceConnection();
        }
        catch (ClassNotFoundException | SQLException exception) {
            exception.printStackTrace();
        }
    }

    public synchronized Queue<Runnable> getGlobalTasks() {
        return this.globalTasks;
    }

    public synchronized Queue<Runnable> getNotifyTasks() {
        return this.notifyTasks;
    }

    public synchronized void addPlotTask(@NonNull Plot plot, UniqueStatement uniqueStatement) {
        Queue<UniqueStatement> queue = this.plotTasks.get(plot);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<UniqueStatement>();
            this.plotTasks.put(plot, queue);
        }
        if (uniqueStatement == null) {
            uniqueStatement = new UniqueStatement(String.valueOf(plot.hashCode())){

                @Override
                public PreparedStatement get() {
                    return null;
                }

                @Override
                public void set(PreparedStatement preparedStatement) {
                }

                @Override
                public void addBatch(PreparedStatement preparedStatement) {
                }

                @Override
                public void execute(PreparedStatement preparedStatement) {
                }
            };
        }
        queue.add(uniqueStatement);
    }

    public synchronized void addPlayerTask(UUID uUID, UniqueStatement uniqueStatement) {
        if (uUID == null) {
            return;
        }
        Queue<UniqueStatement> queue = this.playerTasks.get(uUID);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<UniqueStatement>();
            this.playerTasks.put(uUID, queue);
        }
        if (uniqueStatement == null) {
            uniqueStatement = new UniqueStatement(String.valueOf(uUID.hashCode())){

                @Override
                public PreparedStatement get() {
                    return null;
                }

                @Override
                public void set(PreparedStatement preparedStatement) {
                }

                @Override
                public void addBatch(PreparedStatement preparedStatement) {
                }

                @Override
                public void execute(PreparedStatement preparedStatement) {
                }
            };
        }
        queue.add(uniqueStatement);
    }

    public synchronized void addClusterTask(PlotCluster plotCluster, UniqueStatement uniqueStatement) {
        Queue<UniqueStatement> queue = this.clusterTasks.get(plotCluster);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<UniqueStatement>();
            this.clusterTasks.put(plotCluster, queue);
        }
        if (uniqueStatement == null) {
            uniqueStatement = new UniqueStatement(String.valueOf(plotCluster.hashCode())){

                @Override
                public PreparedStatement get() {
                    return null;
                }

                @Override
                public void set(PreparedStatement preparedStatement) {
                }

                @Override
                public void addBatch(PreparedStatement preparedStatement) {
                }

                @Override
                public void execute(PreparedStatement preparedStatement) {
                }
            };
        }
        queue.add(uniqueStatement);
    }

    public synchronized void addGlobalTask(Runnable runnable) {
        this.getGlobalTasks().add(runnable);
    }

    public synchronized void addNotifyTask(Runnable runnable) {
        if (runnable != null) {
            this.getNotifyTasks().add(runnable);
        }
    }

    public boolean sendBatch() {
        try {
            Object object;
            UniqueStatement uniqueStatement;
            UniqueStatement uniqueStatement2;
            Statement statement;
            String string;
            if (!this.getGlobalTasks().isEmpty()) {
                Runnable runnable;
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                if ((runnable = this.getGlobalTasks().remove()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("============ DATABASE ERROR ============");
                        LOGGER.error("============ DATABASE ERROR ============");
                        LOGGER.error("There was an error updating the database.");
                        LOGGER.error(" - It will be corrected on shutdown");
                        throwable.printStackTrace();
                        LOGGER.error("========================================");
                    }
                }
                this.commit();
                return true;
            }
            int n = -1;
            if (!this.plotTasks.isEmpty()) {
                n = Math.max(n, 0);
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                string = null;
                statement = null;
                uniqueStatement2 = null;
                uniqueStatement = null;
                Iterator<Map.Entry<Object, Queue<UniqueStatement>>> iterator = this.plotTasks.entrySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        Map.Entry<Object, Queue<UniqueStatement>> throwable = iterator.next();
                        object = throwable.getValue();
                        if (object.isEmpty()) {
                            iterator.remove();
                            continue;
                        }
                        uniqueStatement2 = object.remove();
                        ++n;
                        if (uniqueStatement2 != null) {
                            if (uniqueStatement2.method == null || !uniqueStatement2.method.equals(string) || statement == null) {
                                if (statement != null) {
                                    uniqueStatement.execute((PreparedStatement)statement);
                                    statement.close();
                                }
                                string = uniqueStatement2.method;
                                statement = uniqueStatement2.get();
                            }
                            uniqueStatement2.set((PreparedStatement)statement);
                            uniqueStatement2.addBatch((PreparedStatement)statement);
                            try {
                                if (statement.isClosed()) {
                                    statement = null;
                                }
                            }
                            catch (AbstractMethodError | NullPointerException throwable2) {
                                // empty catch block
                            }
                        }
                        uniqueStatement = uniqueStatement2;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("============ DATABASE ERROR ============");
                        LOGGER.error("There was an error updating the database.");
                        LOGGER.error(" - It will be corrected on shutdown");
                        LOGGER.error("========================================");
                        throwable.printStackTrace();
                        LOGGER.error("========================================");
                    }
                }
                if (statement != null && uniqueStatement2 != null) {
                    uniqueStatement2.execute((PreparedStatement)statement);
                    statement.close();
                }
            }
            if (!this.playerTasks.isEmpty()) {
                n = Math.max(n, 0);
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                string = null;
                statement = null;
                uniqueStatement2 = null;
                uniqueStatement = null;
                for (Map.Entry<Object, Queue<UniqueStatement>> entry : this.playerTasks.entrySet()) {
                    try {
                        object = (UUID)entry.getKey();
                        if (this.playerTasks.get(object).isEmpty()) {
                            this.playerTasks.remove(object);
                            continue;
                        }
                        uniqueStatement2 = this.playerTasks.get(object).remove();
                        ++n;
                        if (uniqueStatement2 != null) {
                            if (uniqueStatement2.method == null || !uniqueStatement2.method.equals(string)) {
                                if (statement != null) {
                                    uniqueStatement.execute((PreparedStatement)statement);
                                    statement.close();
                                }
                                string = uniqueStatement2.method;
                                statement = uniqueStatement2.get();
                            }
                            uniqueStatement2.set((PreparedStatement)statement);
                            uniqueStatement2.addBatch((PreparedStatement)statement);
                        }
                        uniqueStatement = uniqueStatement2;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("============ DATABASE ERROR ============");
                        LOGGER.error("There was an error updating the database.");
                        LOGGER.error(" - It will be corrected on shutdown");
                        LOGGER.error("========================================");
                        throwable.printStackTrace();
                        LOGGER.error("========================================");
                    }
                }
                if (statement != null && uniqueStatement2 != null) {
                    uniqueStatement2.execute((PreparedStatement)statement);
                    statement.close();
                }
            }
            if (!this.clusterTasks.isEmpty()) {
                n = Math.max(n, 0);
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                string = null;
                statement = null;
                uniqueStatement2 = null;
                uniqueStatement = null;
                for (Map.Entry<Object, Queue<UniqueStatement>> entry : this.clusterTasks.entrySet()) {
                    try {
                        object = (PlotCluster)entry.getKey();
                        if (this.clusterTasks.get(object).isEmpty()) {
                            this.clusterTasks.remove(object);
                            continue;
                        }
                        uniqueStatement2 = this.clusterTasks.get(object).remove();
                        ++n;
                        if (uniqueStatement2 != null) {
                            if (uniqueStatement2.method == null || !uniqueStatement2.method.equals(string)) {
                                if (statement != null) {
                                    uniqueStatement.execute((PreparedStatement)statement);
                                    statement.close();
                                }
                                string = uniqueStatement2.method;
                                statement = uniqueStatement2.get();
                            }
                            uniqueStatement2.set((PreparedStatement)statement);
                            uniqueStatement2.addBatch((PreparedStatement)statement);
                        }
                        uniqueStatement = uniqueStatement2;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("============ DATABASE ERROR ============");
                        LOGGER.error("There was an error updating the database.");
                        LOGGER.error(" - It will be corrected on shutdown");
                        LOGGER.error("========================================");
                        throwable.printStackTrace();
                        LOGGER.error("========================================");
                    }
                }
                if (statement != null && uniqueStatement2 != null) {
                    uniqueStatement2.execute((PreparedStatement)statement);
                    statement.close();
                }
            }
            if (n > 0) {
                this.commit();
                return true;
            }
            if (n != -1 && !this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(true);
            }
            if (!this.clusterTasks.isEmpty()) {
                this.clusterTasks.clear();
            }
            if (!this.plotTasks.isEmpty()) {
                this.plotTasks.clear();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("============ DATABASE ERROR ============");
            LOGGER.error("There was an error updating the database.");
            LOGGER.error(" - It will be corrected on shutdown");
            LOGGER.error("========================================");
            throwable.printStackTrace();
            LOGGER.error("========================================");
        }
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setOwner(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("setOwner"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setInt(2, plot.getId().getX());
                preparedStatement.setInt(3, plot.getId().getY());
                preparedStatement.setString(4, plot.getArea().toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement(SQLManager.this.SET_OWNER);
            }
        });
    }

    @Override
    public void createPlotsAndData(List<Plot> list, Runnable runnable) {
        this.addGlobalTask(() -> {
            try {
                this.createPlots(list, () -> {
                    HashMap<PlotId, Integer> hashMap = new HashMap<PlotId, Integer>();
                    try {
                        Object object2;
                        HashMap<PlotId, Plot> hashMap2 = new HashMap<PlotId, Plot>();
                        for (Object object2 : list) {
                            hashMap2.put(((Plot)object2).getId(), (Plot)object2);
                        }
                        ArrayList arrayList = new ArrayList();
                        object2 = new ArrayList();
                        ArrayList<UUIDPair> arrayList2 = new ArrayList<UUIDPair>();
                        ArrayList<UUIDPair> arrayList3 = new ArrayList<UUIDPair>();
                        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.GET_ALL_PLOTS);
                             ResultSet resultSet = preparedStatement.executeQuery();){
                            while (resultSet.next()) {
                                int n = resultSet.getInt("id");
                                int n2 = resultSet.getInt("plot_id_x");
                                int n3 = resultSet.getInt("plot_id_z");
                                PlotId plotId = PlotId.of(n2, n3);
                                Plot plot = (Plot)hashMap2.get(plotId);
                                hashMap.put(plotId, n);
                                if (plot == null) continue;
                                arrayList.add(new LegacySettings(n, plot.getSettings()));
                                for (UUID uUID : plot.getDenied()) {
                                    arrayList3.add(new UUIDPair(n, uUID));
                                }
                                for (UUID uUID : plot.getMembers()) {
                                    arrayList2.add(new UUIDPair(n, uUID));
                                }
                                for (UUID uUID : plot.getTrusted()) {
                                    ((ArrayList)object2).add(new UUIDPair(n, uUID));
                                }
                            }
                        }
                        this.createFlags(hashMap, list, () -> this.lambda$createPlotsAndData$5(arrayList, (ArrayList)object2, arrayList2, arrayList3, runnable));
                    }
                    catch (SQLException sQLException) {
                        LOGGER.warn("Failed to set all flags and member tiers for plots", (Throwable)sQLException);
                        try {
                            this.connection.commit();
                        }
                        catch (SQLException sQLException2) {
                            sQLException2.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Warning! Failed to set all helper for plots", (Throwable)exception);
                try {
                    this.connection.commit();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
    }

    public void createTiers(ArrayList<UUIDPair> arrayList, final String string, Runnable runnable) {
        StmtMod<UUIDPair> stmtMod = new StmtMod<UUIDPair>(){

            @Override
            public String getCreateMySQL(int n) {
                return this.getCreateMySQL(n, SQLManager.this.CREATE_TIERS.replaceAll("%tier%", string), 2);
            }

            @Override
            public String getCreateSQLite(int n) {
                return this.getCreateSQLite(n, "INSERT INTO `" + SQLManager.this.prefix + "plot_" + string + "` SELECT ? AS `plot_plot_id`, ? AS `user_uuid`", 2);
            }

            @Override
            public String getCreateSQL() {
                return "INSERT INTO `" + SQLManager.this.prefix + "plot_" + string + "` (`plot_plot_id`, `user_uuid`) VALUES(?,?)";
            }

            @Override
            public void setMySQL(PreparedStatement preparedStatement, int n, UUIDPair uUIDPair) {
                preparedStatement.setInt(n * 2 + 1, uUIDPair.id);
                preparedStatement.setString(n * 2 + 2, uUIDPair.uuid.toString());
            }

            @Override
            public void setSQLite(PreparedStatement preparedStatement, int n, UUIDPair uUIDPair) {
                preparedStatement.setInt(n * 2 + 1, uUIDPair.id);
                preparedStatement.setString(n * 2 + 2, uUIDPair.uuid.toString());
            }

            @Override
            public void setSQL(PreparedStatement preparedStatement, UUIDPair uUIDPair) {
                preparedStatement.setInt(1, uUIDPair.id);
                preparedStatement.setString(2, uUIDPair.uuid.toString());
            }
        };
        this.setBulk(arrayList, stmtMod, runnable);
    }

    public void createFlags(Map<PlotId, Integer> map, List<Plot> list, Runnable runnable) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO `" + this.prefix + "plot_flags`(`plot_id`, `flag`, `value`) VALUES(?, ?, ?)");){
            for (Plot plot : list) {
                FlagContainer flagContainer = plot.getFlagContainer();
                for (PlotFlag<?, ?> plotFlag : flagContainer.getFlagMap().values()) {
                    preparedStatement.setInt(1, map.get(plot.getId()));
                    preparedStatement.setString(2, plotFlag.getName());
                    preparedStatement.setString(3, plotFlag.toString());
                    preparedStatement.addBatch();
                }
                try {
                    preparedStatement.executeBatch();
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to store flag values for plot with entry ID: {}", (Object)plot);
                    exception.printStackTrace();
                    continue;
                }
                LOGGER.info("- Finished converting flag values for plot with entry ID: {}", (Object)plot.getId());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to store flag values", (Throwable)exception);
        }
        LOGGER.info("Finished converting flags ({} plots processed)", (Object)list.size());
        runnable.run();
    }

    public void createPlots(List<Plot> list, Runnable runnable) {
        StmtMod<Plot> stmtMod = new StmtMod<Plot>(){

            @Override
            public String getCreateMySQL(int n) {
                return this.getCreateMySQL(n, SQLManager.this.CREATE_PLOTS, 5);
            }

            @Override
            public String getCreateSQLite(int n) {
                return this.getCreateSQLite(n, "INSERT INTO `" + SQLManager.this.prefix + "plot` SELECT ? AS `id`, ? AS `plot_id_x`, ? AS `plot_id_z`, ? AS `owner`, ? AS `world`, ? AS `timestamp` ", 6);
            }

            @Override
            public String getCreateSQL() {
                return SQLManager.this.CREATE_PLOT;
            }

            @Override
            public void setMySQL(PreparedStatement preparedStatement, int n, Plot plot) {
                preparedStatement.setInt(n * 5 + 1, plot.getId().getX());
                preparedStatement.setInt(n * 5 + 2, plot.getId().getY());
                try {
                    preparedStatement.setString(n * 5 + 3, plot.getOwnerAbs().toString());
                }
                catch (SQLException sQLException) {
                    preparedStatement.setString(n * 5 + 3, AbstractDB.everyone.toString());
                }
                preparedStatement.setString(n * 5 + 4, plot.getArea().toString());
                preparedStatement.setTimestamp(n * 5 + 5, new Timestamp(plot.getTimestamp()));
            }

            @Override
            public void setSQLite(PreparedStatement preparedStatement, int n, Plot plot) {
                preparedStatement.setNull(n * 6 + 1, 4);
                preparedStatement.setInt(n * 6 + 2, plot.getId().getX());
                preparedStatement.setInt(n * 6 + 3, plot.getId().getY());
                try {
                    preparedStatement.setString(n * 6 + 4, plot.getOwnerAbs().toString());
                }
                catch (SQLException sQLException) {
                    preparedStatement.setString(n * 6 + 4, AbstractDB.everyone.toString());
                }
                preparedStatement.setString(n * 6 + 5, plot.getArea().toString());
                preparedStatement.setTimestamp(n * 6 + 6, new Timestamp(plot.getTimestamp()));
            }

            @Override
            public void setSQL(PreparedStatement preparedStatement, Plot plot) {
                preparedStatement.setInt(1, plot.getId().getX());
                preparedStatement.setInt(2, plot.getId().getY());
                preparedStatement.setString(3, plot.getOwnerAbs().toString());
                preparedStatement.setString(4, plot.getArea().toString());
                preparedStatement.setTimestamp(5, new Timestamp(plot.getTimestamp()));
            }
        };
        this.setBulk(list, stmtMod, runnable);
    }

    public <T> void setBulk(List<T> list, StmtMod<T> stmtMod, Runnable runnable) {
        int n = list.size();
        if (n == 0) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        int n2 = this.mySQL ? Math.min(n, 5000) : Math.min(n, 50);
        int n3 = n / n2;
        try {
            List<T> list2;
            int n4 = 0;
            Statement statement = null;
            int n5 = -1;
            for (int i = 0; i <= n3 && !(list2 = list.subList(i * n2, Math.min(n, (i + 1) * n2))).isEmpty(); ++i) {
                String string;
                if (n5 == -1) {
                    n5 = list2.size();
                    string = stmtMod.getCreateMySQL(list2.size());
                    statement = this.connection.prepareStatement(string);
                }
                if (list2.size() != n5 || n4 % 5000 == 0 && n4 > 0) {
                    statement.executeBatch();
                    statement.close();
                    string = stmtMod.getCreateMySQL(list2.size());
                    statement = this.connection.prepareStatement(string);
                }
                for (int j = 0; j < list2.size(); ++j) {
                    ++n4;
                    T t = list2.get(j);
                    stmtMod.setMySQL((PreparedStatement)statement, j, t);
                }
                n5 = list2.size();
                statement.addBatch();
            }
            statement.executeBatch();
            statement.clearParameters();
            statement.close();
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        catch (SQLException sQLException) {
            if (this.mySQL) {
                LOGGER.error("1: | {}", (Object)list.get(0).getClass().getCanonicalName());
                sQLException.printStackTrace();
            }
            try {
                List<T> list3;
                int n6 = 0;
                Statement statement = null;
                int n7 = -1;
                for (int i = 0; i <= n3 && !(list3 = list.subList(i * n2, Math.min(n, (i + 1) * n2))).isEmpty(); ++i) {
                    String string;
                    if (n7 == -1) {
                        n7 = list3.size();
                        string = stmtMod.getCreateSQLite(list3.size());
                        statement = this.connection.prepareStatement(string);
                    }
                    if (list3.size() != n7 || n6 % 5000 == 0 && n6 > 0) {
                        statement.executeBatch();
                        statement.clearParameters();
                        string = stmtMod.getCreateSQLite(list3.size());
                        statement = this.connection.prepareStatement(string);
                    }
                    for (int j = 0; j < list3.size(); ++j) {
                        ++n6;
                        T t = list3.get(j);
                        stmtMod.setSQLite((PreparedStatement)statement, j, t);
                    }
                    n7 = list3.size();
                    statement.addBatch();
                }
                statement.executeBatch();
                statement.clearParameters();
                statement.close();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                LOGGER.error("2: | {}", (Object)list.get(0).getClass().getCanonicalName());
                LOGGER.error("Could not bulk save!");
                try (PreparedStatement preparedStatement = this.connection.prepareStatement(stmtMod.getCreateSQL());){
                    for (T t : list) {
                        stmtMod.setSQL(preparedStatement, t);
                        preparedStatement.addBatch();
                    }
                    preparedStatement.executeBatch();
                }
                catch (SQLException sQLException3) {
                    LOGGER.error("Failed to save all", (Throwable)sQLException2);
                    sQLException3.printStackTrace();
                }
            }
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
    }

    public void createSettings(ArrayList<LegacySettings> arrayList, Runnable runnable) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO `" + this.prefix + "plot_settings`(`plot_plot_id`,`biome`,`rain`,`custom_time`,`time`,`deny_entry`,`alias`,`merged`,`position`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = this.mySQL ? Math.min(arrayList.size(), 5000) : Math.min(arrayList.size(), 50);
            int n2 = 0;
            int n3 = 0;
            for (LegacySettings legacySettings : arrayList) {
                preparedStatement.setInt(1, legacySettings.id);
                preparedStatement.setNull(2, 4);
                preparedStatement.setNull(3, 4);
                preparedStatement.setNull(4, 4);
                preparedStatement.setNull(5, 4);
                preparedStatement.setNull(6, 4);
                if (legacySettings.settings.getAlias().isEmpty()) {
                    preparedStatement.setNull(7, 4);
                } else {
                    preparedStatement.setString(7, legacySettings.settings.getAlias());
                }
                boolean[] blArray = legacySettings.settings.getMerged();
                int n4 = HashUtil.hash(blArray);
                preparedStatement.setInt(8, n4);
                BlockLoc blockLoc = legacySettings.settings.getPosition();
                Object object = blockLoc.getY() == 0 ? "DEFAULT" : blockLoc.getX() + "," + blockLoc.getY() + "," + blockLoc.getZ();
                preparedStatement.setString(9, (String)object);
                preparedStatement.addBatch();
                if (++n3 >= n) {
                    try {
                        preparedStatement.executeBatch();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to store settings for plot with entry ID: {}", (Object)legacySettings.id);
                        exception.printStackTrace();
                        continue;
                    }
                }
                ++n2;
            }
            if (n2 < arrayList.size()) {
                try {
                    preparedStatement.executeBatch();
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to store settings", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to store settings", (Throwable)exception);
        }
        LOGGER.info("Finished converting settings ({} plots processed)", (Object)arrayList.size());
        runnable.run();
    }

    public void createEmptySettings(ArrayList<Integer> arrayList, Runnable runnable) {
        StmtMod<Integer> stmtMod = new StmtMod<Integer>(){

            @Override
            public String getCreateMySQL(int n) {
                return this.getCreateMySQL(n, SQLManager.this.CREATE_SETTINGS, 1);
            }

            @Override
            public String getCreateSQLite(int n) {
                return this.getCreateSQLite(n, "INSERT INTO `" + SQLManager.this.prefix + "plot_settings` SELECT ? AS `plot_plot_id`, ? AS `biome`, ? AS `rain`, ? AS `custom_time`, ? AS `time`, ? AS `deny_entry`, ? AS `alias`, ? AS `merged`, ? AS `position` ", 10);
            }

            @Override
            public String getCreateSQL() {
                return "INSERT INTO `" + SQLManager.this.prefix + "plot_settings`(`plot_plot_id`) VALUES(?)";
            }

            @Override
            public void setMySQL(PreparedStatement preparedStatement, int n, Integer n2) {
                preparedStatement.setInt(n + 1, n2);
            }

            @Override
            public void setSQLite(PreparedStatement preparedStatement, int n, Integer n2) {
                preparedStatement.setInt(n * 10 + 1, n2);
                preparedStatement.setNull(n * 10 + 2, 4);
                preparedStatement.setNull(n * 10 + 3, 4);
                preparedStatement.setNull(n * 10 + 4, 4);
                preparedStatement.setNull(n * 10 + 5, 4);
                preparedStatement.setNull(n * 10 + 6, 4);
                preparedStatement.setNull(n * 10 + 7, 4);
                preparedStatement.setNull(n * 10 + 8, 4);
                preparedStatement.setString(n * 10 + 9, "DEFAULT");
            }

            @Override
            public void setSQL(PreparedStatement preparedStatement, Integer n) {
                preparedStatement.setInt(1, n);
            }
        };
        this.addGlobalTask(() -> this.setBulk(arrayList, stmtMod, runnable));
    }

    @Override
    public void createPlotSafe(final Plot plot, final Runnable runnable, final Runnable runnable2) {
        this.addPlotTask(plot, new UniqueStatement("createPlotSafe_" + plot.hashCode()){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, plot.getId().getX());
                preparedStatement.setInt(2, plot.getId().getY());
                preparedStatement.setString(3, plot.getOwnerAbs().toString());
                preparedStatement.setString(4, plot.getArea().toString());
                preparedStatement.setTimestamp(5, new Timestamp(plot.getTimestamp()));
                preparedStatement.setString(6, plot.getArea().toString());
                preparedStatement.setInt(7, plot.getId().getX());
                preparedStatement.setInt(8, plot.getId().getY());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement(SQLManager.this.CREATE_PLOT_SAFE, 1);
            }

            @Override
            public void execute(PreparedStatement preparedStatement) {
            }

            @Override
            public void addBatch(PreparedStatement preparedStatement) {
                if (preparedStatement.execute() || preparedStatement.getUpdateCount() > 0) {
                    try (ResultSet resultSet = SQLManager.this.supportsGetGeneratedKeys ? preparedStatement.getGeneratedKeys() : preparedStatement.getResultSet();){
                        if (resultSet.next()) {
                            plot.temp = resultSet.getInt(1);
                            SQLManager.this.addPlotTask(plot, new UniqueStatement("createPlotAndSettings_settings_" + plot.hashCode()){

                                @Override
                                public void set(PreparedStatement preparedStatement) {
                                    preparedStatement.setInt(1, SQLManager.this.getId(plot));
                                }

                                @Override
                                public PreparedStatement get() {
                                    return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_settings`(`plot_plot_id`) VALUES(?)");
                                }
                            });
                            if (runnable != null) {
                                SQLManager.this.addNotifyTask(runnable);
                            }
                            return;
                        }
                    }
                }
                if (runnable2 != null) {
                    runnable2.run();
                }
            }
        });
    }

    public void commit() {
        if (this.closed) {
            return;
        }
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    @Override
    public void createPlotAndSettings(final Plot plot, Runnable runnable) {
        this.addPlotTask(plot, new UniqueStatement("createPlotAndSettings_" + plot.hashCode()){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, plot.getId().getX());
                preparedStatement.setInt(2, plot.getId().getY());
                preparedStatement.setString(3, plot.getOwnerAbs().toString());
                preparedStatement.setString(4, plot.getArea().toString());
                preparedStatement.setTimestamp(5, new Timestamp(plot.getTimestamp()));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement(SQLManager.this.CREATE_PLOT, 1);
            }

            @Override
            public void execute(PreparedStatement preparedStatement) {
            }

            @Override
            public void addBatch(PreparedStatement preparedStatement) {
                preparedStatement.execute();
                try (ResultSet resultSet = SQLManager.this.supportsGetGeneratedKeys ? preparedStatement.getGeneratedKeys() : preparedStatement.getResultSet();){
                    if (resultSet.next()) {
                        plot.temp = resultSet.getInt(1);
                    }
                }
            }
        });
        this.addPlotTask(plot, new UniqueStatement("createPlotAndSettings_settings_" + plot.hashCode()){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_settings`(`plot_plot_id`) VALUES(?)");
            }
        });
        this.addNotifyTask(runnable);
    }

    @Override
    public void createTables() {
        String[] stringArray = new String[]{"plot", "plot_denied", "plot_helpers", "plot_comments", "plot_trusted", "plot_rating", "plot_settings", "cluster", "player_meta", "plot_flags"};
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        int n = 0;
        for (String string : stringArray) {
            ResultSet resultSet = databaseMetaData.getTables(null, null, this.prefix + string, new String[]{"TABLE"});
            if (!resultSet.next()) {
                ++n;
            }
            resultSet.close();
        }
        if (n == 0) {
            return;
        }
        boolean bl = n == stringArray.length;
        try (Statement statement = this.connection.createStatement();){
            if (this.mySQL) {
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot` (`id` INT(11) NOT NULL AUTO_INCREMENT,`plot_id_x` INT(11) NOT NULL,`plot_id_z` INT(11) NOT NULL,`owner` VARCHAR(40) NOT NULL,`world` VARCHAR(45) NOT NULL,`timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=0");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_denied` (`plot_plot_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_helpers` (`plot_plot_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_comments` (`world` VARCHAR(40) NOT NULL, `hashcode` INT(11) NOT NULL,`comment` VARCHAR(40) NOT NULL,`inbox` VARCHAR(40) NOT NULL,`timestamp` INT(11) NOT NULL,`sender` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_trusted` (`plot_plot_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_settings` (  `plot_plot_id` INT(11) NOT NULL,  `biome` VARCHAR(45) DEFAULT 'FOREST',  `rain` INT(1) DEFAULT 0,  `custom_time` TINYINT(1) DEFAULT '0',  `time` INT(11) DEFAULT '8000',  `deny_entry` TINYINT(1) DEFAULT '0',  `alias` VARCHAR(50) DEFAULT NULL,  `merged` INT(11) DEFAULT NULL,  `position` VARCHAR(50) NOT NULL DEFAULT 'DEFAULT',  PRIMARY KEY (`plot_plot_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_rating` ( `plot_plot_id` INT(11) NOT NULL, `rating` INT(2) NOT NULL, `player` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                if (bl) {
                    statement.addBatch("ALTER TABLE `" + this.prefix + "plot_settings` ADD CONSTRAINT `" + this.prefix + "plot_settings_ibfk_1` FOREIGN KEY (`plot_plot_id`) REFERENCES `" + this.prefix + "plot` (`id`) ON DELETE CASCADE");
                }
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster` (`id` INT(11) NOT NULL AUTO_INCREMENT,`pos1_x` INT(11) NOT NULL,`pos1_z` INT(11) NOT NULL,`pos2_x` INT(11) NOT NULL,`pos2_z` INT(11) NOT NULL,`owner` VARCHAR(40) NOT NULL,`world` VARCHAR(45) NOT NULL,`timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=0");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster_helpers` (`cluster_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster_invited` (`cluster_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster_settings` (  `cluster_id` INT(11) NOT NULL,  `biome` VARCHAR(45) DEFAULT 'FOREST',  `rain` INT(1) DEFAULT 0,  `custom_time` TINYINT(1) DEFAULT '0',  `time` INT(11) DEFAULT '8000',  `deny_entry` TINYINT(1) DEFAULT '0',  `alias` VARCHAR(50) DEFAULT NULL,  `merged` INT(11) DEFAULT NULL,  `position` VARCHAR(50) NOT NULL DEFAULT 'DEFAULT',  PRIMARY KEY (`cluster_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "player_meta` ( `meta_id` INT(11) NOT NULL AUTO_INCREMENT, `uuid` VARCHAR(40) NOT NULL, `key` VARCHAR(32) NOT NULL, `value` blob NOT NULL, PRIMARY KEY (`meta_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_flags`(`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,`plot_id` INT(11) NOT NULL, `flag` VARCHAR(64), `value` VARCHAR(512),FOREIGN KEY (plot_id) REFERENCES `" + this.prefix + "plot` (id) ON DELETE CASCADE, UNIQUE (plot_id, flag)) ENGINE=InnoDB DEFAULT CHARSET=utf8");
            } else {
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot` (`id` INTEGER PRIMARY KEY AUTOINCREMENT,`plot_id_x` INT(11) NOT NULL,`plot_id_z` INT(11) NOT NULL,`owner` VARCHAR(45) NOT NULL,`world` VARCHAR(45) NOT NULL,`timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_denied` (`plot_plot_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_helpers` (`plot_plot_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_trusted` (`plot_plot_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_comments` (`world` VARCHAR(40) NOT NULL, `hashcode` INT(11) NOT NULL,`comment` VARCHAR(40) NOT NULL,`inbox` VARCHAR(40) NOT NULL, `timestamp` INT(11) NOT NULL,`sender` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_settings` (  `plot_plot_id` INT(11) NOT NULL,  `biome` VARCHAR(45) DEFAULT 'FOREST',  `rain` INT(1) DEFAULT 0,  `custom_time` TINYINT(1) DEFAULT '0',  `time` INT(11) DEFAULT '8000',  `deny_entry` TINYINT(1) DEFAULT '0',  `alias` VARCHAR(50) DEFAULT NULL,  `merged` INT(11) DEFAULT NULL,  `position` VARCHAR(50) NOT NULL DEFAULT 'DEFAULT',  PRIMARY KEY (`plot_plot_id`))");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_rating` (`plot_plot_id` INT(11) NOT NULL, `rating` INT(2) NOT NULL, `player` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster` (`id` INTEGER PRIMARY KEY AUTOINCREMENT,`pos1_x` INT(11) NOT NULL,`pos1_z` INT(11) NOT NULL,`pos2_x` INT(11) NOT NULL,`pos2_z` INT(11) NOT NULL,`owner` VARCHAR(40) NOT NULL,`world` VARCHAR(45) NOT NULL,`timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster_helpers` (`cluster_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster_invited` (`cluster_id` INT(11) NOT NULL,`user_uuid` VARCHAR(40) NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "cluster_settings` (  `cluster_id` INT(11) NOT NULL,  `biome` VARCHAR(45) DEFAULT 'FOREST',  `rain` INT(1) DEFAULT 0,  `custom_time` TINYINT(1) DEFAULT '0',  `time` INT(11) DEFAULT '8000',  `deny_entry` TINYINT(1) DEFAULT '0',  `alias` VARCHAR(50) DEFAULT NULL,  `merged` INT(11) DEFAULT NULL,  `position` VARCHAR(50) NOT NULL DEFAULT 'DEFAULT',  PRIMARY KEY (`cluster_id`))");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "player_meta` ( `meta_id` INTEGER PRIMARY KEY AUTOINCREMENT, `uuid` VARCHAR(40) NOT NULL, `key` VARCHAR(32) NOT NULL, `value` blob NOT NULL)");
                statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_flags`(`id` INTEGER PRIMARY KEY AUTOINCREMENT,`plot_id` INTEGER NOT NULL, `flag` VARCHAR(64), `value` VARCHAR(512),FOREIGN KEY (plot_id) REFERENCES `" + this.prefix + "plot` (id) ON DELETE CASCADE, UNIQUE (plot_id, flag))");
            }
            statement.executeBatch();
            statement.clearBatch();
        }
    }

    @Override
    public void deleteSettings(final Plot plot) {
        this.addPlotTask(plot, new UniqueStatement("delete_plot_settings"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_settings` WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void deleteHelpers(final Plot plot) {
        if (plot.getTrusted().isEmpty()) {
            return;
        }
        this.addPlotTask(plot, new UniqueStatement("delete_plot_helpers"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_helpers` WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void deleteTrusted(final Plot plot) {
        if (plot.getMembers().isEmpty()) {
            return;
        }
        this.addPlotTask(plot, new UniqueStatement("delete_plot_trusted"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_trusted` WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void deleteDenied(final Plot plot) {
        if (plot.getDenied().isEmpty()) {
            return;
        }
        this.addPlotTask(plot, new UniqueStatement("delete_plot_denied"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_denied` WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void deleteComments(final Plot plot) {
        this.addPlotTask(plot, new UniqueStatement("delete_plot_comments"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, plot.getArea().toString());
                preparedStatement.setInt(2, plot.hashCode());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_comments` WHERE `world` = ? AND `hashcode` = ?");
            }
        });
    }

    @Override
    public void deleteRatings(final Plot plot) {
        if (Settings.Enabled_Components.RATING_CACHE && plot.getSettings().getRatings().isEmpty()) {
            return;
        }
        this.addPlotTask(plot, new UniqueStatement("delete_plot_ratings"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_rating` WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void delete(final Plot plot) {
        this.deleteSettings(plot);
        this.deleteDenied(plot);
        this.deleteHelpers(plot);
        this.deleteTrusted(plot);
        this.deleteComments(plot);
        this.deleteRatings(plot);
        this.addPlotTask(plot, new UniqueStatement("delete_plot"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot` WHERE `id` = ?");
            }
        });
    }

    @Override
    public void createPlotSettings(final int n, Plot plot) {
        this.addPlotTask(plot, new UniqueStatement("createPlotSettings"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, n);
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_settings`(`plot_plot_id`) VALUES(?)");
            }
        });
    }

    @Override
    public int getClusterId(PlotCluster plotCluster) {
        if (plotCluster.temp > 0) {
            return plotCluster.temp;
        }
        try {
            int n;
            this.commit();
            if (plotCluster.temp > 0) {
                return plotCluster.temp;
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT `id` FROM `" + this.prefix + "cluster` WHERE `pos1_x` = ? AND `pos1_z` = ? AND `pos2_x` = ? AND `pos2_z` = ? AND `world` = ? ORDER BY `timestamp` ASC");){
                preparedStatement.setInt(1, plotCluster.getP1().getX());
                preparedStatement.setInt(2, plotCluster.getP1().getY());
                preparedStatement.setInt(3, plotCluster.getP2().getX());
                preparedStatement.setInt(4, plotCluster.getP2().getY());
                preparedStatement.setString(5, plotCluster.area.toString());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    n = Integer.MAX_VALUE;
                    while (resultSet.next()) {
                        n = resultSet.getInt("id");
                    }
                }
            }
            if (n == Integer.MAX_VALUE || n == 0) {
                if (plotCluster.temp > 0) {
                    return plotCluster.temp;
                }
                throw new SQLException("Cluster does not exist in database");
            }
            plotCluster.temp = n;
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public int getId(Plot plot) {
        if (plot.temp > 0) {
            return plot.temp;
        }
        try {
            int n;
            this.commit();
            if (plot.temp > 0) {
                return plot.temp;
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT `id` FROM `" + this.prefix + "plot` WHERE `plot_id_x` = ? AND `plot_id_z` = ? AND world = ? ORDER BY `timestamp` ASC");){
                preparedStatement.setInt(1, plot.getId().getX());
                preparedStatement.setInt(2, plot.getId().getY());
                preparedStatement.setString(3, plot.getArea().toString());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    n = Integer.MAX_VALUE;
                    while (resultSet.next()) {
                        n = resultSet.getInt("id");
                    }
                }
            }
            if (n == Integer.MAX_VALUE || n == 0) {
                if (plot.temp > 0) {
                    return plot.temp;
                }
                throw new SQLException("Plot does not exist in database");
            }
            plot.temp = n;
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public void updateTables(int[] nArray) {
        block48: {
            try {
                Statement statement;
                ResultSet resultSet;
                Wrapper wrapper;
                if (this.mySQL && !PlotSquared.get().checkVersion(nArray, 3, 3, 2)) {
                    try {
                        wrapper = this.connection.createStatement();
                        try {
                            wrapper.executeUpdate("ALTER TABLE `" + this.prefix + "plots` DROP INDEX `unique_alias`");
                        }
                        finally {
                            if (wrapper != null) {
                                wrapper.close();
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if ((resultSet = (wrapper = this.connection.getMetaData()).getColumns(null, null, this.prefix + "plot_comments", "plot_plot_id")).next()) {
                    resultSet.close();
                    resultSet = wrapper.getColumns(null, null, this.prefix + "plot_comments", "hashcode");
                    if (!resultSet.next()) {
                        resultSet.close();
                        try {
                            statement = this.connection.createStatement();
                            try {
                                statement.addBatch("DROP TABLE `" + this.prefix + "plot_comments`");
                                if (Storage.MySQL.USE) {
                                    statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_comments` (`world` VARCHAR(40) NOT NULL, `hashcode` INT(11) NOT NULL,`comment` VARCHAR(40) NOT NULL,`inbox` VARCHAR(40) NOT NULL,`timestamp` INT(11) NOT NULL,`sender` VARCHAR(40) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                                } else {
                                    statement.addBatch("CREATE TABLE IF NOT EXISTS `" + this.prefix + "plot_comments` (`world` VARCHAR(40) NOT NULL, `hashcode` INT(11) NOT NULL,`comment` VARCHAR(40) NOT NULL,`inbox` VARCHAR(40) NOT NULL, `timestamp` INT(11) NOT NULL,`sender` VARCHAR(40) NOT NULL)");
                                }
                                statement.executeBatch();
                            }
                            finally {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            try (String[] stringArray = this.connection.createStatement();){
                                stringArray.addBatch("ALTER IGNORE TABLE `" + this.prefix + "plot_comments` ADD `inbox` VARCHAR(11) DEFAULT `public`");
                                stringArray.addBatch("ALTER IGNORE TABLE `" + this.prefix + "plot_comments` ADD `timestamp` INT(11) DEFAULT 0");
                                stringArray.addBatch("ALTER TABLE `" + this.prefix + "plot` DROP `tier`");
                                stringArray.executeBatch();
                            }
                        }
                    }
                }
                resultSet.close();
                resultSet = wrapper.getColumns(null, null, this.prefix + "plot_denied", "plot_plot_id");
                if (!resultSet.next()) break block48;
                try {
                    statement = this.connection.createStatement();
                    try {
                        statement.executeUpdate("DELETE FROM `" + this.prefix + "plot_denied` WHERE `plot_plot_id` NOT IN (SELECT `id` FROM `" + this.prefix + "plot`)");
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                resultSet.close();
                try {
                    statement = this.connection.createStatement();
                    try {
                        for (String string : new String[]{"plot_denied", "plot_helpers", "plot_trusted"}) {
                            ResultSet resultSet2 = statement.executeQuery("SELECT plot_plot_id, user_uuid, COUNT(*) FROM " + this.prefix + string + " GROUP BY plot_plot_id, user_uuid HAVING COUNT(*) > 1");
                            if (!resultSet2.next()) continue;
                            resultSet2.close();
                            statement.executeUpdate("CREATE TABLE " + this.prefix + string + "_tmp AS SELECT * FROM " + this.prefix + string + " GROUP BY plot_plot_id, user_uuid");
                            statement.executeUpdate("DROP TABLE " + this.prefix + string);
                            statement.executeUpdate("CREATE TABLE " + this.prefix + string + " AS SELECT * FROM " + this.prefix + string + "_tmp");
                            statement.executeUpdate("DROP TABLE " + this.prefix + string + "_tmp");
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void deleteRows(ArrayList<Integer> arrayList, final String string, final String string2) {
        this.setBulk(arrayList, new StmtMod<Integer>(){

            @Override
            public String getCreateMySQL(int n) {
                return this.getCreateMySQL(1, "DELETE FROM `" + string + "` WHERE `" + string2 + "` IN ", n);
            }

            @Override
            public String getCreateSQLite(int n) {
                return this.getCreateMySQL(1, "DELETE FROM `" + string + "` WHERE `" + string2 + "` IN ", n);
            }

            @Override
            public String getCreateSQL() {
                return "DELETE FROM `" + string + "` WHERE `" + string2 + "` = ?";
            }

            @Override
            public void setMySQL(PreparedStatement preparedStatement, int n, Integer n2) {
                preparedStatement.setInt(n + 1, n2);
            }

            @Override
            public void setSQLite(PreparedStatement preparedStatement, int n, Integer n2) {
                preparedStatement.setInt(n + 1, n2);
            }

            @Override
            public void setSQL(PreparedStatement preparedStatement, Integer n) {
                preparedStatement.setInt(1, n);
            }
        }, null);
    }

    @Override
    public boolean convertFlags() {
        Statement statement;
        HashMap hashMap = new HashMap();
        try {
            statement = this.connection.createStatement();
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM `" + this.prefix + "plot_settings`");){
                while (resultSet.next()) {
                    int n = resultSet.getInt("plot_plot_id");
                    String string = resultSet.getString("flags");
                    if (string == null || string.isEmpty()) continue;
                    hashMap.put(n, new HashMap());
                    for (String object : string.split(",")) {
                        if (!object.contains(":")) continue;
                        String[] stringArray = object.split(":");
                        try {
                            String string2 = stringArray[1].replaceAll("\u00af", ":").replaceAll("\u00b4", ",");
                            ((Map)hashMap.get(n)).put(stringArray[0], string2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load old flag values", (Throwable)exception);
            return false;
        }
        LOGGER.info("Loaded {} plot flag collections...", (Object)hashMap.size());
        LOGGER.info("Attempting to store these flags in the new table...");
        try {
            statement = this.connection.prepareStatement("INSERT INTO `" + this.prefix + "plot_flags`(`plot_id`, `flag`, `value`) VALUES(?, ?, ?)");
            try {
                long l = System.currentTimeMillis();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                for (Map map : hashMap.values()) {
                    n3 += map.size();
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        statement.setInt(1, (Integer)entry.getKey());
                        statement.setString(2, (String)entry2.getKey());
                        statement.setString(3, (String)entry2.getValue());
                        statement.addBatch();
                        ++n;
                    }
                    ++n2;
                    try {
                        statement.executeBatch();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to store flag values for plot with entry ID: {}", entry.getKey());
                        exception.printStackTrace();
                        continue;
                    }
                    if (System.currentTimeMillis() - l >= 1000L || n2 >= hashMap.size()) {
                        l = System.currentTimeMillis();
                        LOGGER.info("... Flag conversion in progress. {}% done", (Object)String.format("%.1f", Float.valueOf((float)n / (float)n3 * 100.0f)));
                    }
                    LOGGER.info("- Finished converting flags for plot with entry ID: {}", entry.getKey());
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to store flag values", (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public HashMap<String, HashMap<PlotId, Plot>> getPlots() {
        HashMap<String, HashMap<PlotId, Plot>> hashMap = new HashMap<String, HashMap<PlotId, Plot>>();
        HashMap<Integer, PlotFlag> hashMap2 = new HashMap<Integer, PlotFlag>();
        try {
            boolean bl;
            Object object;
            Object object22;
            Object object4;
            HashSet<Object> hashSet = new HashSet<Object>();
            if (this.worldConfiguration.contains("worlds") && (object4 = this.worldConfiguration.getConfigurationSection("worlds")) != null) {
                for (String iterator2 : object4.getKeys(false)) {
                    hashSet.add(iterator2);
                    ConfigurationSection n = object4.getConfigurationSection(iterator2 + ".areas");
                    if (n == null) continue;
                    for (Object object22 : n.getKeys(false)) {
                        object = ((String)object22).split("(?<![;])-");
                        if (((String[])object).length != 3) continue;
                        hashSet.add(iterator2 + ";" + object[0]);
                    }
                }
            }
            object4 = new HashMap();
            HashMap hashMap3 = new HashMap();
            try (Statement bl2 = this.connection.createStatement();){
                Object object32;
                Object object5;
                Object object6;
                ArrayList<Integer> arrayList;
                object = bl2.executeQuery("SELECT `id`, `plot_id_x`, `plot_id_z`, `owner`, `world`, `timestamp` FROM `" + this.prefix + "plot`");
                try {
                    arrayList = new ArrayList<Integer>();
                    while (object.next()) {
                        HashMap<PlotId, PlotFlag> hashMap4;
                        long l;
                        String string;
                        object6 = PlotId.of(object.getInt("plot_id_x"), object.getInt("plot_id_z"));
                        int n = object.getInt("id");
                        object5 = object.getString("world");
                        if (!hashSet.contains(object5)) {
                            if (Settings.Enabled_Components.DATABASE_PURGER) {
                                arrayList.add(n);
                                continue;
                            }
                            AtomicInteger atomicInteger = (AtomicInteger)hashMap3.get(object5);
                            if (atomicInteger != null) {
                                atomicInteger.incrementAndGet();
                            } else {
                                hashMap3.put(object5, new AtomicInteger(1));
                            }
                        }
                        if ((object22 = (UUID)((HashMap)object4).get(string = object.getString("owner"))) == null) {
                            try {
                                object22 = UUID.fromString(string);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                object22 = Settings.UUID.FORCE_LOWERCASE ? UUID.nameUUIDFromBytes(("OfflinePlayer:" + string.toLowerCase()).getBytes(Charsets.UTF_8)) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + string).getBytes(Charsets.UTF_8));
                            }
                            ((HashMap)object4).put(string, object22);
                        }
                        try {
                            object32 = object.getTimestamp("timestamp");
                            l = ((Timestamp)object32).getTime();
                        }
                        catch (SQLException sQLException) {
                            hashMap4 = object.getString("timestamp");
                            try {
                                l = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)((Object)hashMap4)).getTime();
                            }
                            catch (ParseException parseException) {
                                LOGGER.error("Could not parse date for plot: #{}({};{}) ({})", (Object)n, object5, object6, (Object)hashMap4);
                                l = System.currentTimeMillis() + (long)n;
                            }
                        }
                        object32 = new Plot((PlotId)object6, (UUID)object22, new HashSet<UUID>(), new HashSet<UUID>(), new HashSet<UUID>(), "", null, null, null, new boolean[]{false, false, false, false}, l, n);
                        hashMap4 = hashMap.get(object5);
                        if (hashMap4 != null) {
                            Plot plot = (Plot)hashMap4.put(((Plot)object32).getId(), (PlotFlag)object32);
                            if (plot != null) {
                                if (Settings.Enabled_Components.DATABASE_PURGER) {
                                    arrayList.add(plot.temp);
                                } else {
                                    LOGGER.info("Plot #{}({}) in `{}plot` is a duplicate. Delete this plot or set `database-purger: true` in the settings.yml", (Object)n, (Object)plot, (Object)this.prefix);
                                }
                            }
                        } else {
                            hashMap4 = new HashMap<PlotId, PlotFlag>();
                            hashMap.put((String)object5, hashMap4);
                            hashMap4.put(((Plot)object32).getId(), (PlotFlag)object32);
                        }
                        hashMap2.put(n, (PlotFlag)object32);
                    }
                    this.deleteRows(arrayList, this.prefix + "plot", "id");
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                if (Settings.Enabled_Components.RATING_CACHE) {
                    object = bl2.executeQuery("SELECT `plot_plot_id`, `player`, `rating` FROM `" + this.prefix + "plot_rating`");
                    try {
                        arrayList = new ArrayList();
                        while (object.next()) {
                            int n = object.getInt("plot_plot_id");
                            String string = object.getString("player");
                            object22 = (UUID)((HashMap)object4).get(string);
                            if (object22 == null) {
                                object22 = UUID.fromString(string);
                                ((HashMap)object4).put(string, object22);
                            }
                            if ((object6 = (Plot)hashMap2.get(n)) != null) {
                                ((Plot)object6).getSettings().getRatings().put((UUID)object22, object.getInt("rating"));
                                continue;
                            }
                            if (Settings.Enabled_Components.DATABASE_PURGER) {
                                arrayList.add(n);
                                continue;
                            }
                            LOGGER.warn("Entry #{}({}) in `plot_rating` does not exist. Create this plot or set `database-purger: true` in settings.yml", (Object)n, object6);
                        }
                        this.deleteRows(arrayList, this.prefix + "plot_rating", "plot_plot_id");
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                object = bl2.executeQuery("SELECT `user_uuid`, `plot_plot_id` FROM `" + this.prefix + "plot_helpers`");
                try {
                    arrayList = new ArrayList();
                    while (object.next()) {
                        int n = object.getInt("plot_plot_id");
                        String string = object.getString("user_uuid");
                        object22 = (UUID)((HashMap)object4).get(string);
                        if (object22 == null) {
                            object22 = UUID.fromString(string);
                            ((HashMap)object4).put(string, object22);
                        }
                        if ((object6 = (Plot)hashMap2.get(n)) != null) {
                            ((Plot)object6).getTrusted().add((UUID)object22);
                            continue;
                        }
                        if (Settings.Enabled_Components.DATABASE_PURGER) {
                            arrayList.add(n);
                            continue;
                        }
                        LOGGER.warn("Entry #{}({}) in `plot_helpers` does not exist. Create this plot or set `database-purger: true` in settings.yml", (Object)n, object6);
                    }
                    this.deleteRows(arrayList, this.prefix + "plot_helpers", "plot_plot_id");
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                object = bl2.executeQuery("SELECT `user_uuid`, `plot_plot_id` FROM `" + this.prefix + "plot_trusted`");
                try {
                    arrayList = new ArrayList();
                    while (object.next()) {
                        int n = object.getInt("plot_plot_id");
                        String string = object.getString("user_uuid");
                        object22 = (UUID)((HashMap)object4).get(string);
                        if (object22 == null) {
                            object22 = UUID.fromString(string);
                            ((HashMap)object4).put(string, object22);
                        }
                        if ((object6 = (Plot)hashMap2.get(n)) != null) {
                            ((Plot)object6).getMembers().add((UUID)object22);
                            continue;
                        }
                        if (Settings.Enabled_Components.DATABASE_PURGER) {
                            arrayList.add(n);
                            continue;
                        }
                        LOGGER.warn("Entry #{}({}) in `plot_trusted` does not exist. Create this plot or set `database-purger: true` in settings.yml", (Object)n, object6);
                    }
                    this.deleteRows(arrayList, this.prefix + "plot_trusted", "plot_plot_id");
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                object = bl2.executeQuery("SELECT `user_uuid`, `plot_plot_id` FROM `" + this.prefix + "plot_denied`");
                try {
                    arrayList = new ArrayList();
                    while (object.next()) {
                        int entry = object.getInt("plot_plot_id");
                        String string = object.getString("user_uuid");
                        object22 = (UUID)((HashMap)object4).get(string);
                        if (object22 == null) {
                            object22 = UUID.fromString(string);
                            ((HashMap)object4).put(string, object22);
                        }
                        if ((object6 = (Plot)hashMap2.get(entry)) != null) {
                            ((Plot)object6).getDenied().add((UUID)object22);
                            continue;
                        }
                        if (Settings.Enabled_Components.DATABASE_PURGER) {
                            arrayList.add(entry);
                            continue;
                        }
                        LOGGER.warn("Entry #{}({}) in `plot_denied` does not exist. Create this plot or set `database-purger: true` in settings.yml", (Object)entry, object6);
                    }
                    this.deleteRows(arrayList, this.prefix + "plot_denied", "plot_plot_id");
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                object = bl2.executeQuery("SELECT * FROM `" + this.prefix + "plot_flags`");
                try {
                    BlockTypeListFlag.skipCategoryVerification = true;
                    arrayList = new ArrayList();
                    object6 = new HashMap();
                    while (object.next()) {
                        int n = object.getInt("plot_id");
                        object5 = object.getString("flag");
                        String string = object.getString("value");
                        Plot plot = (Plot)hashMap2.get(n);
                        if (plot != null) {
                            object32 = GlobalFlagContainer.getInstance().getFlagFromString((String)object5);
                            if (object32 == null) {
                                plot.getFlagContainer().addUnknownFlag((String)object5, string);
                                continue;
                            }
                            String string2 = CaptionUtility.stripClickEvents(object32, string);
                            try {
                                plot.getFlagContainer().addFlag(((PlotFlag)object32).parse(string2));
                            }
                            catch (FlagParseException flagParseException) {
                                flagParseException.printStackTrace();
                                LOGGER.error("Plot with ID {} has an invalid value:", (Object)n);
                                LOGGER.error("Failed to parse flag '{}', value '{}': {}", (Object)((PlotFlag)object32).getName(), (Object)flagParseException.getValue(), (Object)flagParseException.getErrorMessage());
                                if (!object6.containsKey(plot)) {
                                    object6.put(plot, new ArrayList());
                                }
                                ((Collection)object6.get(plot)).add(object32);
                            }
                            continue;
                        }
                        if (Settings.Enabled_Components.DATABASE_PURGER) {
                            arrayList.add(n);
                            continue;
                        }
                        LOGGER.warn("Entry #{}({}) in `plot_flags` does not exist. Create this plot or set `database-purger: true` in settings.yml", (Object)n, (Object)plot);
                    }
                    BlockTypeListFlag.skipCategoryVerification = false;
                    if (Settings.Enabled_Components.DATABASE_PURGER) {
                        for (Map.Entry entry : object6.entrySet()) {
                            for (Object object32 : (Collection)entry.getValue()) {
                                LOGGER.info("Plot {} has an invalid flag ({}). A fix has been attempted", entry.getKey(), (Object)((PlotFlag)object32).getName());
                                this.removeFlag((Plot)entry.getKey(), (PlotFlag<?, ?>)object32);
                            }
                        }
                    }
                    this.deleteRows(arrayList, this.prefix + "plot_flags", "plot_id");
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                object = bl2.executeQuery("SELECT * FROM `" + this.prefix + "plot_settings`");
                try {
                    arrayList = new ArrayList();
                    while (object.next()) {
                        int n = object.getInt("plot_plot_id");
                        object6 = (Plot)hashMap2.get(n);
                        if (object6 != null) {
                            hashMap2.remove(n);
                            object5 = object.getString("alias");
                            if (object5 != null) {
                                ((Plot)object6).getSettings().setAlias((String)object5);
                            }
                            String string = object.getString("position");
                            switch (string.toLowerCase()) {
                                case "": 
                                case "default": 
                                case "0,0,0": 
                                case "center": 
                                case "centre": {
                                    break;
                                }
                                default: {
                                    try {
                                        ((Plot)object6).getSettings().setPosition(BlockLoc.fromString(string));
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            int n2 = object.getInt("merged");
                            object32 = new boolean[4];
                            for (int i = 0; i < 4; ++i) {
                                object32[3 - i] = (n2 & 1 << i) != 0;
                            }
                            ((Plot)object6).getSettings().setMerged((boolean[])object32);
                            continue;
                        }
                        if (Settings.Enabled_Components.DATABASE_PURGER) {
                            arrayList.add(n);
                            continue;
                        }
                        LOGGER.warn("Entry #{}({}) in `plot_settings` does not exist. Create this plot or set `database-purger: true` in settings.yml", (Object)n, object6);
                    }
                    this.deleteRows(arrayList, this.prefix + "plot_settings", "plot_plot_id");
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            if (!hashMap2.entrySet().isEmpty()) {
                this.createEmptySettings(new ArrayList<Integer>(hashMap2.keySet()), null);
                for (Map.Entry entry : hashMap2.entrySet()) {
                    ((Plot)entry.getValue()).getSettings();
                }
            }
            boolean bl3 = false;
            for (Map.Entry entry : hashMap3.entrySet()) {
                object22 = (String)entry.getKey();
                bl = true;
                if (!Settings.DEBUG) continue;
                LOGGER.info("Warning! Found {} plots in DB for non existent world: '{}'", (Object)((AtomicInteger)entry.getValue()).intValue(), object22);
            }
            if (bl && Settings.DEBUG) {
                LOGGER.info("Warning! Please create the world(s) or remove the plots using the purge command");
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("Failed to load plots", (Throwable)sQLException);
        }
        return hashMap;
    }

    @Override
    public void setMerged(final Plot plot, final boolean[] blArray) {
        plot.getSettings().setMerged(blArray);
        this.addPlotTask(plot, new UniqueStatement("setMerged"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                int n = HashUtil.hash(blArray);
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "plot_settings` SET `merged` = ? WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> swapPlots(Plot plot, Plot plot2) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        TaskManager.runTaskAsync(() -> {
            int n = this.getId(plot);
            int n2 = this.getId(plot2);
            PlotId plotId = plot.getId();
            PlotId plotId2 = plot2.getId();
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE `" + this.prefix + "plot` SET `plot_id_x` = ?, `plot_id_z` = ? WHERE `id` = ?");){
                preparedStatement.setInt(1, plotId.getX());
                preparedStatement.setInt(2, plotId.getY());
                preparedStatement.setInt(3, n);
                preparedStatement.execute();
                preparedStatement.setInt(1, plotId2.getX());
                preparedStatement.setInt(2, plotId2.getY());
                preparedStatement.setInt(3, n2);
                preparedStatement.execute();
            }
            catch (Exception exception) {
                LOGGER.error("Failed to persist wap of {} and {}", (Object)plot, (Object)plot2);
                exception.printStackTrace();
                completableFuture.complete(false);
                return;
            }
            completableFuture.complete(true);
        });
        return completableFuture;
    }

    @Override
    public void movePlot(final Plot plot, final Plot plot2) {
        this.addPlotTask(plot, new UniqueStatement("movePlot"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, plot2.getId().getX());
                preparedStatement.setInt(2, plot2.getId().getY());
                preparedStatement.setString(3, plot2.getArea().toString());
                preparedStatement.setInt(4, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "plot` SET `plot_id_x` = ?, `plot_id_z` = ?, `world` = ? WHERE `id` = ?");
            }
        });
        this.addPlotTask(plot2, null);
    }

    @Override
    public void setFlag(final Plot plot, final PlotFlag<?, ?> plotFlag) {
        this.addPlotTask(plot, new UniqueStatement("setFlag"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, plotFlag.getName());
                preparedStatement.setString(3, plotFlag.toString());
                preparedStatement.setString(4, plotFlag.toString());
            }

            @Override
            public PreparedStatement get() {
                String string = SQLManager.this.mySQL ? "INSERT INTO `" + SQLManager.this.prefix + "plot_flags`(`plot_id`, `flag`, `value`) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE `value` = ?" : "INSERT INTO `" + SQLManager.this.prefix + "plot_flags`(`plot_id`, `flag`, `value`) VALUES(?, ?, ?) ON CONFLICT(`plot_id`,`flag`) DO UPDATE SET `value` = ?";
                return SQLManager.this.connection.prepareStatement(string);
            }
        });
    }

    @Override
    public void removeFlag(final Plot plot, final PlotFlag<?, ?> plotFlag) {
        this.addPlotTask(plot, new UniqueStatement("removeFlag"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, plotFlag.getName());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_flags` WHERE `plot_id` = ? AND `flag` = ?");
            }
        });
    }

    @Override
    public void setAlias(final Plot plot, final String string) {
        this.addPlotTask(plot, new UniqueStatement("setAlias"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "plot_settings` SET `alias` = ?  WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void purgeIds(Set<Integer> set) {
        this.addGlobalTask(() -> {
            if (!set.isEmpty()) {
                try {
                    List list;
                    ArrayList arrayList = new ArrayList(set);
                    int n = arrayList.size();
                    int n2 = 990;
                    int n3 = n / n2;
                    for (int i = 0; i <= n3 && !(list = arrayList.subList(i * n2, Math.min(n, (i + 1) * n2))).isEmpty(); ++i) {
                        Object object2;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = "";
                        for (Object object2 : list) {
                            stringBuilder.append(string).append(object2);
                            string = " OR `id` = ";
                        }
                        string = "";
                        StringBuilder stringBuilder2 = new StringBuilder();
                        for (Integer n4 : list) {
                            stringBuilder2.append(string).append(n4);
                            string = " OR `plot_plot_id` = ";
                        }
                        object2 = this.connection.prepareStatement("DELETE FROM `" + this.prefix + "plot_helpers` WHERE `plot_plot_id` = " + (StringBuilder)stringBuilder2);
                        object2.executeUpdate();
                        object2.close();
                        object2 = this.connection.prepareStatement("DELETE FROM `" + this.prefix + "plot_denied` WHERE `plot_plot_id` = " + (StringBuilder)stringBuilder2);
                        object2.executeUpdate();
                        object2.close();
                        object2 = this.connection.prepareStatement("DELETE FROM `" + this.prefix + "plot_settings` WHERE `plot_plot_id` = " + (StringBuilder)stringBuilder2);
                        object2.executeUpdate();
                        object2.close();
                        object2 = this.connection.prepareStatement("DELETE FROM `" + this.prefix + "plot_trusted` WHERE `plot_plot_id` = " + (StringBuilder)stringBuilder2);
                        object2.executeUpdate();
                        object2.close();
                        object2 = this.connection.prepareStatement("DELETE FROM `" + this.prefix + "plot` WHERE `id` = " + stringBuilder);
                        object2.executeUpdate();
                        object2.close();
                        this.commit();
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.error("Failed to purge plots", (Throwable)sQLException);
                    return;
                }
            }
            LOGGER.info("Successfully purged {} plots", (Object)set.size());
        });
    }

    @Override
    public void purge(PlotArea plotArea, Set<PlotId> set) {
        this.addGlobalTask(() -> {
            Object object;
            Object object2;
            Object object3;
            try {
                object3 = this.connection.prepareStatement("SELECT `id`, `plot_id_x`, `plot_id_z` FROM `" + this.prefix + "plot` WHERE `world` = ?");
                try {
                    object3.setString(1, plotArea.toString());
                    object2 = object3.executeQuery();
                    try {
                        object = new HashSet();
                        while (object2.next()) {
                            PlotId plotId = PlotId.of(object2.getInt("plot_id_x"), object2.getInt("plot_id_z"));
                            if (!set.contains(plotId)) continue;
                            object.add(object2.getInt("id"));
                        }
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                    this.purgeIds((Set<Integer>)object);
                }
                finally {
                    if (object3 != null) {
                        object3.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                LOGGER.error("Failed to purge area '{}'", (Object)plotArea);
                sQLException.printStackTrace();
            }
            object3 = set.iterator();
            while (object3.hasNext()) {
                object = (PlotId)object3.next();
                object3.remove();
                object2 = PlotId.of(((PlotId)object).getX(), ((PlotId)object).getY());
                plotArea.removePlot((PlotId)object2);
            }
        });
    }

    @Override
    public void setPosition(final Plot plot, final String string) {
        this.addPlotTask(plot, new UniqueStatement("setPosition"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, string == null ? "" : string);
                preparedStatement.setInt(2, SQLManager.this.getId(plot));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "plot_settings` SET `position` = ?  WHERE `plot_plot_id` = ?");
            }
        });
    }

    @Override
    public void removeComment(final Plot plot, final PlotComment plotComment) {
        this.addPlotTask(plot, new UniqueStatement("removeComment"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                if (plot != null) {
                    preparedStatement.setString(1, plot.getArea().toString());
                    preparedStatement.setInt(2, plot.getId().hashCode());
                    preparedStatement.setString(3, plotComment.comment());
                    preparedStatement.setString(4, plotComment.inbox());
                    preparedStatement.setString(5, plotComment.senderName());
                } else {
                    preparedStatement.setString(1, plotComment.comment());
                    preparedStatement.setString(2, plotComment.inbox());
                    preparedStatement.setString(3, plotComment.senderName());
                }
            }

            @Override
            public PreparedStatement get() {
                if (plot != null) {
                    return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_comments` WHERE `world` = ? AND `hashcode` = ? AND `comment` = ? AND `inbox` = ? AND `sender` = ?");
                }
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_comments` WHERE `comment` = ? AND `inbox` = ? AND `sender` = ?");
            }
        });
    }

    @Override
    public void clearInbox(final Plot plot, final String string) {
        this.addPlotTask(plot, new UniqueStatement("clearInbox"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                if (plot != null) {
                    preparedStatement.setString(1, plot.getArea().toString());
                    preparedStatement.setInt(2, plot.getId().hashCode());
                    preparedStatement.setString(3, string);
                } else {
                    preparedStatement.setString(1, string);
                }
            }

            @Override
            public PreparedStatement get() {
                if (plot != null) {
                    return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_comments` WHERE `world` = ? AND `hashcode` = ? AND `inbox` = ?");
                }
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_comments` `inbox` = ?");
            }
        });
    }

    @Override
    public void getComments(final @NonNull Plot plot, final String string, final RunnableVal<List<PlotComment>> runnableVal) {
        this.addPlotTask(plot, new UniqueStatement("getComments_" + plot){

            @Override
            public void set(PreparedStatement preparedStatement) {
                if (plot != null) {
                    preparedStatement.setString(1, plot.getArea().toString());
                    preparedStatement.setInt(2, plot.getId().hashCode());
                    preparedStatement.setString(3, string);
                } else {
                    preparedStatement.setString(1, string);
                }
            }

            @Override
            public PreparedStatement get() {
                if (plot != null) {
                    return SQLManager.this.connection.prepareStatement("SELECT * FROM `" + SQLManager.this.prefix + "plot_comments` WHERE `world` = ? AND `hashcode` = ? AND `inbox` = ?");
                }
                return SQLManager.this.connection.prepareStatement("SELECT * FROM `" + SQLManager.this.prefix + "plot_comments` WHERE `inbox` = ?");
            }

            @Override
            public void execute(PreparedStatement preparedStatement) {
            }

            @Override
            public void addBatch(PreparedStatement preparedStatement) {
                ArrayList<PlotComment> arrayList = new ArrayList<PlotComment>();
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("sender");
                        String string2 = resultSet.getString("world");
                        int n = resultSet.getInt("hashcode");
                        PlotId plotId = n != 0 ? PlotId.unpair(n) : null;
                        String string3 = resultSet.getString("comment");
                        long l = resultSet.getInt("timestamp") * 1000;
                        PlotComment plotComment = new PlotComment(string2, plotId, string3, string4, string, l);
                        arrayList.add(plotComment);
                    }
                    runnableVal.value = arrayList;
                }
                TaskManager.runTask(runnableVal);
            }
        });
    }

    @Override
    public void setComment(final Plot plot, final PlotComment plotComment) {
        this.addPlotTask(plot, new UniqueStatement("setComment"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, plot.getArea().toString());
                preparedStatement.setInt(2, plot.getId().hashCode());
                preparedStatement.setString(3, plotComment.comment());
                preparedStatement.setString(4, plotComment.inbox());
                preparedStatement.setInt(5, (int)(plotComment.timestamp() / 1000L));
                preparedStatement.setString(6, plotComment.senderName());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_comments` (`world`, `hashcode`, `comment`, `inbox`, `timestamp`, `sender`) VALUES(?,?,?,?,?,?)");
            }
        });
    }

    @Override
    public void removeTrusted(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("removeTrusted"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_helpers` WHERE `plot_plot_id` = ? AND `user_uuid` = ?");
            }
        });
    }

    @Override
    public void removeMember(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("removeMember"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_trusted` WHERE `plot_plot_id` = ? AND `user_uuid` = ?");
            }
        });
    }

    @Override
    public void setTrusted(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("setTrusted"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_helpers` (`plot_plot_id`, `user_uuid`) VALUES(?,?)");
            }
        });
    }

    @Override
    public void setMember(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("setMember"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_trusted` (`plot_plot_id`, `user_uuid`) VALUES(?,?)");
            }
        });
    }

    @Override
    public void removeDenied(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("removeDenied"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "plot_denied` WHERE `plot_plot_id` = ? AND `user_uuid` = ?");
            }
        });
    }

    @Override
    public void setDenied(final Plot plot, final UUID uUID) {
        this.addPlotTask(plot, new UniqueStatement("setDenied"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_denied` (`plot_plot_id`, `user_uuid`) VALUES(?,?)");
            }
        });
    }

    @Override
    public HashMap<UUID, Integer> getRatings(Plot plot) {
        HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT `rating`, `player` FROM `" + this.prefix + "plot_rating` WHERE `plot_plot_id` = ? ");){
            preparedStatement.setInt(1, this.getId(plot));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    UUID uUID = UUID.fromString(resultSet.getString("player"));
                    int n = resultSet.getInt("rating");
                    hashMap.put(uUID, n);
                }
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("Failed to fetch rating for plot {}", (Object)plot.getId().toString());
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    @Override
    public void setRating(final Plot plot, final UUID uUID, final int n) {
        this.addPlotTask(plot, new UniqueStatement("setRating"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getId(plot));
                preparedStatement.setInt(2, n);
                preparedStatement.setString(3, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "plot_rating` (`plot_plot_id`, `rating`, `player`) VALUES(?,?,?)");
            }
        });
    }

    @Override
    public void delete(PlotCluster plotCluster) {
        final int n = this.getClusterId(plotCluster);
        this.addClusterTask(plotCluster, new UniqueStatement("delete_cluster_settings"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, n);
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "cluster_settings` WHERE `cluster_id` = ?");
            }
        });
        this.addClusterTask(plotCluster, new UniqueStatement("delete_cluster_helpers"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, n);
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "cluster_helpers` WHERE `cluster_id` = ?");
            }
        });
        this.addClusterTask(plotCluster, new UniqueStatement("delete_cluster_invited"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, n);
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "cluster_invited` WHERE `cluster_id` = ?");
            }
        });
        this.addClusterTask(plotCluster, new UniqueStatement("delete_cluster"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, n);
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "cluster` WHERE `id` = ?");
            }
        });
    }

    @Override
    public void addPersistentMeta(final UUID uUID, final String string, final byte[] byArray, final boolean bl) {
        this.addPlayerTask(uUID, new UniqueStatement("addPersistentMeta"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                if (bl) {
                    preparedStatement.setBytes(1, byArray);
                    preparedStatement.setString(2, uUID.toString());
                    preparedStatement.setString(3, string);
                } else {
                    preparedStatement.setString(1, uUID.toString());
                    preparedStatement.setString(2, string);
                    preparedStatement.setBytes(3, byArray);
                }
            }

            @Override
            public PreparedStatement get() {
                if (bl) {
                    return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "player_meta` SET `value` = ? WHERE `uuid` = ? AND `key` = ?");
                }
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "player_meta`(`uuid`, `key`, `value`) VALUES(?, ? ,?)");
            }
        });
    }

    @Override
    public void removePersistentMeta(final UUID uUID, final String string) {
        this.addPlayerTask(uUID, new UniqueStatement("removePersistentMeta"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setString(2, string);
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "player_meta` WHERE `uuid` = ? AND `key` = ?");
            }
        });
    }

    @Override
    public void getPersistentMeta(final UUID uUID, final RunnableVal<Map<String, byte[]>> runnableVal) {
        this.addPlayerTask(uUID, new UniqueStatement("getPersistentMeta"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("SELECT * FROM `" + SQLManager.this.prefix + "player_meta` WHERE `uuid` = ? ORDER BY `meta_id` ASC");
            }

            @Override
            public void execute(PreparedStatement preparedStatement) {
            }

            @Override
            public void addBatch(PreparedStatement preparedStatement) {
                ResultSet resultSet = preparedStatement.executeQuery();
                HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                while (resultSet.next()) {
                    String string = resultSet.getString("key");
                    byte[] byArray = resultSet.getBytes("value");
                    hashMap.put(string, byArray);
                }
                resultSet.close();
                TaskManager.runTaskAsync(() -> runnableVal.run(hashMap));
            }
        });
    }

    @Override
    public HashMap<String, Set<PlotCluster>> getClusters() {
        LinkedHashMap<String, Set<PlotCluster>> linkedHashMap = new LinkedHashMap<String, Set<PlotCluster>>();
        HashMap<Integer, PlotCluster> hashMap = new HashMap<Integer, PlotCluster>();
        try {
            boolean bl;
            Object object;
            String string22;
            Object object2;
            Object object5;
            HashSet<Object> hashSet = new HashSet<Object>();
            if (this.worldConfiguration.contains("worlds") && (object5 = this.worldConfiguration.getConfigurationSection("worlds")) != null) {
                for (String object42 : object5.getKeys(false)) {
                    hashSet.add(object42);
                    object2 = object5.getConfigurationSection(object42 + ".areas");
                    if (object2 == null) continue;
                    for (String string22 : object2.getKeys(false)) {
                        object = string22.split("(?<![;])-");
                        if (((String[])object).length != 3) continue;
                        hashSet.add(object42 + ";" + object[0]);
                    }
                }
            }
            object5 = new HashMap();
            HashMap hashMap2 = new HashMap();
            try (Statement bl2 = this.connection.createStatement();){
                Object object3;
                int n;
                Object object4;
                Object object6;
                object2 = bl2.executeQuery("SELECT * FROM `" + this.prefix + "cluster`");
                while (object2.next()) {
                    object6 = PlotId.of(object2.getInt("pos1_x"), object2.getInt("pos1_z"));
                    object4 = PlotId.of(object2.getInt("pos2_x"), object2.getInt("pos2_z"));
                    n = object2.getInt("id");
                    String string3 = object2.getString("world");
                    if (!hashSet.contains(string3)) {
                        hashMap2.merge(string3, 1, Integer::sum);
                    }
                    if ((object = (UUID)((HashMap)object5).get(string22 = object2.getString("owner"))) == null) {
                        object = UUID.fromString(string22);
                        ((HashMap)object5).put(string22, object);
                    }
                    PlotCluster plotCluster = new PlotCluster(null, (PlotId)object6, (PlotId)object4, (UUID)object, n);
                    hashMap.put(n, plotCluster);
                    object3 = linkedHashMap.computeIfAbsent(string3, string -> new HashSet());
                    object3.add(plotCluster);
                }
                object2 = bl2.executeQuery("SELECT `user_uuid`, `cluster_id` FROM `" + this.prefix + "cluster_helpers`");
                while (object2.next()) {
                    PlotCluster plotCluster;
                    n = object2.getInt("cluster_id");
                    string22 = object2.getString("user_uuid");
                    object = (String[])((HashMap)object5).get(string22);
                    if (object == null) {
                        object = UUID.fromString(string22);
                        ((HashMap)object5).put(string22, object);
                    }
                    if ((plotCluster = (PlotCluster)hashMap.get(n)) != null) {
                        plotCluster.helpers.add((UUID)object);
                        continue;
                    }
                    LOGGER.warn("Cluster #{}({}) in cluster_helpers does not exist. Please create the cluster or remove this entry", (Object)n, (Object)plotCluster);
                }
                object2 = bl2.executeQuery("SELECT `user_uuid`, `cluster_id` FROM `" + this.prefix + "cluster_invited`");
                while (object2.next()) {
                    PlotCluster plotCluster;
                    n = object2.getInt("cluster_id");
                    string22 = object2.getString("user_uuid");
                    object = (UUID)((HashMap)object5).get(string22);
                    if (object == null) {
                        object = UUID.fromString(string22);
                        ((HashMap)object5).put(string22, object);
                    }
                    if ((plotCluster = (PlotCluster)hashMap.get(n)) != null) {
                        plotCluster.invited.add((UUID)object);
                        continue;
                    }
                    LOGGER.warn("Cluster #{}({}) in cluster_helpers does not exist. Please create the cluster or remove this entry", (Object)n, (Object)plotCluster);
                }
                object2 = bl2.executeQuery("SELECT * FROM `" + this.prefix + "cluster_settings`");
                while (object2.next()) {
                    n = object2.getInt("cluster_id");
                    PlotCluster plotCluster = (PlotCluster)hashMap.get(n);
                    if (plotCluster != null) {
                        object6 = object2.getString("alias");
                        if (object6 != null) {
                            plotCluster.settings.setAlias((String)object6);
                        }
                        object4 = object2.getString("position");
                        switch (((String)object4).toLowerCase()) {
                            case "": 
                            case "default": 
                            case "0,0,0": 
                            case "center": 
                            case "centre": {
                                break;
                            }
                            default: {
                                try {
                                    BlockLoc blockLoc = BlockLoc.fromString((String)object4);
                                    plotCluster.settings.setPosition(blockLoc);
                                    break;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        int n2 = object2.getInt("merged");
                        object3 = new boolean[4];
                        for (int i = 0; i < 4; ++i) {
                            object3[3 - i] = (n2 & 1 << i) != 0;
                        }
                        plotCluster.settings.setMerged((boolean[])object3);
                        continue;
                    }
                    LOGGER.warn("Cluster #{}({}) in cluster_helpers does not exist. Please create the cluster or remove this entry", (Object)n, (Object)plotCluster);
                }
                object2.close();
            }
            boolean bl3 = false;
            for (Map.Entry entry : hashMap2.entrySet()) {
                string22 = (String)entry.getKey();
                bl = true;
                LOGGER.warn("Warning! Found {} clusters in DB for non existent area; '{}'", hashMap2.get(string22), (Object)string22);
            }
            if (bl) {
                LOGGER.warn("Warning! Please create the world(s) or remove the clusters using the purge command");
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("Failed to load clusters", (Throwable)sQLException);
        }
        return linkedHashMap;
    }

    @Override
    public void setClusterName(final PlotCluster plotCluster, final String string) {
        this.addClusterTask(plotCluster, new UniqueStatement("setClusterName"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, SQLManager.this.getClusterId(plotCluster));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "cluster_settings` SET `alias` = ?  WHERE `cluster_id` = ?");
            }
        });
        plotCluster.settings.setAlias(string);
    }

    @Override
    public void removeHelper(final PlotCluster plotCluster, final UUID uUID) {
        this.addClusterTask(plotCluster, new UniqueStatement("removeHelper"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getClusterId(plotCluster));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "cluster_helpers` WHERE `cluster_id` = ? AND `user_uuid` = ?");
            }
        });
    }

    @Override
    public void setHelper(final PlotCluster plotCluster, final UUID uUID) {
        this.addClusterTask(plotCluster, new UniqueStatement("setHelper"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getClusterId(plotCluster));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "cluster_helpers` (`cluster_id`, `user_uuid`) VALUES(?,?)");
            }
        });
    }

    @Override
    public void createCluster(final PlotCluster plotCluster) {
        this.addClusterTask(plotCluster, new UniqueStatement("createCluster_" + plotCluster.hashCode()){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, plotCluster.getP1().getX());
                preparedStatement.setInt(2, plotCluster.getP1().getY());
                preparedStatement.setInt(3, plotCluster.getP2().getX());
                preparedStatement.setInt(4, plotCluster.getP2().getY());
                preparedStatement.setString(5, plotCluster.owner.toString());
                preparedStatement.setString(6, plotCluster.area.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement(SQLManager.this.CREATE_CLUSTER, 1);
            }

            @Override
            public void execute(PreparedStatement preparedStatement) {
            }

            @Override
            public void addBatch(PreparedStatement preparedStatement) {
                preparedStatement.execute();
                try (ResultSet resultSet = SQLManager.this.supportsGetGeneratedKeys ? preparedStatement.getGeneratedKeys() : preparedStatement.getResultSet();){
                    if (resultSet.next()) {
                        plotCluster.temp = resultSet.getInt(1);
                    }
                }
            }
        });
        this.addClusterTask(plotCluster, new UniqueStatement("createCluster_settings_" + plotCluster.hashCode()){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getClusterId(plotCluster));
                preparedStatement.setString(2, plotCluster.settings.getAlias());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "cluster_settings`(`cluster_id`, `alias`) VALUES(?, ?)");
            }
        });
    }

    @Override
    public void resizeCluster(final PlotCluster plotCluster, PlotId plotId, PlotId plotId2) {
        final PlotId plotId3 = PlotId.of(plotCluster.getP1().getX(), plotCluster.getP1().getY());
        final PlotId plotId4 = PlotId.of(plotCluster.getP2().getX(), plotCluster.getP2().getY());
        plotCluster.setP1(plotId);
        plotCluster.setP2(plotId2);
        this.addClusterTask(plotCluster, new UniqueStatement("resizeCluster"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, plotId3.getX());
                preparedStatement.setInt(2, plotId3.getY());
                preparedStatement.setInt(3, plotId4.getX());
                preparedStatement.setInt(4, plotId4.getY());
                preparedStatement.setInt(5, SQLManager.this.getClusterId(plotCluster));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "cluster` SET `pos1_x` = ?, `pos1_z` = ?, `pos2_x` = ?, `pos2_z` = ?  WHERE `id` = ?");
            }
        });
    }

    @Override
    public void setPosition(final PlotCluster plotCluster, final String string) {
        this.addClusterTask(plotCluster, new UniqueStatement("setPosition"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, SQLManager.this.getClusterId(plotCluster));
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("UPDATE `" + SQLManager.this.prefix + "cluster_settings` SET `position` = ?  WHERE `cluster_id` = ?");
            }
        });
    }

    @Override
    public void removeInvited(final PlotCluster plotCluster, final UUID uUID) {
        this.addClusterTask(plotCluster, new UniqueStatement("removeInvited"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getClusterId(plotCluster));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("DELETE FROM `" + SQLManager.this.prefix + "cluster_invited` WHERE `cluster_id` = ? AND `user_uuid` = ?");
            }
        });
    }

    @Override
    public void setInvited(final PlotCluster plotCluster, final UUID uUID) {
        this.addClusterTask(plotCluster, new UniqueStatement("setInvited"){

            @Override
            public void set(PreparedStatement preparedStatement) {
                preparedStatement.setInt(1, SQLManager.this.getClusterId(plotCluster));
                preparedStatement.setString(2, uUID.toString());
            }

            @Override
            public PreparedStatement get() {
                return SQLManager.this.connection.prepareStatement("INSERT INTO `" + SQLManager.this.prefix + "cluster_invited` (`cluster_id`, `user_uuid`) VALUES(?,?)");
            }
        });
    }

    @Override
    public boolean deleteTables() {
        try (Statement statement = this.connection.createStatement();
             PreparedStatement preparedStatement = this.connection.prepareStatement("DROP TABLE `" + this.prefix + "plot`");){
            this.close();
            this.closed = false;
            this.connection = this.database.forceConnection();
            statement.addBatch("DROP TABLE `" + this.prefix + "cluster_invited`");
            statement.addBatch("DROP TABLE `" + this.prefix + "cluster_helpers`");
            statement.addBatch("DROP TABLE `" + this.prefix + "cluster`");
            statement.addBatch("DROP TABLE `" + this.prefix + "plot_rating`");
            statement.addBatch("DROP TABLE `" + this.prefix + "plot_settings`");
            statement.addBatch("DROP TABLE `" + this.prefix + "plot_comments`");
            statement.addBatch("DROP TABLE `" + this.prefix + "plot_trusted`");
            statement.addBatch("DROP TABLE `" + this.prefix + "plot_helpers`");
            statement.addBatch("DROP TABLE `" + this.prefix + "plot_denied`");
            statement.executeBatch();
            statement.clearBatch();
            preparedStatement.executeUpdate();
        }
        catch (ClassNotFoundException | SQLException exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public void validateAllPlots(Set<Plot> set) {
        HashMap<PlotId, Plot> hashMap;
        if (!this.isValid()) {
            this.reconnect();
        }
        LOGGER.info("All DB transactions during this session are being validated (This may take a while if corrections need to be made)");
        this.commit();
        while (this.sendBatch()) {
        }
        try {
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        HashMap<String, HashMap<PlotId, Plot>> hashMap2 = this.getPlots();
        ArrayList<Plot> arrayList = new ArrayList<Plot>();
        for (Plot object : set) {
            boolean[] blArray;
            Object object22;
            Iterator iterator;
            Object object3;
            if (object.temp == -1) continue;
            if (object.getArea() == null) {
                LOGGER.error("CRITICAL ERROR IN VALIDATION TASK: {}", (Object)object);
                LOGGER.error("PLOT AREA CANNOT BE NULL! SKIPPING PLOT!");
                LOGGER.info("Delete this entry from your database or set `database-purger: true` in the settings.yml");
                continue;
            }
            if (hashMap2 == null) {
                LOGGER.error("CRITICAL ERROR IN VALIDATION TASK!");
                LOGGER.error("DATABASE VARIABLE CANNOT BE NULL! NOW ENDING VALIDATION!");
                break;
            }
            hashMap = hashMap2.get(object.getArea().toString());
            if (hashMap == null) {
                arrayList.add(object);
                continue;
            }
            Plot plot = hashMap.remove(object.getId());
            if (plot == null) {
                arrayList.add(object);
                continue;
            }
            if (!object.getOwnerAbs().equals(plot.getOwnerAbs())) {
                this.setOwner(object, object.getOwnerAbs());
            }
            if (!object.getTrusted().equals(plot.getTrusted())) {
                HashSet hashSet = (HashSet)object.getTrusted().clone();
                object3 = (HashSet)plot.getTrusted().clone();
                ((AbstractSet)object3).removeAll(object.getTrusted());
                hashSet.removeAll(plot.getTrusted());
                if (!((HashSet)object3).isEmpty()) {
                    iterator = ((HashSet)object3).iterator();
                    while (iterator.hasNext()) {
                        object22 = (UUID)iterator.next();
                        this.removeTrusted(object, (UUID)object22);
                    }
                }
                if (!hashSet.isEmpty()) {
                    for (Object object22 : hashSet) {
                        this.setTrusted(object, (UUID)object22);
                    }
                }
            }
            if (!object.getMembers().equals(plot.getMembers())) {
                HashSet hashSet = (HashSet)object.getMembers().clone();
                object3 = (HashSet)plot.getMembers().clone();
                ((AbstractSet)object3).removeAll(object.getMembers());
                hashSet.removeAll(plot.getMembers());
                if (!((HashSet)object3).isEmpty()) {
                    iterator = ((HashSet)object3).iterator();
                    while (iterator.hasNext()) {
                        object22 = (UUID)iterator.next();
                        this.removeMember(object, (UUID)object22);
                    }
                }
                if (!hashSet.isEmpty()) {
                    for (Object object22 : hashSet) {
                        this.setMember(object, (UUID)object22);
                    }
                }
            }
            if (!object.getDenied().equals(plot.getDenied())) {
                HashSet hashSet = (HashSet)object.getDenied().clone();
                object3 = (HashSet)plot.getDenied().clone();
                ((AbstractSet)object3).removeAll(object.getDenied());
                hashSet.removeAll(plot.getDenied());
                if (!((HashSet)object3).isEmpty()) {
                    iterator = ((HashSet)object3).iterator();
                    while (iterator.hasNext()) {
                        object22 = (UUID)iterator.next();
                        this.removeDenied(object, (UUID)object22);
                    }
                }
                if (!hashSet.isEmpty()) {
                    for (Object object22 : hashSet) {
                        this.setDenied(object, (UUID)object22);
                    }
                }
            }
            if ((blArray = object.getMerged())[0] != (object3 = (Object)plot.getMerged())[0] || blArray[1] != object3[1]) {
                this.setMerged(plot, object.getMerged());
            }
            iterator = object.getFlags();
            object22 = plot.getFlags();
            if (!iterator.isEmpty() && !object22.isEmpty() && iterator.size() == object22.size() && StringMan.isEqual(StringMan.joinOrdered(iterator, ","), StringMan.joinOrdered(object22, ","))) continue;
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            hashMap = (HashMap<PlotId, Plot>)entry.getValue();
            if (hashMap.isEmpty()) continue;
            for (Map.Entry<PlotId, Plot> entry2 : hashMap.entrySet()) {
            }
        }
        this.commit();
    }

    @Override
    public void replaceWorld(String string, String string2, PlotId plotId, PlotId plotId2) {
        this.addGlobalTask(() -> {
            if (plotId == null) {
                PreparedStatement preparedStatement;
                try {
                    preparedStatement = this.connection.prepareStatement("UPDATE `" + this.prefix + "plot` SET `world` = ? WHERE `world` = ?");
                    try {
                        preparedStatement.setString(1, string2);
                        preparedStatement.setString(2, string);
                        preparedStatement.executeUpdate();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                try {
                    preparedStatement = this.connection.prepareStatement("UPDATE `" + this.prefix + "cluster` SET `world` = ? WHERE `world` = ?");
                    try {
                        preparedStatement.setString(1, string2);
                        preparedStatement.setString(2, string);
                        preparedStatement.executeUpdate();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            } else {
                PreparedStatement preparedStatement;
                try {
                    preparedStatement = this.connection.prepareStatement("UPDATE `" + this.prefix + "plot` SET `world` = ? WHERE `world` = ? AND `plot_id_x` BETWEEN ? AND ? AND `plot_id_z` BETWEEN ? AND ?");
                    try {
                        preparedStatement.setString(1, string2);
                        preparedStatement.setString(2, string);
                        preparedStatement.setInt(3, plotId.getX());
                        preparedStatement.setInt(4, plotId2.getX());
                        preparedStatement.setInt(5, plotId.getY());
                        preparedStatement.setInt(6, plotId2.getY());
                        preparedStatement.executeUpdate();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                try {
                    preparedStatement = this.connection.prepareStatement("UPDATE `" + this.prefix + "cluster` SET `world` = ? WHERE `world` = ? AND `pos1_x` <= ? AND `pos1_z` <= ? AND `pos2_x` >= ? AND `pos2_z` >= ?");
                    try {
                        preparedStatement.setString(1, string2);
                        preparedStatement.setString(2, string);
                        preparedStatement.setInt(3, plotId2.getX());
                        preparedStatement.setInt(4, plotId2.getY());
                        preparedStatement.setInt(5, plotId.getX());
                        preparedStatement.setInt(6, plotId.getY());
                        preparedStatement.executeUpdate();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        });
    }

    @Override
    public void replaceUUID(UUID uUID, UUID uUID2) {
        this.addGlobalTask(() -> {
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("UPDATE `" + this.prefix + "cluster` SET `owner` = '" + uUID2.toString() + "' WHERE `owner` = '" + uUID.toString() + "'");
                statement.executeUpdate("UPDATE `" + this.prefix + "cluster_helpers` SET `user_uuid` = '" + uUID2 + "' WHERE `user_uuid` = '" + uUID + "'");
                statement.executeUpdate("UPDATE `" + this.prefix + "cluster_invited` SET `user_uuid` = '" + uUID2 + "' WHERE `user_uuid` = '" + uUID + "'");
                statement.executeUpdate("UPDATE `" + this.prefix + "plot` SET `owner` = '" + uUID2 + "' WHERE `owner` = '" + uUID + "'");
                statement.executeUpdate("UPDATE `" + this.prefix + "plot_denied` SET `user_uuid` = '" + uUID2 + "' WHERE `user_uuid` = '" + uUID + "'");
                statement.executeUpdate("UPDATE `" + this.prefix + "plot_helpers` SET `user_uuid` = '" + uUID2 + "' WHERE `user_uuid` = '" + uUID + "'");
                statement.executeUpdate("UPDATE `" + this.prefix + "plot_trusted` SET `user_uuid` = '" + uUID2 + "' WHERE `user_uuid` = '" + uUID + "'");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        });
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            this.connection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$createPlotsAndData$5(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, Runnable runnable) {
        this.createSettings(arrayList, () -> this.createTiers(arrayList2, "helpers", () -> this.createTiers(arrayList3, "trusted", () -> this.createTiers(arrayList4, "denied", () -> {
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            if (runnable != null) {
                runnable.run();
            }
        }))));
    }

    public static abstract class UniqueStatement {
        public final String method;

        public UniqueStatement(String string) {
            this.method = string;
        }

        public void addBatch(PreparedStatement preparedStatement) {
            preparedStatement.addBatch();
        }

        public void execute(PreparedStatement preparedStatement) {
            preparedStatement.executeBatch();
        }

        public abstract PreparedStatement get();

        public abstract void set(PreparedStatement var1);
    }

    private record LegacySettings(int id, PlotSettings settings) {
    }

    private record UUIDPair(int id, UUID uuid) {
    }
}

