/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import com.plotsquared.core.geantyref.AnnotatedCaptureType;
import com.plotsquared.core.geantyref.AnnotatedTypeImpl;
import com.plotsquared.core.geantyref.CaptureType;
import com.plotsquared.core.geantyref.CaptureTypeImpl;
import com.plotsquared.core.geantyref.VarMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

class AnnotatedCaptureTypeImpl
extends AnnotatedTypeImpl
implements AnnotatedCaptureType {
    private final AnnotatedWildcardType wildcard;
    private final AnnotatedTypeVariable variable;
    private final AnnotatedType[] lowerBounds;
    private AnnotatedType[] upperBounds;
    private final CaptureType type;
    private final Annotation[] declaredAnnotations;

    AnnotatedCaptureTypeImpl(AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable) {
        this(new CaptureTypeImpl((WildcardType)annotatedWildcardType.getType(), (TypeVariable)annotatedTypeVariable.getType()), annotatedWildcardType, annotatedTypeVariable);
    }

    AnnotatedCaptureTypeImpl(CaptureType captureType, AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable) {
        this(captureType, annotatedWildcardType, annotatedTypeVariable, null, null);
    }

    AnnotatedCaptureTypeImpl(CaptureType captureType, AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable, AnnotatedType[] annotatedTypeArray, Annotation[] annotationArray) {
        this(captureType, annotatedWildcardType, annotatedTypeVariable, annotatedWildcardType.getAnnotatedLowerBounds(), annotatedTypeArray, annotationArray);
    }

    AnnotatedCaptureTypeImpl(CaptureType captureType, AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable, AnnotatedType[] annotatedTypeArray, AnnotatedType[] annotatedTypeArray2, Annotation[] annotationArray) {
        super(captureType, annotationArray != null ? annotationArray : (Annotation[])Stream.concat(Arrays.stream(annotatedWildcardType.getAnnotations()), Arrays.stream(annotatedTypeVariable.getAnnotations())).toArray(Annotation[]::new));
        this.type = captureType;
        this.wildcard = annotatedWildcardType;
        this.variable = annotatedTypeVariable;
        this.lowerBounds = annotatedTypeArray;
        this.upperBounds = annotatedTypeArray2;
        this.declaredAnnotations = (Annotation[])Stream.concat(Arrays.stream(annotatedWildcardType.getDeclaredAnnotations()), Arrays.stream(annotatedTypeVariable.getDeclaredAnnotations())).toArray(Annotation[]::new);
    }

    void init(VarMap varMap) {
        ArrayList<AnnotatedType> arrayList = new ArrayList<AnnotatedType>(Arrays.asList(varMap.map(this.variable.getAnnotatedBounds())));
        List<AnnotatedType> list = Arrays.asList(this.wildcard.getAnnotatedUpperBounds());
        if (list.size() > 0 && list.get(0).getType() == Object.class) {
            arrayList.addAll(list.subList(1, list.size()));
        } else {
            arrayList.addAll(list);
        }
        this.upperBounds = new AnnotatedType[arrayList.size()];
        arrayList.toArray(this.upperBounds);
        ((CaptureTypeImpl)this.type).init(varMap);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        assert (this.upperBounds != null);
        return (AnnotatedType[])this.upperBounds.clone();
    }

    @Override
    public void setAnnotatedUpperBounds(AnnotatedType[] annotatedTypeArray) {
        this.upperBounds = annotatedTypeArray;
        this.type.setUpperBounds((Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new));
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return (AnnotatedType[])this.lowerBounds.clone();
    }

    @Override
    public AnnotatedTypeVariable getAnnotatedTypeVariable() {
        return this.variable;
    }

    @Override
    public AnnotatedWildcardType getAnnotatedWildcardType() {
        return this.wildcard;
    }
}

