/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Objects;

class GenericArrayTypeImpl
implements GenericArrayType {
    private Type componentType;

    GenericArrayTypeImpl(Type type) {
        this.componentType = type;
    }

    static Class<?> createArrayType(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    static Type createArrayType(Type type) {
        if (type instanceof Class) {
            return GenericArrayTypeImpl.createArrayType((Class)type);
        }
        return new GenericArrayTypeImpl(type);
    }

    @Override
    public Type getGenericComponentType() {
        return this.componentType;
    }

    public boolean equals(Object object) {
        return object instanceof GenericArrayType && Objects.equals(this.componentType, ((GenericArrayType)object).getGenericComponentType());
    }

    public int hashCode() {
        return Objects.hashCode(this.componentType);
    }

    public String toString() {
        return this.componentType + "[]";
    }
}

