/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import com.plotsquared.core.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeToken<T> {
    private final AnnotatedType type;

    protected TypeToken() {
        this.type = this.extractType();
    }

    private TypeToken(AnnotatedType annotatedType) {
        this.type = annotatedType;
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new TypeToken<T>(GenericTypeReflector.annotate(clazz)){};
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken<Object>(GenericTypeReflector.annotate(type)){};
    }

    public Type getType() {
        return this.type.getType();
    }

    public AnnotatedType getAnnotatedType() {
        return this.type;
    }

    public AnnotatedType getCanonicalType() {
        return GenericTypeReflector.toCanonical(this.type);
    }

    private AnnotatedType extractType() {
        AnnotatedType annotatedType = this.getClass().getAnnotatedSuperclass();
        if (!(annotatedType instanceof AnnotatedParameterizedType)) {
            throw new RuntimeException("Invalid TypeToken; must specify type parameters");
        }
        AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
        if (((ParameterizedType)annotatedParameterizedType.getType()).getRawType() != TypeToken.class) {
            throw new RuntimeException("Invalid TypeToken; must directly extend TypeToken");
        }
        return annotatedParameterizedType.getAnnotatedActualTypeArguments()[0];
    }

    public boolean equals(Object object) {
        return object instanceof TypeToken && GenericTypeReflector.equals(this.type, ((TypeToken)object).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

