/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.geantyref;

import com.plotsquared.core.geantyref.AnnotatedArrayTypeImpl;
import com.plotsquared.core.geantyref.AnnotatedCaptureType;
import com.plotsquared.core.geantyref.AnnotatedCaptureTypeImpl;
import com.plotsquared.core.geantyref.AnnotatedTypeVariableImpl;
import com.plotsquared.core.geantyref.AnnotatedWildcardTypeImpl;
import com.plotsquared.core.geantyref.CaptureType;
import com.plotsquared.core.geantyref.GenericArrayTypeImpl;
import com.plotsquared.core.geantyref.GenericTypeReflector;
import com.plotsquared.core.geantyref.WildcardTypeImpl;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class TypeVisitor {
    private final Map<TypeVariable, AnnotatedTypeVariable> varCache = new IdentityHashMap<TypeVariable, AnnotatedTypeVariable>();
    private final Map<AnnotatedCaptureCacheKey, AnnotatedType> captureCache = new HashMap<AnnotatedCaptureCacheKey, AnnotatedType>();

    protected AnnotatedType visitParameterizedType(AnnotatedParameterizedType annotatedParameterizedType) {
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedParameterizedType.getAnnotatedActualTypeArguments()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        return GenericTypeReflector.replaceParameters(annotatedParameterizedType, annotatedTypeArray);
    }

    protected AnnotatedType visitWildcardType(AnnotatedWildcardType annotatedWildcardType) {
        Type[] typeArray;
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedWildcardType.getAnnotatedLowerBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        AnnotatedType[] annotatedTypeArray2 = (AnnotatedType[])Arrays.stream(annotatedWildcardType.getAnnotatedUpperBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        if (annotatedTypeArray2.length > 0) {
            typeArray = (Type[])Arrays.stream(annotatedTypeArray2).map(AnnotatedType::getType).toArray(Type[]::new);
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        }
        WildcardTypeImpl wildcardTypeImpl = new WildcardTypeImpl(typeArray, (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new));
        return new AnnotatedWildcardTypeImpl(wildcardTypeImpl, annotatedWildcardType.getAnnotations(), annotatedTypeArray, annotatedTypeArray2);
    }

    protected AnnotatedType visitVariable(AnnotatedTypeVariable annotatedTypeVariable) {
        TypeVariable typeVariable = (TypeVariable)annotatedTypeVariable.getType();
        if (this.varCache.containsKey(typeVariable)) {
            return this.varCache.get(typeVariable);
        }
        AnnotatedTypeVariableImpl annotatedTypeVariableImpl = new AnnotatedTypeVariableImpl(typeVariable, annotatedTypeVariable.getAnnotations());
        this.varCache.put(typeVariable, annotatedTypeVariableImpl);
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedTypeVariable.getAnnotatedBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        annotatedTypeVariableImpl.init(annotatedTypeArray);
        return annotatedTypeVariableImpl;
    }

    protected AnnotatedType visitArray(AnnotatedArrayType annotatedArrayType) {
        AnnotatedType annotatedType = GenericTypeReflector.transform(annotatedArrayType.getAnnotatedGenericComponentType(), this);
        return new AnnotatedArrayTypeImpl(GenericArrayTypeImpl.createArrayType(annotatedType.getType()), annotatedArrayType.getAnnotations(), annotatedType);
    }

    protected AnnotatedType visitCaptureType(AnnotatedCaptureType annotatedCaptureType) {
        AnnotatedCaptureCacheKey annotatedCaptureCacheKey = new AnnotatedCaptureCacheKey(annotatedCaptureType);
        if (this.captureCache.containsKey(annotatedCaptureCacheKey)) {
            return this.captureCache.get(annotatedCaptureCacheKey);
        }
        AnnotatedType[] annotatedTypeArray = annotatedCaptureType.getAnnotatedLowerBounds();
        if (annotatedTypeArray != null) {
            annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedTypeArray).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        }
        AnnotatedType[] annotatedTypeArray2 = (AnnotatedType[])Arrays.stream(annotatedCaptureType.getAnnotatedUpperBounds()).map(annotatedType -> GenericTypeReflector.transform(annotatedType, this)).toArray(AnnotatedType[]::new);
        AnnotatedCaptureTypeImpl annotatedCaptureTypeImpl = new AnnotatedCaptureTypeImpl((CaptureType)annotatedCaptureType.getType(), annotatedCaptureType.getAnnotatedWildcardType(), annotatedCaptureType.getAnnotatedTypeVariable(), annotatedTypeArray, annotatedTypeArray2, annotatedCaptureType.getAnnotations());
        this.captureCache.put(annotatedCaptureCacheKey, annotatedCaptureTypeImpl);
        return annotatedCaptureTypeImpl;
    }

    protected AnnotatedType visitClass(AnnotatedType annotatedType) {
        return annotatedType;
    }

    protected AnnotatedType visitUnmatched(AnnotatedType annotatedType) {
        return annotatedType;
    }

    private static class AnnotatedCaptureCacheKey {
        AnnotatedCaptureType capture;
        CaptureType raw;

        AnnotatedCaptureCacheKey(AnnotatedCaptureType annotatedCaptureType) {
            this.capture = annotatedCaptureType;
            this.raw = (CaptureType)annotatedCaptureType.getType();
        }

        public int hashCode() {
            return 127 * this.raw.getWildcardType().hashCode() ^ this.raw.getTypeVariable().hashCode() ^ GenericTypeReflector.hashCode(Arrays.stream(this.capture.getAnnotations()));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AnnotatedCaptureCacheKey)) {
                return false;
            }
            AnnotatedCaptureCacheKey annotatedCaptureCacheKey = (AnnotatedCaptureCacheKey)object;
            return this.capture == annotatedCaptureCacheKey.capture || new GenericTypeReflector.CaptureCacheKey(this.raw).equals(new GenericTypeReflector.CaptureCacheKey(annotatedCaptureCacheKey.raw)) && Arrays.equals(this.capture.getAnnotations(), annotatedCaptureCacheKey.capture.getAnnotations());
        }
    }
}

