/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.common.base.Preconditions;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.NullWorld;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.EnumSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridGen
extends IndependentPlotGenerator {
    private static final CuboidRegion CHUNK = new CuboidRegion(BlockVector3.ZERO, BlockVector3.at((int)15, (int)396, (int)15));
    private final HybridPlotWorldFactory hybridPlotWorldFactory;

    @Inject
    public HybridGen(@NonNull HybridPlotWorldFactory hybridPlotWorldFactory) {
        this.hybridPlotWorldFactory = hybridPlotWorldFactory;
    }

    @Override
    public String getName() {
        return PlotSquared.platform().pluginName();
    }

    private void placeSchem(HybridPlotWorld hybridPlotWorld, ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, short s, short s2, int n, int n2, EnumSet<SchematicFeature> enumSet) {
        boolean bl = enumSet.contains((Object)SchematicFeature.ROAD);
        int n3 = bl && Settings.Schematics.PASTE_ROAD_ON_TOP || !bl && Settings.Schematics.PASTE_ON_TOP ? hybridPlotWorld.SCHEM_Y : hybridPlotWorld.getMinBuildHeight();
        BaseBlock[] baseBlockArray = hybridPlotWorld.G_SCH.get(MathMan.pair(s, s2));
        if (baseBlockArray != null) {
            for (int i = 0; i < baseBlockArray.length; ++i) {
                if (baseBlockArray[i] == null || enumSet.contains((Object)SchematicFeature.POPULATING) && !baseBlockArray[i].hasNbtData()) continue;
                zeroedDelegateScopedQueueCoordinator.setBlock(n, n3 + i, n2, baseBlockArray[i]);
            }
        }
        if (!enumSet.contains((Object)SchematicFeature.BIOMES)) {
            return;
        }
        BiomeType biomeType = hybridPlotWorld.G_SCH_B.get(MathMan.pair(s, s2));
        if (biomeType != null) {
            zeroedDelegateScopedQueueCoordinator.setBiome(n, n2, biomeType);
        }
    }

    @Override
    public void generateChunk(@NonNull ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, @NonNull PlotArea plotArea, boolean bl) {
        int n;
        Preconditions.checkNotNull((Object)zeroedDelegateScopedQueueCoordinator, (Object)"result cannot be null");
        Preconditions.checkNotNull((Object)plotArea, (Object)"settings cannot be null");
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)plotArea;
        if (bl) {
            zeroedDelegateScopedQueueCoordinator.fillBiome(hybridPlotWorld.getPlotBiome());
        }
        if (hybridPlotWorld.PLOT_BEDROCK) {
            for (int n2 = 0; n2 < 16; n2 = (int)((short)(n2 + 1))) {
                for (int n3 = 0; n3 < 16; n3 = (int)((short)(n3 + 1))) {
                    zeroedDelegateScopedQueueCoordinator.setBlock(n2, hybridPlotWorld.getMinGenHeight(), n3, BlockTypes.BEDROCK.getDefaultState());
                }
            }
        }
        EnumSet<SchematicFeature> enumSet = EnumSet.of(SchematicFeature.ROAD);
        EnumSet<SchematicFeature> enumSet2 = EnumSet.noneOf(SchematicFeature.class);
        if (bl) {
            enumSet.add(SchematicFeature.BIOMES);
            enumSet2.add(SchematicFeature.BIOMES);
        }
        Location location = zeroedDelegateScopedQueueCoordinator.getMin();
        int n4 = location.getX() - hybridPlotWorld.ROAD_OFFSET_X;
        int n5 = location.getZ() - hybridPlotWorld.ROAD_OFFSET_Z;
        short s = (short)Math.floorMod(n4, (int)hybridPlotWorld.SIZE);
        short s2 = (short)Math.floorMod(n5, (int)hybridPlotWorld.SIZE);
        short[] sArray = new short[16];
        boolean[] blArray = new boolean[16];
        boolean[] blArray2 = new boolean[16];
        short s3 = s;
        for (int n6 = 0; n6 < 16; n6 = (int)((short)(n6 + 1))) {
            if (s3 >= hybridPlotWorld.SIZE) {
                s3 = (short)(s3 - hybridPlotWorld.SIZE);
            }
            sArray[n6] = s3;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                blArray[n6] = s3 < hybridPlotWorld.PATH_WIDTH_LOWER || s3 > hybridPlotWorld.PATH_WIDTH_UPPER;
                blArray2[n6] = s3 == hybridPlotWorld.PATH_WIDTH_LOWER || s3 == hybridPlotWorld.PATH_WIDTH_UPPER;
            }
            s3 = (short)(s3 + 1);
        }
        short[] sArray2 = new short[16];
        boolean[] blArray3 = new boolean[16];
        boolean[] blArray4 = new boolean[16];
        short s4 = s2;
        for (n = 0; n < 16; n = (int)((short)(n + 1))) {
            if (s4 >= hybridPlotWorld.SIZE) {
                s4 = (short)(s4 - hybridPlotWorld.SIZE);
            }
            sArray2[n] = s4;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                blArray3[n] = s4 < hybridPlotWorld.PATH_WIDTH_LOWER || s4 > hybridPlotWorld.PATH_WIDTH_UPPER;
                blArray4[n] = s4 == hybridPlotWorld.PATH_WIDTH_LOWER || s4 == hybridPlotWorld.PATH_WIDTH_UPPER;
            }
            s4 = (short)(s4 + 1);
        }
        n = hybridPlotWorld.getMinGenHeight() + (hybridPlotWorld.PLOT_BEDROCK ? 1 : 0);
        for (int n7 = 0; n7 < 16; n7 = (int)((short)(n7 + 1))) {
            int n8;
            int n9;
            if (blArray[n7]) {
                for (n9 = 0; n9 < 16; n9 = (int)((short)(n9 + 1))) {
                    for (n8 = n; n8 <= hybridPlotWorld.ROAD_HEIGHT; ++n8) {
                        zeroedDelegateScopedQueueCoordinator.setBlock(n7, n8, n9, hybridPlotWorld.ROAD_BLOCK.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n7], sArray2[n9], n7, n9, enumSet);
                }
                continue;
            }
            if (blArray2[n7]) {
                for (n9 = 0; n9 < 16; n9 = (int)((short)(n9 + 1))) {
                    if (blArray3[n9]) {
                        for (n8 = n; n8 <= hybridPlotWorld.ROAD_HEIGHT; ++n8) {
                            zeroedDelegateScopedQueueCoordinator.setBlock(n7, n8, n9, hybridPlotWorld.ROAD_BLOCK.toPattern());
                        }
                        if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                        this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n7], sArray2[n9], n7, n9, enumSet);
                        continue;
                    }
                    for (n8 = n; n8 <= hybridPlotWorld.WALL_HEIGHT; ++n8) {
                        zeroedDelegateScopedQueueCoordinator.setBlock(n7, n8, n9, hybridPlotWorld.WALL_FILLING.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
                        if (!hybridPlotWorld.PLACE_TOP_BLOCK) continue;
                        zeroedDelegateScopedQueueCoordinator.setBlock(n7, hybridPlotWorld.WALL_HEIGHT + 1, n9, hybridPlotWorld.WALL_BLOCK.toPattern());
                        continue;
                    }
                    this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n7], sArray2[n9], n7, n9, enumSet);
                }
                continue;
            }
            for (n9 = 0; n9 < 16; n9 = (int)((short)(n9 + 1))) {
                if (blArray3[n9]) {
                    for (n8 = n; n8 <= hybridPlotWorld.ROAD_HEIGHT; ++n8) {
                        zeroedDelegateScopedQueueCoordinator.setBlock(n7, n8, n9, hybridPlotWorld.ROAD_BLOCK.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n7], sArray2[n9], n7, n9, enumSet);
                    continue;
                }
                if (blArray4[n9]) {
                    for (n8 = n; n8 <= hybridPlotWorld.WALL_HEIGHT; ++n8) {
                        zeroedDelegateScopedQueueCoordinator.setBlock(n7, n8, n9, hybridPlotWorld.WALL_FILLING.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
                        if (!hybridPlotWorld.PLACE_TOP_BLOCK) continue;
                        zeroedDelegateScopedQueueCoordinator.setBlock(n7, hybridPlotWorld.WALL_HEIGHT + 1, n9, hybridPlotWorld.WALL_BLOCK.toPattern());
                        continue;
                    }
                    this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n7], sArray2[n9], n7, n9, enumSet);
                    continue;
                }
                for (n8 = n; n8 < hybridPlotWorld.PLOT_HEIGHT; ++n8) {
                    zeroedDelegateScopedQueueCoordinator.setBlock(n7, n8, n9, hybridPlotWorld.MAIN_BLOCK.toPattern());
                }
                zeroedDelegateScopedQueueCoordinator.setBlock(n7, hybridPlotWorld.PLOT_HEIGHT, n9, hybridPlotWorld.TOP_BLOCK.toPattern());
                if (!hybridPlotWorld.PLOT_SCHEMATIC) continue;
                this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n7], sArray2[n9], n7, n9, enumSet2);
            }
        }
    }

    @Override
    public void populateChunk(ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, PlotArea plotArea) {
        int n;
        int n2;
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)plotArea;
        if (!hybridPlotWorld.populationNeeded()) {
            return;
        }
        EnumSet<SchematicFeature> enumSet = EnumSet.of(SchematicFeature.POPULATING, SchematicFeature.ROAD);
        EnumSet<SchematicFeature> enumSet2 = EnumSet.of(SchematicFeature.POPULATING);
        Location location = zeroedDelegateScopedQueueCoordinator.getMin();
        int n3 = location.getX() - hybridPlotWorld.ROAD_OFFSET_X;
        int n4 = location.getZ() - hybridPlotWorld.ROAD_OFFSET_Z;
        short s = (short)Math.floorMod(n3, (int)hybridPlotWorld.SIZE);
        short s2 = (short)Math.floorMod(n4, (int)hybridPlotWorld.SIZE);
        boolean bl = true;
        boolean bl2 = false;
        short[] sArray = new short[16];
        boolean[] blArray = new boolean[16];
        boolean[] blArray2 = new boolean[16];
        short s3 = s;
        for (int n5 = 0; n5 < 16; n5 = (int)((short)(n5 + 1))) {
            if (s3 >= hybridPlotWorld.SIZE) {
                s3 = (short)(s3 - hybridPlotWorld.SIZE);
                bl2 = true;
            }
            sArray[n5] = s3;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                boolean bl3 = s3 < hybridPlotWorld.PATH_WIDTH_LOWER || s3 > hybridPlotWorld.PATH_WIDTH_UPPER;
                boolean bl4 = s3 == hybridPlotWorld.PATH_WIDTH_LOWER || s3 == hybridPlotWorld.PATH_WIDTH_UPPER;
                blArray[n5] = bl3;
                blArray2[n5] = bl4;
                bl &= bl3 && bl4;
            }
            s3 = (short)(s3 + 1);
        }
        short[] sArray2 = new short[16];
        boolean[] blArray3 = new boolean[16];
        boolean[] blArray4 = new boolean[16];
        short s4 = s2;
        for (n2 = 0; n2 < 16; n2 = (int)((short)(n2 + 1))) {
            if (s4 >= hybridPlotWorld.SIZE) {
                s4 = (short)(s4 - hybridPlotWorld.SIZE);
                bl2 = true;
            }
            sArray2[n2] = s4;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                n = s4 < hybridPlotWorld.PATH_WIDTH_LOWER || s4 > hybridPlotWorld.PATH_WIDTH_UPPER ? 1 : 0;
                boolean bl5 = s4 == hybridPlotWorld.PATH_WIDTH_LOWER || s4 == hybridPlotWorld.PATH_WIDTH_UPPER;
                blArray3[n2] = n;
                blArray4[n2] = bl5;
                bl &= n != 0 && bl5;
            }
            s4 = (short)(s4 + 1);
        }
        for (n2 = 0; n2 < 16; n2 = (int)((short)(n2 + 1))) {
            if (blArray[n2] || blArray2[n2]) {
                if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                for (n = 0; n < 16; n = (int)((short)(n + 1))) {
                    this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n2], sArray2[n], n2, n, enumSet);
                }
                continue;
            }
            for (n = 0; n < 16; n = (int)((short)(n + 1))) {
                if (blArray3[n] || blArray4[n]) {
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n2], sArray2[n], n2, n, enumSet);
                    continue;
                }
                if (!hybridPlotWorld.PLOT_SCHEMATIC) continue;
                this.placeSchem(hybridPlotWorld, zeroedDelegateScopedQueueCoordinator, sArray[n2], sArray2[n], n2, n, enumSet2);
            }
        }
        if (!bl && hybridPlotWorld.getPlotSchematicEntities() != null && !hybridPlotWorld.getPlotSchematicEntities().isEmpty()) {
            CuboidRegion cuboidRegion = CHUNK.clone();
            try {
                cuboidRegion.shift(hybridPlotWorld.getPlotSchematicMinPoint().add((int)s, 0, (int)s2).subtract(hybridPlotWorld.PATH_WIDTH_LOWER + 1, 0, hybridPlotWorld.PATH_WIDTH_LOWER + 1));
                for (Entity entity : hybridPlotWorld.getPlotSchematicEntities()) {
                    if (!cuboidRegion.contains(entity.getLocation().toVector().toBlockPoint())) continue;
                    Vector3 vector3 = entity.getLocation().toVector().subtract(cuboidRegion.getMinimumPoint().withY(hybridPlotWorld.getPlotSchematicMinPoint().getY()).toVector3()).add(location.getBlockVector3().withY(hybridPlotWorld.SCHEM_Y).toVector3());
                    zeroedDelegateScopedQueueCoordinator.setEntity(new PopulatingEntity(entity, new com.sk89q.worldedit.util.Location((Extent)NullWorld.getInstance(), vector3)));
                }
            }
            catch (RegionOperationException regionOperationException) {
                throw new RuntimeException(regionOperationException);
            }
            if (bl2) {
                try {
                    cuboidRegion.shift(BlockVector3.at((int)(-hybridPlotWorld.SIZE), (int)0, (int)(-hybridPlotWorld.SIZE)));
                    for (Entity entity : hybridPlotWorld.getPlotSchematicEntities()) {
                        if (!cuboidRegion.contains(entity.getLocation().toVector().toBlockPoint())) continue;
                        zeroedDelegateScopedQueueCoordinator.setEntity(entity);
                    }
                }
                catch (RegionOperationException regionOperationException) {
                    throw new RuntimeException(regionOperationException);
                }
            }
        }
    }

    @Override
    public PlotArea getNewPlotArea(String string, String string2, PlotId plotId, PlotId plotId2) {
        return this.hybridPlotWorldFactory.create(string, string2, this, plotId, plotId2);
    }

    @Override
    public void initialize(PlotArea plotArea) {
    }

    @Override
    public BiomeType getBiome(PlotArea plotArea, int n, int n2, int n3) {
        int n4;
        BiomeType biomeType;
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)plotArea;
        if (!hybridPlotWorld.PLOT_SCHEMATIC && !hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return hybridPlotWorld.getPlotBiome();
        }
        int n5 = n;
        int n6 = n3;
        if (hybridPlotWorld.ROAD_OFFSET_X != 0) {
            n5 -= hybridPlotWorld.ROAD_OFFSET_X;
        }
        if (hybridPlotWorld.ROAD_OFFSET_Z != 0) {
            n6 -= hybridPlotWorld.ROAD_OFFSET_Z;
        }
        return (biomeType = hybridPlotWorld.G_SCH_B.get(MathMan.pair((short)(n5 = Math.floorMod(n5, n4 = hybridPlotWorld.PLOT_WIDTH + hybridPlotWorld.ROAD_WIDTH)), (short)(n6 = Math.floorMod(n6, n4))))) == null ? hybridPlotWorld.getPlotBiome() : biomeType;
    }

    private static enum SchematicFeature {
        BIOMES,
        ROAD,
        POPULATING;

    }

    private static final class PopulatingEntity
    implements Entity {
        private final Entity parent;
        private com.sk89q.worldedit.util.Location location;

        private PopulatingEntity(Entity entity, com.sk89q.worldedit.util.Location location) {
            this.parent = entity;
            this.location = location;
        }

        public @Nullable BaseEntity getState() {
            return this.parent.getState();
        }

        public boolean remove() {
            return this.parent.remove();
        }

        public com.sk89q.worldedit.util.Location getLocation() {
            return this.location;
        }

        public boolean setLocation(com.sk89q.worldedit.util.Location location) {
            this.location = location;
            return true;
        }

        public Extent getExtent() {
            return this.parent.getExtent();
        }

        public <T> @Nullable T getFacet(Class<? extends T> clazz) {
            return (T)this.parent.getFacet(clazz);
        }
    }
}

