/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.common.collect.Sets;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Template;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.ClassicPlotManager;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.FileBytes;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridPlotManager
extends ClassicPlotManager {
    public static boolean REGENERATIVE_CLEAR = true;
    private final HybridPlotWorld hybridPlotWorld;
    private final RegionManager regionManager;
    private final ProgressSubscriberFactory subscriberFactory;

    public HybridPlotManager(@NonNull HybridPlotWorld hybridPlotWorld, @NonNull RegionManager regionManager, @NonNull ProgressSubscriberFactory progressSubscriberFactory) {
        super(hybridPlotWorld, regionManager);
        this.hybridPlotWorld = hybridPlotWorld;
        this.regionManager = regionManager;
        this.subscriberFactory = progressSubscriberFactory;
    }

    @Override
    public void exportTemplate() {
        HashSet hashSet = Sets.newHashSet((Object[])new FileBytes[]{new FileBytes(Settings.Paths.TEMPLATES + "/tmp-data.yml", Template.getBytes(this.hybridPlotWorld))});
        String string = Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + this.hybridPlotWorld.getWorldName() + File.separator;
        try {
            File file;
            File file2;
            File file3 = FileUtils.getFile(PlotSquared.platform().getDirectory(), string + "sideroad.schem");
            String string2 = Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + "__TEMP_DIR__" + File.separator;
            if (file3.exists()) {
                hashSet.add(new FileBytes(string2 + "sideroad.schem", Files.readAllBytes(file3.toPath())));
            }
            if ((file2 = FileUtils.getFile(PlotSquared.platform().getDirectory(), string + "intersection.schem")).exists()) {
                hashSet.add(new FileBytes(string2 + "intersection.schem", Files.readAllBytes(file2.toPath())));
            }
            if ((file = FileUtils.getFile(PlotSquared.platform().getDirectory(), string + "plot.schem")).exists()) {
                hashSet.add(new FileBytes(string2 + "plot.schem", Files.readAllBytes(file.toPath())));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Template.zipAll(this.hybridPlotWorld.getWorldName(), hashSet);
    }

    @Override
    public boolean createRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = this.hybridPlotWorld.getQueue();
            bl = true;
        }
        super.createRoadEast(plot, queueCoordinator);
        PlotId plotId = plot.getId();
        PlotId plotId2 = PlotId.of(plotId.getX() + 1, plotId.getY());
        Location location = this.getPlotBottomLocAbs(plotId2);
        Location location2 = this.getPlotTopLocAbs(plotId);
        Location location3 = Location.at(this.hybridPlotWorld.getWorldName(), location2.getX() + 1, this.hybridPlotWorld.getMinGenHeight(), location.getZ() - 1);
        Location location4 = Location.at(this.hybridPlotWorld.getWorldName(), location.getX(), this.hybridPlotWorld.getMaxGenHeight(), location2.getZ() + 1);
        this.resetBiome(this.hybridPlotWorld, location3, location4);
        if (!this.hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return true;
        }
        this.createSchemAbs(queueCoordinator, location3, location4, true);
        return !bl || queueCoordinator.enqueue();
    }

    private void resetBiome(@NonNull HybridPlotWorld hybridPlotWorld, @NonNull Location location, @NonNull Location location2) {
        BiomeType biomeType = hybridPlotWorld.getPlotBiome();
        if (!Objects.equals(PlotSquared.platform().worldUtil().getBiomeSynchronous(hybridPlotWorld.getWorldName(), (location.getX() + location2.getX()) / 2, (location.getZ() + location2.getZ()) / 2), biomeType)) {
            WorldUtil.setBiome(hybridPlotWorld.getWorldName(), new CuboidRegion(location.getBlockVector3(), location2.getBlockVector3()), biomeType);
        }
    }

    private void createSchemAbs(@NonNull QueueCoordinator queueCoordinator, @NonNull Location location, @NonNull Location location2, boolean bl) {
        short s = this.hybridPlotWorld.SIZE;
        int n = bl && Settings.Schematics.PASTE_ROAD_ON_TOP || !bl && Settings.Schematics.PASTE_ON_TOP ? this.hybridPlotWorld.SCHEM_Y : this.hybridPlotWorld.getMinBuildHeight();
        int n2 = (bl ? this.hybridPlotWorld.getRoadYStart() : this.hybridPlotWorld.getPlotYStart()) - n;
        BaseBlock baseBlock = BlockTypes.AIR.getDefaultState().toBaseBlock();
        for (int i = location.getX(); i <= location2.getX(); ++i) {
            short s2 = (short)((i - this.hybridPlotWorld.ROAD_OFFSET_X) % s);
            if (s2 < 0) {
                s2 = (short)(s2 + s);
            }
            for (int j = location.getZ(); j <= location2.getZ(); ++j) {
                BiomeType biomeType;
                BaseBlock[] baseBlockArray;
                short s3 = (short)((j - this.hybridPlotWorld.ROAD_OFFSET_Z) % s);
                if (s3 < 0) {
                    s3 = (short)(s3 + s);
                }
                if ((baseBlockArray = this.hybridPlotWorld.G_SCH.get(MathMan.pair(s2, s3))) != null) {
                    for (int k = 0; k < baseBlockArray.length; ++k) {
                        if (baseBlockArray[k] != null) {
                            queueCoordinator.setBlock(i, n + k, j, baseBlockArray[k]);
                            continue;
                        }
                        if (k > n2) {
                            queueCoordinator.setBlock(i, n + k, j, baseBlock);
                            continue;
                        }
                        if (bl) {
                            queueCoordinator.setBlock(i, n + k, j, this.hybridPlotWorld.ROAD_BLOCK.toPattern());
                            continue;
                        }
                        queueCoordinator.setBlock(i, n + k, j, this.hybridPlotWorld.MAIN_BLOCK.toPattern());
                    }
                }
                if ((biomeType = this.hybridPlotWorld.G_SCH_B.get(MathMan.pair(s2, s3))) != null) {
                    queueCoordinator.setBiome(i, j, biomeType);
                    continue;
                }
                queueCoordinator.setBiome(i, j, this.hybridPlotWorld.getPlotBiome());
            }
        }
    }

    @Override
    public boolean createRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        boolean bl = false;
        if (queueCoordinator == null) {
            bl = true;
            queueCoordinator = this.hybridPlotWorld.getQueue();
        }
        super.createRoadSouth(plot, queueCoordinator);
        PlotId plotId = plot.getId();
        PlotId plotId2 = PlotId.of(plotId.getX(), plotId.getY() + 1);
        Location location = this.getPlotBottomLocAbs(plotId2);
        Location location2 = this.getPlotTopLocAbs(plotId);
        Location location3 = Location.at(this.hybridPlotWorld.getWorldName(), location.getX() - 1, this.hybridPlotWorld.getMinGenHeight(), location2.getZ() + 1);
        Location location4 = Location.at(this.hybridPlotWorld.getWorldName(), location2.getX() + 1, this.hybridPlotWorld.getMaxGenHeight(), location.getZ());
        this.resetBiome(this.hybridPlotWorld, location3, location4);
        if (!this.hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return true;
        }
        this.createSchemAbs(queueCoordinator, location3, location4, true);
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean createRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        boolean bl = false;
        if (queueCoordinator == null) {
            bl = true;
            queueCoordinator = this.hybridPlotWorld.getQueue();
        }
        super.createRoadSouthEast(plot, queueCoordinator);
        PlotId plotId = plot.getId();
        PlotId plotId2 = PlotId.of(plotId.getX() + 1, plotId.getY() + 1);
        Location location = this.getPlotTopLocAbs(plotId).add(1, 0, 1);
        Location location2 = this.getPlotBottomLocAbs(plotId2);
        this.createSchemAbs(queueCoordinator, location, location2, true);
        if (this.hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            this.createSchemAbs(queueCoordinator, location, location2, true);
        }
        return !bl || queueCoordinator.enqueue();
    }

    @Override
    public boolean clearPlot(@NonNull Plot plot, @Nullable Runnable runnable, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        if (this.regionManager.notifyClear(this) && this.regionManager.handleClear(plot, runnable, this, plotPlayer)) {
            return true;
        }
        Location location = plot.getBottomAbs();
        Location location2 = plot.getExtendedTopAbs();
        boolean bl = this.hybridPlotWorld.getType() == PlotAreaType.AUGMENTED && this.hybridPlotWorld.getTerrain() != PlotAreaTerrainType.NONE && REGENERATIVE_CLEAR;
        Pattern pattern = this.hybridPlotWorld.TOP_BLOCK.toPattern();
        Pattern pattern2 = this.hybridPlotWorld.MAIN_BLOCK.toPattern();
        Object object = this.hybridPlotWorld.PLOT_BEDROCK ? BlockTypes.BEDROCK.getDefaultState() : this.hybridPlotWorld.MAIN_BLOCK.toPattern();
        BiomeType biomeType = this.hybridPlotWorld.getPlotBiome();
        boolean bl2 = false;
        if (queueCoordinator == null) {
            bl2 = true;
            queueCoordinator = this.hybridPlotWorld.getQueue();
        }
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator.addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
        }
        if (runnable != null) {
            queueCoordinator.setCompleteTask(runnable);
        }
        if (!bl) {
            if (this.hybridPlotWorld.getMinBuildHeight() < this.hybridPlotWorld.getMinGenHeight()) {
                queueCoordinator.setCuboid(location.withY(this.hybridPlotWorld.getMinBuildHeight()), location2.withY(this.hybridPlotWorld.getMinGenHeight()), BlockTypes.AIR.getDefaultState());
            }
            queueCoordinator.setCuboid(location.withY(this.hybridPlotWorld.getMinGenHeight()), location2.withY(this.hybridPlotWorld.getMinGenHeight()), (Pattern)(this.hybridPlotWorld.PLOT_BEDROCK ? object : pattern2));
            queueCoordinator.setCuboid(location.withY(this.hybridPlotWorld.getMinGenHeight() + 1), location2.withY(this.hybridPlotWorld.PLOT_HEIGHT - 1), pattern2);
            queueCoordinator.setCuboid(location.withY(this.hybridPlotWorld.PLOT_HEIGHT), location2.withY(this.hybridPlotWorld.PLOT_HEIGHT), pattern);
            queueCoordinator.setCuboid(location.withY(this.hybridPlotWorld.PLOT_HEIGHT + 1), location2.withY(this.hybridPlotWorld.getMaxGenHeight()), BlockTypes.AIR.getDefaultState());
            if (this.hybridPlotWorld.getMaxGenHeight() < this.hybridPlotWorld.getMaxBuildHeight() - 1) {
                queueCoordinator.setCuboid(location.withY(this.hybridPlotWorld.getMaxGenHeight()), location2.withY(this.hybridPlotWorld.getMaxBuildHeight() - 1), BlockTypes.AIR.getDefaultState());
            }
            queueCoordinator.setBiomeCuboid(location, location2, biomeType);
        } else {
            queueCoordinator.setRegenRegion(new CuboidRegion(location.getBlockVector3(), location2.getBlockVector3()));
        }
        this.pastePlotSchematic(queueCoordinator, location, location2);
        return !bl2 || queueCoordinator.enqueue();
    }

    public void pastePlotSchematic(@NonNull QueueCoordinator queueCoordinator, @NonNull Location location, @NonNull Location location2) {
        if (!this.hybridPlotWorld.PLOT_SCHEMATIC) {
            return;
        }
        this.createSchemAbs(queueCoordinator, location, location2, false);
    }

    @Override
    public Location getSignLoc(@NonNull Plot plot) {
        return this.hybridPlotWorld.getSignLocation(plot);
    }

    public HybridPlotWorld getHybridPlotWorld() {
        return this.hybridPlotWorld;
    }
}

