/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.informative.DoNotUse;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.google.Inject;
import com.plotsquared.google.assistedinject.Assisted;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridPlotWorld
extends ClassicPlotWorld {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + HybridPlotWorld.class.getSimpleName()));
    private static final AffineTransform transform = new AffineTransform().rotateY(90.0);
    public boolean ROAD_SCHEMATIC_ENABLED;
    public boolean PLOT_SCHEMATIC = false;
    public short PATH_WIDTH_LOWER;
    public short PATH_WIDTH_UPPER;
    public HashMap<Integer, BaseBlock[]> G_SCH;
    public HashMap<Integer, BiomeType> G_SCH_B;
    public int SCHEM_Y;
    private int plotY;
    private int roadY;
    private Location SIGN_LOCATION;
    private File root = null;
    private int lastOverlayHeightError = Integer.MIN_VALUE;
    private List<Entity> schem3Entities = null;
    private BlockVector3 schem3MinPoint = null;
    private boolean schem1PopulationNeeded = false;
    private boolean schem2PopulationNeeded = false;
    private boolean schem3PopulationNeeded = false;
    @Inject
    private SchematicHandler schematicHandler;

    @Inject
    public HybridPlotWorld(@Assisted(value="world") String string, @com.plotsquared.core.annotation.Nullable @Assisted(value="id") String string2, @Assisted @NonNull IndependentPlotGenerator independentPlotGenerator, @com.plotsquared.core.annotation.Nullable @Assisted(value="min") PlotId plotId, @com.plotsquared.core.annotation.Nullable @Assisted(value="max") PlotId plotId2, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @NonNull GlobalBlockQueue globalBlockQueue) {
        super(string, string2, independentPlotGenerator, plotId, plotId2, yamlConfiguration, globalBlockQueue);
        PlotSquared.platform().injector().injectMembers(this);
    }

    public static BaseBlock rotate(BaseBlock baseBlock) {
        Vector3 vector3;
        Direction direction;
        int n;
        Direction direction2;
        CompoundTag compoundTag = baseBlock.getNbtData();
        if (compoundTag != null && compoundTag.containsKey("Rot") && (direction2 = MCDirections.fromRotation((int)(n = compoundTag.asInt("Rot")))) != null && (direction = Direction.findClosest((Vector3)(vector3 = transform.apply(direction2.toVector()).subtract(transform.apply(Vector3.ZERO)).normalize()), (int)(Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL))) != null) {
            CompoundTagBuilder compoundTagBuilder = compoundTag.createBuilder();
            compoundTagBuilder.putByte("Rot", (byte)MCDirections.toRotation((Direction)direction));
            baseBlock.setNbtData(compoundTagBuilder.build());
        }
        return (BaseBlock)BlockTransformExtent.transform((BlockStateHolder)baseBlock, (Transform)transform);
    }

    @Override
    protected @NonNull PlotManager createManager() {
        return new HybridPlotManager(this, PlotSquared.platform().regionManager(), PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class));
    }

    public Location getSignLocation(@NonNull Plot plot) {
        plot = plot.getBasePlot(false);
        Location location = plot.getBottomAbs();
        if (this.SIGN_LOCATION == null) {
            return location.withY(this.ROAD_HEIGHT + 1).add(-1, 0, -2);
        }
        return location.withY(0).add(this.SIGN_LOCATION.getX(), this.SIGN_LOCATION.getY(), this.SIGN_LOCATION.getZ());
    }

    @Override
    public void loadConfiguration(ConfigurationSection configurationSection) {
        super.loadConfiguration(configurationSection);
        this.PATH_WIDTH_LOWER = (this.ROAD_WIDTH & 1) == 0 ? (short)(Math.floor((float)this.ROAD_WIDTH / 2.0f) - 1.0) : (short)Math.floor((float)this.ROAD_WIDTH / 2.0f);
        this.PATH_WIDTH_UPPER = this.ROAD_WIDTH == 0 ? (short)(this.SIZE + 1) : (short)(this.PATH_WIDTH_LOWER + this.PLOT_WIDTH + 1);
        try {
            this.setupSchematics();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Settings.DEBUG) {
            Field[] fieldArray;
            LOGGER.info("- Dumping settings for ClassicPlotWorld with name {}", (Object)this.getWorldName());
            for (Field field : fieldArray = this.getClass().getFields()) {
                Object object;
                String string = field.getName().toLowerCase(Locale.ENGLISH);
                if (string.contains("g_sch")) continue;
                try {
                    boolean bl = field.canAccess(this);
                    field.setAccessible(true);
                    object = field.get(this);
                    field.setAccessible(bl);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object = String.format("Failed to parse: %s", illegalAccessException.getMessage());
                }
                LOGGER.info("-- {} = {}", (Object)string, object);
            }
        }
    }

    @Override
    public boolean isCompatible(@NonNull PlotArea plotArea) {
        if (!(plotArea instanceof SquarePlotWorld)) {
            return false;
        }
        return ((SquarePlotWorld)plotArea).PLOT_WIDTH == this.PLOT_WIDTH;
    }

    public void setupSchematics() {
        short s;
        short s2;
        BlockVector3 blockVector3;
        int n;
        short s3;
        short s4;
        int n2;
        BlockVector3 blockVector32;
        Clipboard clipboard;
        File file;
        File file2;
        File file3;
        this.G_SCH = new HashMap();
        this.G_SCH_B = new HashMap();
        this.root = FileUtils.getFile(PlotSquared.platform().getDirectory(), "schematics/GEN_ROAD_SCHEMATIC/" + this.getWorldName() + "/" + this.getId());
        if (!this.root.exists()) {
            this.root = FileUtils.getFile(PlotSquared.platform().getDirectory(), "schematics/GEN_ROAD_SCHEMATIC/" + this.getWorldName());
        }
        if (!(file3 = new File(this.root, "sideroad.schem")).exists()) {
            file3 = new File(this.root, "sideroad.schematic");
        }
        if (!(file2 = new File(this.root, "intersection.schem")).exists()) {
            file2 = new File(this.root, "intersection.schematic");
        }
        if (!(file = new File(this.root, "plot.schem")).exists()) {
            file = new File(this.root, "plot.schematic");
        }
        Schematic schematic = this.schematicHandler.getSchematic(file3);
        Schematic schematic2 = this.schematicHandler.getSchematic(file2);
        Schematic schematic3 = this.schematicHandler.getSchematic(file);
        if (schematic3 != null && !schematic3.getClipboard().getEntities().isEmpty()) {
            this.schem3Entities = new ArrayList<Entity>(schematic3.getClipboard().getEntities());
            this.schem3MinPoint = schematic3.getClipboard().getMinimumPoint();
            this.schem3PopulationNeeded = true;
        }
        int n3 = this.ROAD_WIDTH / 2;
        int n4 = this.ROAD_WIDTH & 1;
        this.SCHEM_Y = this.schematicStartHeight();
        this.plotY = this.PLOT_HEIGHT - this.SCHEM_Y;
        int n5 = Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT ? Math.min(this.ROAD_HEIGHT, this.WALL_HEIGHT) : this.ROAD_HEIGHT;
        this.roadY = n5 - this.SCHEM_Y;
        int n6 = this.getMaxGenHeight() - this.getMinGenHeight() + 1;
        int n7 = 0;
        if (schematic3 != null) {
            n7 = schematic3.getClipboard().getDimensions().getY();
            if (n7 == n6) {
                this.SCHEM_Y = this.getMinGenHeight();
                this.plotY = 0;
            } else if (!Settings.Schematics.PASTE_ON_TOP) {
                this.SCHEM_Y = this.getMinGenHeight();
                this.plotY = 0;
            }
        }
        int n8 = 0;
        if (schematic != null) {
            n8 = Math.max(schematic.getClipboard().getDimensions().getY(), schematic2.getClipboard().getDimensions().getY());
            if (n8 == n6) {
                this.SCHEM_Y = this.getMinGenHeight();
                this.roadY = 0;
                if (schematic3 != null && schematic3.getClipboard().getDimensions().getY() != n6 && Settings.Schematics.PASTE_ON_TOP) {
                    this.plotY = this.PLOT_HEIGHT - this.getMinGenHeight();
                }
            } else if (!Settings.Schematics.PASTE_ROAD_ON_TOP) {
                this.roadY = 0;
                this.SCHEM_Y = this.getMinGenHeight();
                if (schematic3 != null && Settings.Schematics.PASTE_ON_TOP) {
                    this.plotY = this.PLOT_HEIGHT - this.SCHEM_Y;
                }
            } else {
                this.roadY = n5 - this.SCHEM_Y;
            }
        }
        int n9 = Math.max(this.plotY + n7, this.roadY + n8);
        if (schematic3 != null) {
            this.PLOT_SCHEMATIC = true;
            clipboard = schematic3.getClipboard();
            blockVector32 = clipboard.getDimensions();
            n2 = blockVector32.getX();
            s4 = (short)blockVector32.getZ();
            s3 = (short)blockVector32.getY();
            if (n2 > this.PLOT_WIDTH || s4 > this.PLOT_WIDTH) {
                this.ROAD_SCHEMATIC_ENABLED = true;
            }
            int n10 = s4 < this.PLOT_WIDTH ? (this.PLOT_WIDTH - s4) / 2 : (this.PLOT_WIDTH - s4) / 2;
            n = n2 < this.PLOT_WIDTH ? (this.PLOT_WIDTH - n2) / 2 : (this.PLOT_WIDTH - n2) / 2;
            blockVector3 = clipboard.getMinimumPoint();
            for (s2 = 0; s2 < n2; s2 = (short)(s2 + 1)) {
                for (short s5 = 0; s5 < s4; s5 = (short)(s5 + 1)) {
                    for (s = 0; s < s3; s = (short)(s + 1)) {
                        BaseBlock baseBlock = clipboard.getFullBlock(BlockVector3.at((int)(s2 + blockVector3.getBlockX()), (int)(s + blockVector3.getBlockY()), (int)(s5 + blockVector3.getBlockZ())));
                        this.schem3PopulationNeeded |= baseBlock.hasNbtData();
                        this.addOverlayBlock((short)(s2 + n3 + n4 + n), (short)(s + this.plotY), (short)(s5 + n3 + n4 + n10), baseBlock, false, n9);
                    }
                    if (!clipboard.hasBiomes()) continue;
                    BiomeType biomeType = clipboard.getBiome(BlockVector2.at((int)(s2 + blockVector3.getBlockX()), (int)(s5 + blockVector3.getBlockZ())));
                    this.addOverlayBiome((short)(s2 + n3 + n4 + n), (short)(s5 + n3 + n4 + n10), biomeType);
                }
            }
            if (Settings.DEBUG) {
                LOGGER.info("- plot schematic: {}", (Object)file.getPath());
            }
        }
        if (schematic == null && schematic2 == null || this.ROAD_WIDTH == 0) {
            if (Settings.DEBUG) {
                LOGGER.info("- road schematic: false");
            }
            return;
        }
        this.ROAD_SCHEMATIC_ENABLED = true;
        clipboard = schematic.getClipboard();
        blockVector32 = clipboard.getDimensions();
        n2 = (short)blockVector32.getX();
        s4 = (short)blockVector32.getZ();
        s3 = (short)blockVector32.getY();
        if (!Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT) {
            s3 = (short)(s3 + Math.max(this.ROAD_HEIGHT - this.WALL_HEIGHT, 0));
        }
        BlockVector3 blockVector33 = clipboard.getMinimumPoint();
        for (n = 0; n < n2; n = (short)(n + 1)) {
            for (short s6 = 0; s6 < s4; s6 = (short)(s6 + 1)) {
                for (s2 = 0; s2 < s3; s2 = (short)(s2 + 1)) {
                    BaseBlock baseBlock = clipboard.getFullBlock(BlockVector3.at((int)(n + blockVector33.getBlockX()), (int)(s2 + blockVector33.getBlockY()), (int)(s6 + blockVector33.getBlockZ())));
                    this.schem1PopulationNeeded |= baseBlock.hasNbtData();
                    this.addOverlayBlock((short)(n - n3), (short)(s2 + this.roadY), (short)(s6 + n3 + n4), baseBlock, false, n9);
                    this.addOverlayBlock((short)(s6 + n3 + n4), (short)(s2 + this.roadY), (short)(n3 - n + (n4 - 1)), baseBlock, true, n9);
                }
                if (!clipboard.hasBiomes()) continue;
                BiomeType biomeType = clipboard.getBiome(BlockVector2.at((int)(n + blockVector33.getBlockX()), (int)(s6 + blockVector33.getBlockZ())));
                this.addOverlayBiome((short)(n - n3), (short)(s6 + n3 + n4), biomeType);
                this.addOverlayBiome((short)(s6 + n3 + n4), (short)(n3 - n + (n4 - 1)), biomeType);
            }
        }
        Clipboard clipboard2 = schematic2.getClipboard();
        blockVector3 = clipboard2.getDimensions();
        s2 = (short)blockVector3.getX();
        short s7 = (short)blockVector3.getZ();
        s = (short)blockVector3.getY();
        if (!Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT) {
            s = (short)(s + Math.max(this.ROAD_HEIGHT - this.WALL_HEIGHT, 0));
        }
        blockVector33 = clipboard2.getMinimumPoint();
        for (short s8 = 0; s8 < s2; s8 = (short)(s8 + 1)) {
            for (short s9 = 0; s9 < s7; s9 = (short)(s9 + 1)) {
                for (short s10 = 0; s10 < s; s10 = (short)(s10 + 1)) {
                    BaseBlock baseBlock = clipboard2.getFullBlock(BlockVector3.at((int)(s8 + blockVector33.getBlockX()), (int)(s10 + blockVector33.getBlockY()), (int)(s9 + blockVector33.getBlockZ())));
                    this.schem2PopulationNeeded |= baseBlock.hasNbtData();
                    this.addOverlayBlock((short)(s8 - n3), (short)(s10 + this.roadY), (short)(s9 - n3), baseBlock, false, n9);
                }
                if (!clipboard2.hasBiomes()) continue;
                BiomeType biomeType = clipboard2.getBiome(BlockVector2.at((int)(s8 + blockVector33.getBlockX()), (int)(s9 + blockVector33.getBlockZ())));
                this.addOverlayBiome((short)(s8 - n3), (short)(s9 - n3), biomeType);
            }
        }
    }

    private void addOverlayBlock(short s, short s2, short s3, BaseBlock baseBlock, boolean bl, int n) {
        if (s3 < 0) {
            s3 = (short)(s3 + this.SIZE);
        } else if (s3 >= this.SIZE) {
            s3 = (short)(s3 - this.SIZE);
        }
        if (s < 0) {
            s = (short)(s + this.SIZE);
        } else if (s >= this.SIZE) {
            s = (short)(s - this.SIZE);
        }
        if (bl) {
            baseBlock = HybridPlotWorld.rotate(baseBlock);
        }
        int n3 = MathMan.pair(s, s3);
        BaseBlock[] baseBlockArray = this.G_SCH.computeIfAbsent(n3, n2 -> new BaseBlock[n]);
        if (s2 >= n) {
            if (s2 > this.lastOverlayHeightError) {
                this.lastOverlayHeightError = s2;
                LOGGER.error("Error adding overlay block in world {}. `y > height`. y={}, height={}", (Object)this.getWorldName(), (Object)s2, (Object)n);
            }
            return;
        }
        baseBlockArray[s2] = baseBlock;
    }

    private void addOverlayBiome(short s, short s2, BiomeType biomeType) {
        if (s2 < 0) {
            s2 = (short)(s2 + this.SIZE);
        } else if (s2 >= this.SIZE) {
            s2 = (short)(s2 - this.SIZE);
        }
        if (s < 0) {
            s = (short)(s + this.SIZE);
        } else if (s >= this.SIZE) {
            s = (short)(s - this.SIZE);
        }
        int n = MathMan.pair(s, s2);
        this.G_SCH_B.put(n, biomeType);
    }

    @DoNotUse
    public @Nullable List<Entity> getPlotSchematicEntities() {
        return this.schem3Entities;
    }

    @DoNotUse
    public @Nullable BlockVector3 getPlotSchematicMinPoint() {
        return this.schem3MinPoint;
    }

    @DoNotUse
    public boolean populationNeeded() {
        return this.schem1PopulationNeeded || this.schem2PopulationNeeded || this.schem3PopulationNeeded;
    }

    public @Nullable File getSchematicRoot() {
        return this.root;
    }

    public int getPlotYStart() {
        return this.SCHEM_Y + this.plotY;
    }

    public int getRoadYStart() {
        return this.SCHEM_Y + this.roadY;
    }
}

