/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.sk89q.worldedit.world.biome.BiomeType;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class IndependentPlotGenerator {
    public abstract String getName();

    public abstract void generateChunk(ZeroedDelegateScopedQueueCoordinator var1, PlotArea var2, boolean var3);

    public void populateChunk(ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, PlotArea plotArea) {
    }

    public abstract PlotArea getNewPlotArea(String var1, String var2, PlotId var3, PlotId var4);

    public void processAreaSetup(PlotAreaBuilder plotAreaBuilder) {
    }

    public abstract void initialize(PlotArea var1);

    public <T> GeneratorWrapper<T> specify(@NonNull String string) {
        return PlotSquared.platform().wrapPlotGenerator(string, this);
    }

    public abstract BiomeType getBiome(PlotArea var1, int var2, int var3, int var4);

    public String toString() {
        return this.getName();
    }
}

