/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.HttpClient;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;

final class ClientSettings {
    private final Collection<Consumer<HttpClient.WrappedRequestBuilder>> decorators = new LinkedList<Consumer<HttpClient.WrappedRequestBuilder>>();
    private String baseURL = "";
    private EntityMapper entityMapper;

    ClientSettings() {
    }

    @NotNull
    String getBaseURL() {
        return this.baseURL;
    }

    @Nullable
    EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    @NotNull
    Collection<Consumer<HttpClient.WrappedRequestBuilder>> getRequestDecorators() {
        return Collections.unmodifiableCollection(this.decorators);
    }

    void setBaseURL(@NotNull String string) {
        this.baseURL = Objects.requireNonNull(string, "Base URL may not be null");
    }

    void setEntityMapper(@Nullable EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
    }

    void addDecorator(@NotNull Consumer<HttpClient.WrappedRequestBuilder> consumer) {
        this.decorators.add(Objects.requireNonNull(consumer, "Decorator may not be null"));
    }
}

