/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.ClientSettings;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.HttpMethod;
import com.plotsquared.core.http.HttpRequest;
import com.plotsquared.core.http.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class HttpClient {
    private final EntityMapper mapper = new EntityMapper();
    private final ClientSettings settings;

    private HttpClient(@NotNull ClientSettings clientSettings) {
        this.settings = Objects.requireNonNull(clientSettings);
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NotNull
    public WrappedRequestBuilder get(@NotNull String string) {
        Objects.requireNonNull(string, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.GET, string);
    }

    @NotNull
    public WrappedRequestBuilder post(@NotNull String string) {
        Objects.requireNonNull(string, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.POST, string);
    }

    @NotNull
    public WrappedRequestBuilder put(@NotNull String string) {
        Objects.requireNonNull(string, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.PUT, string);
    }

    @NotNull
    public WrappedRequestBuilder head(@NotNull String string) {
        Objects.requireNonNull(string, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.HEAD, string);
    }

    @NotNull
    public WrappedRequestBuilder delete(@NotNull String string) {
        Objects.requireNonNull(string, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.DELETE, string);
    }

    @NotNull
    public WrappedRequestBuilder patch(@NotNull String string) {
        Objects.requireNonNull(string, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.PATCH, string);
    }

    @NotNull
    public EntityMapper getMapper() {
        return this.mapper;
    }

    public static final class Builder {
        private final ClientSettings settings = new ClientSettings();

        private Builder() {
        }

        @NotNull
        public Builder withBaseURL(@NotNull String string) {
            Objects.requireNonNull(string, "Base URL may not be null");
            if (string.endsWith("/")) {
                this.settings.setBaseURL(string.substring(0, string.length() - 1));
            } else {
                this.settings.setBaseURL(string);
            }
            return this;
        }

        @NotNull
        public Builder withEntityMapper(@Nullable EntityMapper entityMapper) {
            this.settings.setEntityMapper(entityMapper);
            return this;
        }

        @NotNull
        public Builder withDecorator(@NotNull Consumer<WrappedRequestBuilder> consumer) {
            this.settings.addDecorator(Objects.requireNonNull(consumer, "Decorator may not be null"));
            return this;
        }

        public HttpClient build() {
            return new HttpClient(this.settings);
        }
    }

    public final class WrappedRequestBuilder {
        private final HttpRequest.Builder builder = HttpRequest.newBuilder();
        private final Map<Integer, Consumer<HttpResponse>> consumers = new HashMap<Integer, Consumer<HttpResponse>>();
        private Consumer<HttpResponse> other = httpResponse -> {};
        private Consumer<Throwable> exceptionHandler = null;

        private WrappedRequestBuilder(@NotNull HttpMethod httpMethod, String string) {
            if (string.startsWith("/")) {
                string = string.length() == 1 ? "" : string.substring(1);
            }
            string = HttpClient.this.settings.getBaseURL() + '/' + string;
            try {
                URL uRL = new URL(string);
                this.builder.withURL(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
            this.builder.withMethod(httpMethod);
            if (HttpClient.this.settings.getEntityMapper() != null) {
                this.builder.withMapper(HttpClient.this.settings.getEntityMapper());
            }
        }

        @NotNull
        public WrappedRequestBuilder withInput(@NotNull Supplier<Object> supplier) {
            this.builder.withInput(supplier);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder withMapper(@NotNull EntityMapper entityMapper) {
            this.builder.withMapper(entityMapper);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder withHeader(@NotNull String string, @NotNull String string2) {
            this.builder.withHeader(string, string2);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder onStatus(int n, @NotNull Consumer<HttpResponse> consumer) {
            this.consumers.put(n, consumer);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder onRemaining(@NotNull Consumer<HttpResponse> consumer) {
            this.other = consumer;
            return this;
        }

        @NotNull
        public WrappedRequestBuilder onException(@NotNull Consumer<Throwable> consumer) {
            this.exceptionHandler = consumer;
            this.builder.onException(consumer);
            return this;
        }

        @Nullable
        public HttpResponse execute() {
            for (Consumer<WrappedRequestBuilder> object : HttpClient.this.settings.getRequestDecorators()) {
                object.accept(this);
            }
            try {
                HttpResponse httpResponse;
                Throwable[] throwableArray = new Throwable[1];
                if (this.exceptionHandler == null) {
                    this.builder.onException(throwable -> {
                        throwableArray[0] = throwable;
                    });
                }
                if ((httpResponse = this.builder.build().executeRequest()) != null) {
                    Consumer<HttpResponse> consumer = this.consumers.getOrDefault(httpResponse.getStatusCode(), this.other);
                    consumer.accept(httpResponse);
                }
                if (throwableArray[0] != null) {
                    if (throwableArray[0] instanceof RuntimeException) {
                        throw (RuntimeException)throwableArray[0];
                    }
                    throw new RuntimeException(throwableArray[0]);
                }
                return httpResponse;
            }
            catch (Exception exception) {
                if (this.exceptionHandler == null) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception);
                }
                return null;
            }
        }
    }
}

