/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotTitle;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.comment.CommentManager;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DenyExitFlag;
import com.plotsquared.core.plot.flag.implementations.FarewellFlag;
import com.plotsquared.core.plot.flag.implementations.FeedFlag;
import com.plotsquared.core.plot.flag.implementations.FlyFlag;
import com.plotsquared.core.plot.flag.implementations.GamemodeFlag;
import com.plotsquared.core.plot.flag.implementations.GreetingFlag;
import com.plotsquared.core.plot.flag.implementations.GuestGamemodeFlag;
import com.plotsquared.core.plot.flag.implementations.HealFlag;
import com.plotsquared.core.plot.flag.implementations.MusicFlag;
import com.plotsquared.core.plot.flag.implementations.NotifyEnterFlag;
import com.plotsquared.core.plot.flag.implementations.NotifyLeaveFlag;
import com.plotsquared.core.plot.flag.implementations.PlotTitleFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.flag.implementations.TimeFlag;
import com.plotsquared.core.plot.flag.implementations.TitlesFlag;
import com.plotsquared.core.plot.flag.implementations.WeatherFlag;
import com.plotsquared.core.plot.flag.types.TimedFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotListener {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final HashMap<UUID, Interval> feedRunnable = new HashMap();
    private final HashMap<UUID, Interval> healRunnable = new HashMap();
    private final Map<UUID, List<StatusEffect>> playerEffects = new HashMap<UUID, List<StatusEffect>>();
    private final EventDispatcher eventDispatcher;

    public PlotListener(@Nullable EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void startRunnable() {
        TaskManager.runTaskRepeat(() -> {
            PlotPlayer<?> plotPlayer;
            Object object;
            Map.Entry<UUID, Interval> entry;
            Iterator<Map.Entry<UUID, Interval>> iterator;
            if (!this.healRunnable.isEmpty()) {
                iterator = this.healRunnable.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    object = entry.getValue();
                    ++((Interval)object).count;
                    if (((Interval)object).count != ((Interval)object).interval) continue;
                    ((Interval)object).count = 0;
                    plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(entry.getKey());
                    if (plotPlayer == null) {
                        iterator.remove();
                        continue;
                    }
                    double d = PlotSquared.platform().worldUtil().getHealth(plotPlayer);
                    if (d == (double)((Interval)object).max) continue;
                    PlotSquared.platform().worldUtil().setHealth(plotPlayer, Math.min(d + (double)((Interval)object).amount, (double)((Interval)object).max));
                }
            }
            if (!this.feedRunnable.isEmpty()) {
                iterator = this.feedRunnable.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    object = entry.getValue();
                    ++((Interval)object).count;
                    if (((Interval)object).count != ((Interval)object).interval) continue;
                    ((Interval)object).count = 0;
                    plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(entry.getKey());
                    if (plotPlayer == null) {
                        iterator.remove();
                        continue;
                    }
                    int n = PlotSquared.platform().worldUtil().getFoodLevel(plotPlayer);
                    if (n == ((Interval)object).max) continue;
                    PlotSquared.platform().worldUtil().setFoodLevel(plotPlayer, Math.min(n + ((Interval)object).amount, ((Interval)object).max));
                }
            }
            if (!this.playerEffects.isEmpty()) {
                long l = System.currentTimeMillis();
                object = this.playerEffects.entrySet().iterator();
                while (object.hasNext()) {
                    plotPlayer = (Map.Entry)object.next();
                    List list = (List)plotPlayer.getValue();
                    list.removeIf(statusEffect -> l > statusEffect.expiresAt);
                    if (!list.isEmpty()) continue;
                    object.remove();
                }
            }
        }, TaskTime.seconds(1L));
    }

    public boolean plotEntry(PlotPlayer<?> plotPlayer, Plot plot) {
        if (plot.isDenied(plotPlayer.getUUID()) && !plotPlayer.hasPermission("plots.admin.entry.denied")) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("deny.no_enter"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.toString()))));
            return false;
        }
        try (Object object = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            Plot plot2 = object.get().orElse(null);
            if (plot2 != null && !plot2.getId().equals(plot.getId())) {
                this.plotExit(plotPlayer, plot2);
            }
            if (PlotSquared.platform().expireManager() != null) {
                PlotSquared.platform().expireManager().handleEntry(plotPlayer, plot);
            }
            object.set(plot);
        }
        this.eventDispatcher.callEntry(plotPlayer, plot);
        if (plot.hasOwner()) {
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            block54: {
                long l;
                GameMode gameMode;
                Object object4;
                Object object5;
                object = (TitlesFlag.TitlesFlagValue)((Object)plot.getFlag(TitlesFlag.class));
                bl = object == TitlesFlag.TitlesFlagValue.NONE ? Settings.Titles.DISPLAY_TITLES : object == TitlesFlag.TitlesFlagValue.TRUE;
                String string = (String)plot.getFlag(GreetingFlag.class);
                if (!string.isEmpty()) {
                    if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
                        plot.format(StaticCaption.of(string), plotPlayer, false).thenAcceptAsync(caption -> plotPlayer.sendMessage((Caption)caption, new TagResolver[0]));
                    } else {
                        plot.format(StaticCaption.of(string), plotPlayer, false).thenAcceptAsync(caption -> plotPlayer.sendActionBar((Caption)caption, new TagResolver[0]));
                    }
                }
                if (((Boolean)plot.getFlag(NotifyEnterFlag.class)).booleanValue() && !plotPlayer.hasPermission("plots.flag.notify-enter.bypass")) {
                    for (UUID uUID : plot.getOwners()) {
                        object5 = PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
                        if (object5 == null || ((PlotPlayer)object5).getUUID().equals(plotPlayer.getUUID()) || !((PlotPlayer)object5).canSee(plotPlayer)) continue;
                        object4 = TranslatableCaption.of("notification.notify_enter");
                        this.notifyPlotOwner(plotPlayer, plot, (PlotPlayer<?>)object5, (Caption)object4);
                    }
                }
                FlyFlag.FlyStatus flyStatus = (FlyFlag.FlyStatus)((Object)plot.getFlag(FlyFlag.class));
                if (!plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_FLIGHT) && flyStatus != FlyFlag.FlyStatus.DEFAULT) {
                    boolean bl2 = plotPlayer.getFlight();
                    if (bl2 != ((object5 = plotPlayer.getGameMode()) == GameModes.CREATIVE || object5 == GameModes.SPECTATOR)) {
                        object4 = plotPlayer.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_FLIGHT);
                        try {
                            ((MetaDataAccess)object4).set(plotPlayer.getFlight());
                        }
                        finally {
                            if (object4 != null) {
                                ((MetaDataAccess)object4).close();
                            }
                        }
                    }
                    plotPlayer.setFlight(flyStatus == FlyFlag.FlyStatus.ENABLED);
                }
                if (!(gameMode = (GameMode)plot.getFlag(GamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) && plotPlayer.getGameMode() != gameMode) {
                    if (!plotPlayer.hasPermission("plots.gamemode.bypass")) {
                        plotPlayer.setGameMode(gameMode);
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("gamemode.gamemode_was_bypassed"), TagResolver.builder().tag("gamemode", Tag.inserting(Component.text(gameMode.toString()))).tag("plot", Tag.inserting(Component.text(plot.getId().toString()))).build());
                    }
                }
                if (!(object5 = (GameMode)plot.getFlag(GuestGamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) && plotPlayer.getGameMode() != object5 && !plot.isAdded(plotPlayer.getUUID())) {
                    if (!plotPlayer.hasPermission("plots.gamemode.bypass")) {
                        plotPlayer.setGameMode((GameMode)object5);
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("gamemode.gamemode_was_bypassed"), TagResolver.builder().tag("gamemode", Tag.inserting(Component.text(object5.toString()))).tag("plot", Tag.inserting(Component.text(plot.getId().toString()))).build());
                    }
                }
                if ((l = ((Long)plot.getFlag(TimeFlag.class)).longValue()) != (Long)TimeFlag.TIME_DISABLED.getValue() && !plotPlayer.getAttribute("disabletime")) {
                    try {
                        plotPlayer.setTime(l);
                    }
                    catch (Exception exception) {
                        object3 = GlobalFlagContainer.getInstance().getFlag(TimeFlag.class);
                        object2 = this.eventDispatcher.callFlagRemove((PlotFlag<?, ?>)object3, plot);
                        if (((PlotFlagRemoveEvent)object2).getEventResult() == Result.DENY) break block54;
                        plot.removeFlag(((PlotFlagEvent)object2).getFlag());
                    }
                }
            }
            plotPlayer.setWeather((PlotWeather)((Object)plot.getFlag(WeatherFlag.class)));
            ItemType itemType = (ItemType)plot.getFlag(MusicFlag.class);
            object3 = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_MUSIC);
            try {
                if (itemType != null) {
                    object2 = itemType.getId();
                    if (((String)object2).contains("disc") || itemType == ItemTypes.AIR) {
                        object = plotPlayer.getLocation();
                        Location location2 = ((MetaDataAccess)object3).get().orElse(null);
                        if (location2 != null) {
                            plot.getCenter(location -> plotPlayer.playMusic(location.add(0, Short.MAX_VALUE, 0), itemType));
                            if (itemType == ItemTypes.AIR) {
                                ((MetaDataAccess)object3).remove();
                            }
                        }
                        if (itemType != ItemTypes.AIR) {
                            try {
                                ((MetaDataAccess)object3).set(object);
                                plot.getCenter(location -> plotPlayer.playMusic(location.add(0, Short.MAX_VALUE, 0), itemType));
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    ((MetaDataAccess)object3).get().ifPresent(arg_0 -> PlotListener.lambda$plotEntry$6((MetaDataAccess)object3, plotPlayer, arg_0));
                }
            }
            finally {
                if (object3 != null) {
                    ((MetaDataAccess)object3).close();
                }
            }
            CommentManager.sendTitle(plotPlayer, plot);
            if (bl && !plotPlayer.getAttribute("disabletitles")) {
                boolean bl3;
                object = (PlotTitle)plot.getFlag(PlotTitleFlag.class);
                if (((PlotTitle)object).title() != null && ((PlotTitle)object).subtitle() != null) {
                    object3 = ((PlotTitle)object).title();
                    object2 = ((PlotTitle)object).subtitle();
                    bl3 = true;
                } else {
                    object3 = "";
                    object2 = "";
                    bl3 = false;
                }
                if (bl3 || !((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue() || Settings.Titles.DISPLAY_DEFAULT_ON_SERVER_PLOT) {
                    TaskManager.runTaskLaterAsync(() -> PlotListener.lambda$plotEntry$9(plotPlayer, plot, bl3, (String)object3, (String)object2), TaskTime.seconds(1L));
                }
            }
            if (((TimedFlag.Timed)(object3 = (TimedFlag.Timed)plot.getFlag(FeedFlag.class))).interval() != 0 && (Integer)((TimedFlag.Timed)object3).value() != 0) {
                this.feedRunnable.put(plotPlayer.getUUID(), new Interval(((TimedFlag.Timed)object3).interval(), (Integer)((TimedFlag.Timed)object3).value(), 20));
            }
            if (((TimedFlag.Timed)(object2 = (TimedFlag.Timed)plot.getFlag(HealFlag.class))).interval() != 0 && (Integer)((TimedFlag.Timed)object2).value() != 0) {
                this.healRunnable.put(plotPlayer.getUUID(), new Interval(((TimedFlag.Timed)object2).interval(), (Integer)((TimedFlag.Timed)object2).value(), 20));
            }
            return true;
        }
        return true;
    }

    public boolean plotExit(PlotPlayer<?> plotPlayer, Plot plot) {
        block46: {
            try (MetaDataAccess<Plot> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Plot plot2 = metaDataAccess.remove();
                this.eventDispatcher.callLeave(plotPlayer, plot);
                List<StatusEffect> list = this.playerEffects.remove(plotPlayer.getUUID());
                if (list != null) {
                    long l = System.currentTimeMillis();
                    list.forEach(statusEffect -> {
                        if (l <= statusEffect.expiresAt) {
                            plotPlayer.removeEffect(statusEffect.name);
                        }
                    });
                }
                if (!plot.hasOwner()) break block46;
                PlotArea plotArea = plot.getArea();
                if (plotArea == null) {
                    boolean bl = true;
                    return bl;
                }
                try (Object object5 = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_KICK);){
                    if (((Boolean)plot.getFlag(DenyExitFlag.class)).booleanValue() && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_EXIT_DENIED) && !((MetaDataAccess)object5).get().orElse(false).booleanValue()) {
                        if (plot2 != null) {
                            metaDataAccess.set(plot2);
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                if (!(((GameMode)plot.getFlag(GamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) && ((GameMode)plot.getFlag(GuestGamemodeFlag.class)).equals((Object)GamemodeFlag.DEFAULT) || plotPlayer.getGameMode() == plotArea.getGameMode())) {
                    if (!plotPlayer.hasPermission("plots.gamemode.bypass")) {
                        plotPlayer.setGameMode(plotArea.getGameMode());
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("gamemode.gamemode_was_bypassed"), TagResolver.builder().tag("gamemode", Tag.inserting(Component.text(plotArea.getGameMode().toString()))).tag("plot", Tag.inserting(Component.text(plot.toString()))).build());
                    }
                }
                if (!((String)(object5 = (String)plot.getFlag(FarewellFlag.class))).isEmpty()) {
                    if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
                        plot.format(StaticCaption.of((String)object5), plotPlayer, false).thenAcceptAsync(caption -> plotPlayer.sendMessage((Caption)caption, new TagResolver[0]));
                    } else {
                        plot.format(StaticCaption.of((String)object5), plotPlayer, false).thenAcceptAsync(caption -> plotPlayer.sendActionBar((Caption)caption, new TagResolver[0]));
                    }
                }
                if (((Boolean)plot.getFlag(NotifyLeaveFlag.class)).booleanValue() && !plotPlayer.hasPermission("plots.flag.notify-leave.bypass")) {
                    object4 = plot.getOwners().iterator();
                    while (object4.hasNext()) {
                        object3 = (UUID)object4.next();
                        object2 = PlotSquared.platform().playerManager().getPlayerIfExists((UUID)object3);
                        if (object2 == null || ((PlotPlayer)object2).getUUID().equals(plotPlayer.getUUID()) || !((PlotPlayer)object2).canSee(plotPlayer)) continue;
                        object = TranslatableCaption.of("notification.notify_leave");
                        this.notifyPlotOwner(plotPlayer, plot, (PlotPlayer<?>)object2, (Caption)object);
                    }
                }
                if ((object4 = (FlyFlag.FlyStatus)((Object)plot.getFlag(FlyFlag.class))) != FlyFlag.FlyStatus.DEFAULT) {
                    object3 = plotPlayer.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_FLIGHT);
                    try {
                        object2 = ((MetaDataAccess)object3).get();
                        if (((Optional)object2).isPresent()) {
                            plotPlayer.setFlight((Boolean)((Optional)object2).get());
                            ((MetaDataAccess)object3).remove();
                        } else {
                            object = plotPlayer.getGameMode();
                            if (object == GameModes.SURVIVAL || object == GameModes.ADVENTURE) {
                                plotPlayer.setFlight(false);
                            } else if (!plotPlayer.getFlight()) {
                                plotPlayer.setFlight(true);
                            }
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((MetaDataAccess)object3).close();
                        }
                    }
                }
                if (((Long)plot.getFlag(TimeFlag.class)).longValue() != ((Long)TimeFlag.TIME_DISABLED.getValue()).longValue()) {
                    plotPlayer.setTime(Long.MAX_VALUE);
                }
                if ((object3 = (PlotWeather)((Object)plot.getFlag(WeatherFlag.class))) != PlotWeather.OFF) {
                    plotPlayer.setWeather(PlotWeather.WORLD);
                }
                object2 = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_MUSIC);
                try {
                    ((MetaDataAccess)object2).get().ifPresent(location -> {
                        object2.remove();
                        plotPlayer.playMusic((Location)location, ItemTypes.AIR);
                    });
                }
                finally {
                    if (object2 != null) {
                        ((MetaDataAccess)object2).close();
                    }
                }
                this.feedRunnable.remove(plotPlayer.getUUID());
                this.healRunnable.remove(plotPlayer.getUUID());
            }
        }
        return true;
    }

    private void notifyPlotOwner(PlotPlayer<?> plotPlayer, Plot plot, PlotPlayer<?> plotPlayer2, Caption caption) {
        TagResolver tagResolver = TagResolver.builder().tag("player", Tag.inserting(Component.text(plotPlayer.getName()))).tag("plot", Tag.inserting(Component.text(plot.getId().toString()))).tag("area", Tag.inserting(Component.text(String.valueOf(plot.getArea())))).build();
        if (!Settings.Chat.NOTIFICATION_AS_ACTIONBAR) {
            plotPlayer2.sendMessage(caption, tagResolver);
        } else {
            plotPlayer2.sendActionBar(caption, tagResolver);
        }
    }

    public void logout(UUID uUID) {
        this.feedRunnable.remove(uUID);
        this.healRunnable.remove(uUID);
        this.playerEffects.remove(uUID);
    }

    public void addEffect(@NonNull UUID uUID, @NonNull String string, long l) {
        List list = this.playerEffects.getOrDefault(uUID, new ArrayList());
        list.removeIf(statusEffect -> statusEffect.name.equals(string));
        if (l != -1L) {
            list.add(new StatusEffect(string, l));
        }
        this.playerEffects.put(uUID, list);
    }

    private static /* synthetic */ void lambda$plotEntry$9(PlotPlayer plotPlayer, Plot plot, boolean bl, String string, String string2) {
        Plot plot2;
        try (Object object = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            plot2 = ((MetaDataAccess)object).get().orElse(null);
        }
        if (plot2 != null && plot.getId().equals(plot2.getId()) && plot.hasOwner()) {
            object = plot.getOwnerAbs();
            Caption caption2 = bl ? StaticCaption.of(string) : TranslatableCaption.of("titles.title_entered_plot");
            Caption caption3 = bl ? StaticCaption.of(string2) : TranslatableCaption.of("titles.title_entered_plot_sub");
            CompletionStage completionStage = PlotSquared.platform().playerManager().getUsernameCaption((UUID)object).thenApply(caption -> TagResolver.builder().tag("owner", Tag.inserting(caption.toComponent(plotPlayer))).tag("plot", Tag.inserting(Component.text(plot2.getId().toString()))).tag("world", Tag.inserting(Component.text(plotPlayer.getLocation().getWorldName()))).tag("alias", Tag.inserting(Component.text(plot.getAlias()))).build());
            ((CompletableFuture)completionStage).whenComplete((tagResolver, throwable) -> {
                if (Settings.Titles.TITLES_AS_ACTIONBAR) {
                    plotPlayer.sendActionBar(caption2, (TagResolver)tagResolver);
                } else {
                    plotPlayer.sendTitle(caption2, caption3, (TagResolver)tagResolver);
                }
            });
        }
    }

    private static /* synthetic */ void lambda$plotEntry$6(MetaDataAccess metaDataAccess, PlotPlayer plotPlayer, Location location) {
        metaDataAccess.remove();
        plotPlayer.playMusic(location, ItemTypes.AIR);
    }

    private static class Interval {
        final int interval;
        final int amount;
        final int max;
        int count = 0;

        Interval(int n, int n2, int n3) {
            this.interval = n;
            this.amount = n2;
            this.max = n3;
        }
    }

    private record StatusEffect(@NonNull String name, long expiresAt) {
    }
}

